/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Entity;
import com.artemis.World;

public abstract class BaseSystem {
    protected World world;
    boolean passive;
    boolean enabled = true;

    protected void begin() {
    }

    public final void process() {
        if (this.enabled && this.checkProcessing()) {
            this.begin();
            this.processSystem();
            this.end();
        }
    }

    protected abstract void processSystem();

    protected void end() {
    }

    protected boolean checkProcessing() {
        return true;
    }

    protected void initialize() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void setWorld(World world) {
        this.world = world;
    }

    public boolean isPassive() {
        return this.passive;
    }

    protected void setPassive(boolean passive) {
        this.passive = passive;
    }

    protected void dispose() {
    }

    protected final Entity createFlyweightEntity() {
        return Entity.createFlyweight(this.world);
    }
}

