/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.gradle;

import com.artemis.Weaver;
import com.artemis.WeaverLog;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class ArtemisWeavingTask
extends DefaultTask {
    @Optional
    @Deprecated
    @OutputDirectory
    private File classesDir;
    @Optional
    @OutputDirectories
    private FileCollection classesDirs;
    @Input
    private boolean enablePooledWeaving;
    @Input
    private boolean enableArtemisPlugin;
    @Input
    private boolean optimizeEntitySystems;
    @Input
    private boolean generateLinkMutators;

    @TaskAction
    public void weave() {
        this.getLogger().info("Artemis plugin started.");
        if (!this.enableArtemisPlugin) {
            this.getLogger().info("Plugin disabled via 'enableArtemisPlugin' set to false.");
            return;
        }
        long start = System.currentTimeMillis();
        Logger log = this.getLogger();
        log.info("CONFIGURATION");
        log.info(WeaverLog.LINE.replaceAll("\n", ""));
        log.info(WeaverLog.format((String)"enablePooledWeaving", (Object)this.enablePooledWeaving));
        log.info(WeaverLog.format((String)"generateLinkMutators", (Object)this.generateLinkMutators));
        log.info(WeaverLog.format((String)"optimizeEntitySystems", (Object)this.optimizeEntitySystems));
        if (this.classesDirs != null && !this.classesDirs.isEmpty()) {
            log.info(WeaverLog.format((String)"outputDirectories", (Object)this.classesDirs.getFiles()));
        } else {
            log.info(WeaverLog.format((String)"outputDirectory", (Object)this.classesDir));
        }
        log.info(WeaverLog.LINE.replaceAll("\n", ""));
        Weaver.enablePooledWeaving((boolean)this.enablePooledWeaving);
        Weaver.generateLinkMutators((boolean)this.generateLinkMutators);
        Weaver.optimizeEntitySystems((boolean)this.optimizeEntitySystems);
        Weaver weaver = this.classesDirs != null && !this.classesDirs.isEmpty() ? new Weaver(this.classesDirs.getFiles()) : new Weaver(this.classesDir);
        WeaverLog processed = weaver.execute();
        for (String s : processed.getFormattedLog().split("\n")) {
            log.info(s);
        }
    }

    public boolean isEnableArtemisPlugin() {
        return this.enableArtemisPlugin;
    }

    public void setEnableArtemisPlugin(boolean enableArtemisPlugin) {
        this.enableArtemisPlugin = enableArtemisPlugin;
    }

    public boolean isEnablePooledWeaving() {
        return this.enablePooledWeaving;
    }

    public void setEnablePooledWeaving(boolean enablePooledWeaving) {
        this.enablePooledWeaving = enablePooledWeaving;
    }

    public void setGenerateLinkMutators(boolean generateLinkMutators) {
        this.generateLinkMutators = generateLinkMutators;
    }

    public boolean isGenerateLinkMutators() {
        return this.generateLinkMutators;
    }

    public boolean isOptimizeEntitySystems() {
        return this.optimizeEntitySystems;
    }

    public void setOptimizeEntitySystems(boolean optimizeEntitySystems) {
        this.optimizeEntitySystems = optimizeEntitySystems;
    }

    public File getClassesDir() {
        return this.classesDir;
    }

    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }

    public FileCollection getClassesDirs() {
        return this.classesDirs;
    }

    public void setClassesDirs(FileCollection classesDirs) {
        this.classesDirs = classesDirs;
    }
}

