/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.gradle;

import com.artemis.Weaver;
import com.artemis.WeaverLog;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class ArtemisWeavingTask
extends DefaultTask {
    @OutputDirectory
    private File classesDir;
    @Input
    private boolean ideFriendlyPacking;
    @Input
    private boolean enablePooledWeaving;
    @Input
    private boolean enableArtemisPlugin;
    @Input
    private boolean optimizeEntitySystems;

    @TaskAction
    public void weave() {
        this.getLogger().info("Artemis plugin started.");
        if (!this.enableArtemisPlugin) {
            this.getLogger().info("Plugin disabled via 'enableArtemisPlugin' set to false.");
            return;
        }
        long start = System.currentTimeMillis();
        Logger log = this.getLogger();
        log.info("CONFIGURATION");
        log.info(WeaverLog.LINE.replaceAll("\n", ""));
        log.info(WeaverLog.format((String)"ideFriendlyPacking", (Object)this.ideFriendlyPacking));
        log.info(WeaverLog.format((String)"enablePooledWeaving", (Object)this.enablePooledWeaving));
        log.info(WeaverLog.format((String)"optimizeEntitySystems", (Object)this.optimizeEntitySystems));
        log.info(WeaverLog.format((String)"outputDirectory", (Object)this.classesDir));
        log.info(WeaverLog.LINE.replaceAll("\n", ""));
        Weaver.retainFieldsWhenPacking((boolean)this.ideFriendlyPacking);
        Weaver.enablePooledWeaving((boolean)this.enablePooledWeaving);
        Weaver.optimizeEntitySystems((boolean)this.optimizeEntitySystems);
        Weaver weaver = new Weaver(this.classesDir);
        WeaverLog processed = weaver.execute();
        for (String s : processed.getFormattedLog().split("\n")) {
            log.info(s);
        }
    }

    public boolean isEnableArtemisPlugin() {
        return this.enableArtemisPlugin;
    }

    public void setEnableArtemisPlugin(boolean enableArtemisPlugin) {
        this.enableArtemisPlugin = enableArtemisPlugin;
    }

    public boolean isIdeFriendlyPacking() {
        return this.ideFriendlyPacking;
    }

    public void setIdeFriendlyPacking(boolean ideFriendlyPacking) {
        this.ideFriendlyPacking = ideFriendlyPacking;
    }

    public boolean isEnablePooledWeaving() {
        return this.enablePooledWeaving;
    }

    public void setEnablePooledWeaving(boolean enablePooledWeaving) {
        this.enablePooledWeaving = enablePooledWeaving;
    }

    public boolean isOptimizeEntitySystems() {
        return this.optimizeEntitySystems;
    }

    public void setOptimizeEntitySystems(boolean optimizeEntitySystems) {
        this.optimizeEntitySystems = optimizeEntitySystems;
    }

    public File getClassesDir() {
        return this.classesDir;
    }

    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }
}

