/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.gradle;

import com.artemis.Weaver;
import com.artemis.meta.ClassMetadata;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class ArtemisWeavingTask
extends DefaultTask {
    @OutputDirectory
    private File classesDir;
    @Input
    private boolean ideFriendlyPacking;
    @Input
    private boolean enablePooledWeaving;
    @Input
    private boolean enableArtemisPlugin;
    @Input
    private boolean optimizeEntitySystems;

    @TaskAction
    public void weave() {
        this.getLogger().info("Artemis plugin started.");
        if (!this.enableArtemisPlugin) {
            this.getLogger().info("Plugin disabled via 'enableArtemisPlugin' set to false.");
            return;
        }
        long start = System.currentTimeMillis();
        Logger log = this.getLogger();
        log.info("Configuration:");
        log.info("\tideFriendlyPacking .............. " + this.ideFriendlyPacking);
        log.info("\tenablePooledWeaving ............. " + this.enablePooledWeaving);
        log.info("\toptimizeEntitySystems ........... " + this.optimizeEntitySystems);
        log.info("\toutputDirectory ................. " + this.classesDir);
        Weaver.retainFieldsWhenPacking((boolean)this.ideFriendlyPacking);
        Weaver.enablePooledWeaving((boolean)this.enablePooledWeaving);
        Weaver.optimizeEntitySystems((boolean)this.optimizeEntitySystems);
        Weaver weaver = new Weaver(this.classesDir);
        List processed = weaver.execute();
        log.info(ArtemisWeavingTask.getSummary(processed, start));
        for (ClassMetadata meta : processed) {
            try {
                meta.weaverTask.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    private static String getSummary(List<ClassMetadata> processed, long start) {
        int pooled = 0;
        int packed = 0;
        for (ClassMetadata meta : processed) {
            if (ClassMetadata.WeaverType.PACKED == meta.annotation) {
                ++packed;
                continue;
            }
            if (ClassMetadata.WeaverType.POOLED != meta.annotation) continue;
            ++pooled;
        }
        return String.format("Processed %d PackedComponents and %d PooledComponents in %dms.", packed, pooled, System.currentTimeMillis() - start);
    }

    public boolean isEnableArtemisPlugin() {
        return this.enableArtemisPlugin;
    }

    public void setEnableArtemisPlugin(boolean enableArtemisPlugin) {
        this.enableArtemisPlugin = enableArtemisPlugin;
    }

    public boolean isIdeFriendlyPacking() {
        return this.ideFriendlyPacking;
    }

    public void setIdeFriendlyPacking(boolean ideFriendlyPacking) {
        this.ideFriendlyPacking = ideFriendlyPacking;
    }

    public boolean isEnablePooledWeaving() {
        return this.enablePooledWeaving;
    }

    public void setEnablePooledWeaving(boolean enablePooledWeaving) {
        this.enablePooledWeaving = enablePooledWeaving;
    }

    public boolean isOptimizeEntitySystems() {
        return this.optimizeEntitySystems;
    }

    public void setOptimizeEntitySystems(boolean optimizeEntitySystems) {
        this.optimizeEntitySystems = optimizeEntitySystems;
    }

    public File getClassesDir() {
        return this.classesDir;
    }

    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }
}

