/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.agrotera.maven;

import java.io.File;
import java.util.List;
import net.onedaybeard.agrotera.ProcessArtemis;
import net.onedaybeard.agrotera.meta.ArtemisConfigurationData;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="agrotera", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class WeavingHuntress
extends AbstractMojo {
    @Parameter(property="project.build.outputDirectory")
    private File outputDirectory;
    @Parameter(property="project.build.sourceDirectory")
    private File sourceDirectory;
    @Component
    private BuildContext context;

    public void execute() throws MojoExecutionException {
        long start = System.currentTimeMillis();
        if (this.context != null && !this.context.hasDelta(this.sourceDirectory)) {
            return;
        }
        ProcessArtemis hunter = new ProcessArtemis(this.outputDirectory);
        List processed = hunter.process();
        hunter.process();
        Log log = this.getLog();
        log.info(WeavingHuntress.getSummary(processed, start));
        String formatPattern = "\t%s:%-" + WeavingHuntress.findLongestClassName(processed) + "s  Req=%d One=%d Any=%d Not=%d RefSys=%d RefMan=%d";
        for (ArtemisConfigurationData meta : processed) {
            log.info((CharSequence)String.format(formatPattern, WeavingHuntress.typeCharacter(meta), WeavingHuntress.formatClassName(meta.current.getClassName()), meta.requires.size(), meta.requiresOne.size(), meta.optional.size(), meta.exclude.size(), meta.systems.size(), meta.managers.size()));
        }
    }

    private static String typeCharacter(ArtemisConfigurationData meta) {
        switch (meta.annotationType) {
            case MANAGER: {
                return "M";
            }
            case POJO: {
                return "I";
            }
            case SYSTEM: {
                return "S";
            }
        }
        return "S";
    }

    private static String formatClassName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static int findLongestClassName(List<ArtemisConfigurationData> processed) {
        int longest = 0;
        for (ArtemisConfigurationData meta : processed) {
            longest = Math.max(longest, WeavingHuntress.formatClassName(meta.current.getClassName()).length());
        }
        return longest;
    }

    private static CharSequence getSummary(List<ArtemisConfigurationData> processed, long start) {
        int systems = 0;
        int managers = 0;
        int injected = 0;
        for (ArtemisConfigurationData meta : processed) {
            if (meta.is(ArtemisConfigurationData.AnnotationType.SYSTEM) || meta.profilingEnabled) {
                ++systems;
                continue;
            }
            if (meta.is(ArtemisConfigurationData.AnnotationType.MANAGER)) {
                ++managers;
                continue;
            }
            if (!meta.is(ArtemisConfigurationData.AnnotationType.POJO)) continue;
            ++injected;
        }
        return String.format("Processed %d EntitySystem%s, %d Manager%s and %d Injected types in %dms.", systems, systems == 1 ? "" : "s", managers, managers == 1 ? "" : "s", injected, System.currentTimeMillis() - start);
    }
}

