/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard.config;

import java.io.IOException;
import javax.servlet.Filter;
import net.oneandone.stool.dashboard.config.DashboardProperties;
import net.oneandone.stool.stage.Stage;
import net.oneandone.stool.util.Session;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapUserDetailsService;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.security.web.AuthenticationEntryPoint;

@EnableWebSecurity
@Configuration
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private DashboardProperties properties;
    @Autowired
    private Session session;
    @Autowired
    private Stage self;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        CasAuthenticationProvider provider = new CasAuthenticationProvider();
        provider.setServiceProperties(this.serviceProperties());
        provider.setTicketValidator((TicketValidator)new Cas20ServiceTicketValidator(this.properties.sso));
        provider.setKey("cas");
        provider.setAuthenticationUserDetailsService((AuthenticationUserDetailsService)new UserDetailsByNameServiceWrapper(this.userDetailsService()));
        auth.authenticationProvider((AuthenticationProvider)provider);
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/ressources/**"})).antMatchers(new String[]{"/favicon.ico"})).antMatchers(new String[]{"/system"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        CasAuthenticationFilter filter = new CasAuthenticationFilter();
        filter.setAuthenticationManager(this.authenticationManager());
        CasAuthenticationEntryPoint entryPoint = new CasAuthenticationEntryPoint();
        entryPoint.setLoginUrl(this.properties.sso + "/login/");
        entryPoint.setServiceProperties(this.serviceProperties());
        ((HttpSecurity)((HttpSecurity)http.csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)entryPoint).and()).addFilter((Filter)filter);
        if (this.properties.sso.isEmpty()) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/**"})).anonymous();
        } else {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/whoami"})).fullyAuthenticated().antMatchers(new String[]{"/stages/"})).anonymous().antMatchers(new String[]{"/**"})).hasRole("LOGIN");
        }
    }

    @Bean
    public ServiceProperties serviceProperties() throws IOException {
        ServiceProperties serviceProperties = new ServiceProperties();
        serviceProperties.setService(this.self.loadPortsOpt().firstWebapp().httpsUrl(this.session.configuration.vhosts, this.self.getName(), this.session.configuration.hostname) + "/j_spring_cas_security_check");
        serviceProperties.setSendRenew(false);
        return serviceProperties;
    }

    @Bean
    public DefaultSpringSecurityContextSource contextSource() {
        String url = this.session.configuration.ldapUrl;
        if (url.isEmpty()) {
            url = "ldap://localhost";
        }
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(url);
        contextSource.setUserDn(this.session.configuration.ldapPrincipal);
        contextSource.setPassword(this.session.configuration.ldapCredentials);
        return contextSource;
    }

    public UserDetailsService userDetailsService() {
        String unit = this.session.configuration.ldapUnit;
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch("ou=" + unit, "(uid={0})", (BaseLdapPathContextSource)this.contextSource());
        DefaultLdapAuthoritiesPopulator authoritiesPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)this.contextSource(), "ou=roles,ou=" + unit);
        authoritiesPopulator.setGroupSearchFilter("(member=uid={1})");
        authoritiesPopulator.setGroupRoleAttribute("ou");
        authoritiesPopulator.setSearchSubtree(false);
        authoritiesPopulator.setIgnorePartialResultException(true);
        LdapUserDetailsService result = new LdapUserDetailsService((LdapUserSearch)userSearch, (LdapAuthoritiesPopulator)authoritiesPopulator);
        result.setUserDetailsMapper((UserDetailsContextMapper)new InetOrgPersonContextMapper());
        return result;
    }
}

