/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.ServletRequest;
import net.oneandone.stool.configuration.Accessor;
import net.oneandone.stool.configuration.StoolConfiguration;
import net.oneandone.stool.util.Mailer;
import net.oneandone.stool.util.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.ldap.userdetails.InetOrgPerson;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Scope(value="request")
@RequestMapping(value={"/"})
public class IndexController {
    private static final Logger LOG = LoggerFactory.getLogger(IndexController.class);
    @Autowired
    private Session session;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public ModelAndView index(ModelAndView modelAndView) {
        Object username = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (username instanceof InetOrgPerson) {
            username = ((InetOrgPerson)username).getDisplayName();
        }
        modelAndView.setViewName("index");
        modelAndView.addObject("username", username);
        LOG.info("[" + username + "] GET /");
        return modelAndView;
    }

    @RequestMapping(value={"whoami"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity whoAmI() {
        return new ResponseEntity(SecurityContextHolder.getContext().getAuthentication().getPrincipal(), HttpStatus.OK);
    }

    @RequestMapping(value={"configuration"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> configuration() {
        HashMap<String, String> model = new HashMap<String, String>();
        for (Map.Entry entry : StoolConfiguration.properties().entrySet()) {
            model.put((String)entry.getKey(), ((Accessor)entry.getValue()).get(this.session.configuration));
        }
        return model;
    }

    @RequestMapping(value={"feedback"}, method={RequestMethod.GET})
    public String feedback() {
        return "feedback";
    }

    @RequestMapping(value={"settings"}, method={RequestMethod.GET})
    public String settings() {
        return "settings";
    }

    @RequestMapping(value={"statistics"}, method={RequestMethod.GET})
    public String statistics() {
        return "statistics";
    }

    @RequestMapping(value={"feedback"}, method={RequestMethod.POST})
    public ResponseEntity sendFeedback(@ModelAttribute(value="message") String message, ServletRequest request) throws MessagingException {
        if (message.isEmpty()) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        String subject = "[Stool] Feedback from " + SecurityContextHolder.getContext().getAuthentication().getName();
        new Mailer(this.session.configuration.mailHost, this.session.configuration.mailUsername, this.session.configuration.mailPassword).send(this.session.configuration.admin, new String[]{this.session.configuration.admin}, subject, message, new File[0]);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }
}

