/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import net.oneandone.stool.dashboard.BuildStats;
import net.oneandone.stool.stage.Stage;
import net.oneandone.stool.util.Credentials;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.launcher.Failure;
import net.oneandone.sushi.launcher.Launcher;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.ldap.userdetails.InetOrgPerson;

/*
 * Exception performing whole class analysis ignored.
 */
public class StoolCallable
implements Callable<Failure> {
    private final FileNode stool;
    private final FileNode home;
    private final String command;
    private final String[] arguments;
    private final String id;
    private final Stage stage;
    private final FileNode logDir;
    private final String runAs;

    public static StoolCallable create(FileNode stool, FileNode home, String id, FileNode logs, Stage stage, String unauthenticatedUser, String command, String ... arguments) {
        Object username = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String runAs = username instanceof InetOrgPerson ? ((InetOrgPerson)username).getUid() : unauthenticatedUser;
        return new StoolCallable(stool, home, command, arguments, stage, id, logs, runAs);
    }

    public StoolCallable(FileNode stool, FileNode home, String command, String[] arguments, Stage stage, String id, FileNode logDir, String runAs) {
        this.stool = stool;
        this.home = home;
        this.command = command;
        this.arguments = arguments;
        this.id = id;
        this.stage = stage;
        this.logDir = logDir;
        this.runAs = runAs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Failure call() throws Exception {
        Failure failure = null;
        long time = System.currentTimeMillis();
        Launcher launcher = new Launcher(this.logDir, new String[0]);
        launcher.env("STOOL_USER", this.runAs);
        launcher.env("STOOL_HOME", this.home.getAbsolute());
        launcher.arg(new String[]{this.stool.getAbsolute()});
        launcher.arg(new String[]{"-e"});
        Credentials svnCredentials = this.stage.session.svnCredentials();
        if (svnCredentials.username != null) {
            launcher.arg(new String[]{"-svnuser=" + svnCredentials.username});
            launcher.arg(new String[]{"-svnpassword=" + svnCredentials.password});
        }
        launcher.arg(new String[]{this.command, "-stage", "id=" + this.stage.getId()});
        launcher.arg(this.arguments);
        try (PrintWriter writer = new PrintWriter((Writer)((FileNode)this.logDir.join(new String[]{this.id + ".log"})).newWriter());){
            writer.println(StoolCallable.hide((String)StoolCallable.hide((String)launcher.toString(), (String)svnCredentials.password), (String)svnCredentials.username));
            FileNode running = ((FileNode)this.logDir.join(new String[]{this.id + ".running"})).mkfile();
            try {
                launcher.exec((Writer)writer);
            }
            catch (Failure e) {
                failure = e;
                writer.println("stool failed: " + e.getMessage());
            }
            finally {
                running.deleteFile();
            }
            time = System.currentTimeMillis() - time;
            writer.println((failure == null ? "OK" : "FAILED") + " (ms= " + time + ")");
        }
        BuildStats buildStats = BuildStats.load((FileNode)this.logDir, (Stage)this.stage);
        buildStats.add(this.command, time);
        buildStats.save();
        return failure;
    }

    private static String hide(String str, String hide) {
        return hide == null || hide.isEmpty() ? str : str.replace(hide, "********");
    }
}

