/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import net.oneandone.inline.Console;
import net.oneandone.maven.embedded.Maven;
import net.oneandone.stool.dashboard.ResourceNotFoundException;
import net.oneandone.stool.dashboard.StageController;
import net.oneandone.stool.dashboard.StageInfo;
import net.oneandone.stool.dashboard.StageInfoCache;
import net.oneandone.stool.dashboard.StoolCallable;
import net.oneandone.stool.stage.Stage;
import net.oneandone.stool.users.Users;
import net.oneandone.stool.util.Session;
import net.oneandone.sushi.fs.NodeNotFoundException;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.util.Separator;
import net.oneandone.sushi.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/stages"})
public class StageController {
    @Autowired
    private Users users;
    @Autowired
    private World world;
    @Autowired
    private Session session;
    @Autowired
    private FileNode logs;
    @Autowired
    private FileNode jar;
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private Maven maven;
    @Autowired
    private StageInfoCache stages;

    @RequestMapping(method={RequestMethod.GET})
    public Collection<StageInfo> stages() throws IOException {
        return this.stages.get(this.logs, this.session, this.users);
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"text/html"})
    public ModelAndView stagesAsHtml(ModelAndView modelAndView) throws IOException {
        modelAndView.setViewName("stages");
        modelAndView.addObject("stages", (Object)this.stages.get(this.logs, this.session, this.users));
        return modelAndView;
    }

    @RequestMapping(value={"{name}"}, method={RequestMethod.GET})
    public ResponseEntity stage(@PathVariable(value="name") String stageName) throws Exception {
        Stage stage = this.resolveStage(stageName);
        return new ResponseEntity((Object)StageInfo.fromStage((FileNode)this.logs, (Stage)stage, (Users)this.users), HttpStatus.OK);
    }

    @RequestMapping(value={"{name}"}, method={RequestMethod.GET}, produces={"text/html"})
    public ModelAndView stageAsHtml(@PathVariable(value="name") String stageName, ModelAndView modelAndView) throws Exception {
        ArrayList<StageInfo> stageInfos = new ArrayList<StageInfo>();
        modelAndView.setViewName("stages");
        for (StageInfo stageInfo : this.stages.get(this.logs, this.session, this.users)) {
            if (!stageName.equals(stageInfo.getName())) continue;
            stageInfos.add(stageInfo);
        }
        modelAndView.addObject("stages", stageInfos);
        return modelAndView;
    }

    @RequestMapping(value={"/{name}/logs"}, method={RequestMethod.GET})
    public Map<String, String> logs(HttpServletRequest httpServletRequest, @PathVariable(value="name") String stageName) throws Exception {
        Stage stage = this.resolveStage(stageName);
        String baseUrl = httpServletRequest.getRequestURL().toString();
        baseUrl = baseUrl.substring(0, baseUrl.indexOf(47, 8) + 1);
        return stage.logs().list(baseUrl + "stages/" + stageName + "/logs/");
    }

    @RequestMapping(value={"/{name}/logs/{log}"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> log(@PathVariable(value="name") String stageName, @PathVariable(value="log") String log) throws Exception {
        Stage stage = this.resolveStage(stageName);
        String logfile = log.endsWith(".log") ? log : log + ".log";
        try {
            FileSystemResource resource = new FileSystemResource(stage.logs().file(logfile));
            return new ResponseEntity((Object)resource, HttpStatus.OK);
        }
        catch (NodeNotFoundException e) {
            throw new ResourceNotFoundException();
        }
    }

    @RequestMapping(value={"{name}/{action}"}, method={RequestMethod.POST})
    public String action(@PathVariable(value="name") String stageName, @PathVariable(value="action") String action) {
        return this.execute(stageName, action, new String[0]);
    }

    @RequestMapping(value={"{name}/{action}/{arguments}"}, method={RequestMethod.POST})
    public String action(@PathVariable(value="name") String stageName, @PathVariable(value="action") String action, @PathVariable(value="arguments") String arguments) {
        return this.execute(stageName, action, Strings.toArray((Collection)Separator.COMMA.split((CharSequence)arguments)));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ExceptionExport> handleApiException(Throwable e) {
        this.session.reportException("StageController.handleApiException", e);
        return new ResponseEntity((Object)new ExceptionExport(e), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private Stage resolveStage(String stageName) throws ResourceNotFoundException {
        Stage stage;
        try {
            stage = this.session.loadByName(stageName);
        }
        catch (IOException e) {
            throw (ResourceNotFoundException)new ResourceNotFoundException().initCause((Throwable)e);
        }
        stage.setMaven(this.maven);
        return stage;
    }

    public Console console() {
        return Console.create();
    }

    public String execute(String stage, String command, String ... arguments) {
        String id = UUID.randomUUID().toString();
        this.executorService.submit(StoolCallable.create((FileNode)this.jar, (FileNode)this.session.home, (String)id, (FileNode)this.logs, (Stage)this.resolveStage(stage), (String)this.session.logging.getUser(), (String)command, (String[])arguments));
        return id;
    }
}

