/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.oneandone.stool.stage.Stage;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;

public class BuildStats {
    private final Map<String, Long> stats = new HashMap();
    private transient Node file = null;
    private transient Gson gson = null;

    public static BuildStats load(FileNode logDir, Stage stage) throws IOException {
        BuildStats result;
        FileNode file = (FileNode)logDir.join(new String[]{stage.getName() + ".stats"});
        if (file.exists()) {
            try {
                result = (BuildStats)stage.session.gson.fromJson(file.readString(), BuildStats.class);
            }
            catch (IOException e) {
                throw new IOException(file + ": cannot read build stats: " + e.getMessage(), e);
            }
            if (result == null) {
                throw new IllegalStateException("empty build stats: " + file);
            }
        } else {
            result = new BuildStats();
        }
        result.file = file;
        result.gson = stage.session.gson;
        return result;
    }

    public long getAvgStart() {
        return this.get("start");
    }

    public long getAvgStop() {
        return this.get("stop");
    }

    public long getAvgBuild() {
        return this.get("build");
    }

    public long getAvgRefresh() {
        return this.get("refresh");
    }

    public long getAvgRestart() {
        return this.get("restart");
    }

    private long get(String command) {
        Long result = (Long)this.stats.get(command);
        return result == null ? 0L : result;
    }

    public void save() throws IOException {
        this.file.writeString(this.gson.toJson((Object)this));
    }

    public void add(String command, long latest) {
        Long time = (Long)this.stats.get(command);
        time = time == null ? Long.valueOf(latest) : Long.valueOf(time + latest);
        this.stats.put(command, time);
    }
}

