/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard.config;

import java.util.TimerTask;
import java.util.UUID;
import net.oneandone.stool.dashboard.StoolCallable;
import net.oneandone.stool.stage.Stage;
import net.oneandone.stool.util.Session;
import net.oneandone.sushi.fs.file.FileNode;

public class RefreshTask
extends TimerTask {
    private final FileNode jar;
    private final Session session;
    private final FileNode logs;

    public RefreshTask(FileNode jar, Session session, FileNode logs) {
        this.jar = jar;
        this.session = session;
        this.logs = logs;
    }

    @Override
    public void run() {
        try {
            for (Stage stage : this.session.listWithoutSystem()) {
                if (!stage.config().autoRefresh.booleanValue()) continue;
                StoolCallable.create((FileNode)this.jar, (String)UUID.randomUUID().toString(), (FileNode)this.logs, (Stage)stage, (String)this.session.logging.getUser(), (String)"refresh", (String[])new String[]{"-autorestart"}).call();
            }
        }
        catch (Exception e) {
            this.session.reportException("RefreshTask", (Throwable)e);
        }
    }
}

