/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingException;
import net.oneandone.stool.dashboard.StageInfo;
import net.oneandone.stool.stage.Stage;
import net.oneandone.stool.users.Users;
import net.oneandone.stool.util.Session;
import net.oneandone.sushi.fs.file.FileNode;

public class StageInfoCache {
    private final Collection<StageInfo> stages = new ArrayList();
    private long lastCacheRenew = 0L;

    public Collection<StageInfo> get(FileNode logs, Session session, Users users) throws IOException {
        if (System.currentTimeMillis() - this.lastCacheRenew > 4000L) {
            this.stages.clear();
            session.wipeStaleBackstages();
            session.updatePool();
            for (Stage stage : session.listWithoutSystem()) {
                try {
                    this.stages.add(StageInfo.fromStage((FileNode)logs, (Stage)stage, (Users)users));
                }
                catch (NamingException e) {
                    session.reportException("StageInfo.fromStage", (Throwable)e);
                }
            }
            this.lastCacheRenew = System.currentTimeMillis();
        }
        return this.stages;
    }
}

