/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.naming.NamingException;
import net.oneandone.stool.configuration.Expire;
import net.oneandone.stool.configuration.StageConfiguration;
import net.oneandone.stool.dashboard.BuildStats;
import net.oneandone.stool.dashboard.StageInfo;
import net.oneandone.stool.stage.Stage;
import net.oneandone.stool.stage.artifact.Changes;
import net.oneandone.stool.users.UserNotFound;
import net.oneandone.stool.users.Users;
import net.oneandone.sushi.fs.file.FileNode;

public class StageInfo {
    private String name;
    private StageConfiguration configuration;
    private String extractionUrl;
    private Map<String, String> urls;
    private Stage.State running;
    private String owner;
    private boolean updateAvailable;
    private Expire expire;
    private Changes changes;
    private BuildStats stats;
    private String category;
    private String state;

    public static StageInfo fromStage(FileNode logDir, Stage stage, Users users) throws IOException, UserNotFound, NamingException {
        StageInfo stageInfo = new StageInfo();
        stageInfo.name = stage.getName();
        stageInfo.configuration = stage.config();
        stageInfo.extractionUrl = stage.getUrl();
        stageInfo.running = stage.isWorking() ? Stage.State.WORKING : stage.state();
        stageInfo.urls = stage.urlMap();
        stageInfo.owner = users.byLogin((String)stage.owner()).name;
        stageInfo.updateAvailable = stage.updateAvailable();
        stageInfo.expire = stage.config().expire;
        Changes changes = stage.changes();
        if (changes.size() > 0) {
            stageInfo.changes = changes;
        }
        stageInfo.stats = BuildStats.load((FileNode)logDir, (Stage)stage);
        if (stageInfo.extractionUrl.contains("/trunk")) {
            stageInfo.category = "trunk";
        } else if (stageInfo.extractionUrl.contains("/branches")) {
            stageInfo.category = "branches";
        } else if (stageInfo.extractionUrl.contains("/workspaces")) {
            stageInfo.category = "workspaces";
        }
        switch (1.$SwitchMap$net$oneandone$stool$stage$Stage$State[stageInfo.running.ordinal()]) {
            case 1: {
                stageInfo.state = "success";
                break;
            }
            case 2: {
                stageInfo.state = "primary";
                break;
            }
            default: {
                stageInfo.state = "danger";
            }
        }
        return stageInfo;
    }

    public Expire getExpire() {
        return this.expire;
    }

    public Changes getChanges() {
        return this.changes;
    }

    public BuildStats getStats() {
        return this.stats;
    }

    public String getCategory() {
        return this.category;
    }

    public String getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public StageConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getExtractionUrl() {
        return this.extractionUrl;
    }

    public Map<String, String> getUrls() {
        return this.urls;
    }

    public String getRunning() {
        return this.running.name().toLowerCase();
    }

    public String getOwner() {
        return this.owner;
    }

    public String getShareText() throws UnsupportedEncodingException {
        if (this.urls == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("Hi, \n");
        for (String url : this.urls.values()) {
            stringBuilder.append(url).append("\n");
        }
        String content = URLEncoder.encode(stringBuilder.toString(), "UTF-8");
        content = content.replace("+", "%20").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        return content;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getHash() {
        return "" + this.toString().hashCode();
    }

    public String toString() {
        return "StageInfo{name='" + this.name + '\'' + ", extractionUrl='" + this.extractionUrl + '\'' + ", urls=" + this.urls + ", changes=" + this.changes + ", running=" + this.running + ", owner='" + this.owner + '\'' + ", updateAvailable=" + this.updateAvailable + ", category='" + this.category + '\'' + ", state='" + this.state + '\'' + '}';
    }
}

