/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import net.oneandone.stool.dashboard.BuildStats;
import net.oneandone.stool.stage.Stage;
import net.oneandone.stool.util.Credentials;
import net.oneandone.stool.util.Session;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.launcher.Failure;
import net.oneandone.sushi.launcher.Launcher;

/*
 * Exception performing whole class analysis ignored.
 */
public class StoolCallable
implements Callable<Failure> {
    private final FileNode stool;
    private final String command;
    private final String[] options;
    private final String id;
    private final Stage stage;
    private final FileNode logDir;
    private final boolean su;
    private final String path;
    private final String runAs;

    public static StoolCallable create(FileNode stool, String id, FileNode logs, Stage stage, String command, String ... options) throws IOException {
        Session session = stage.session;
        return new StoolCallable(stool, command, options, stage, id, logs, session.configuration.shared, session.environment.get("PATH"), stage.owner());
    }

    public StoolCallable(FileNode stool, String command, String[] options, Stage stage, String id, FileNode logDir, boolean su, String path, String runAs) {
        this.stool = stool;
        this.command = command;
        this.options = options;
        this.id = id;
        this.stage = stage;
        this.logDir = logDir;
        this.su = su;
        this.path = path;
        this.runAs = runAs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Failure call() throws Exception {
        Failure failure = null;
        long time = System.currentTimeMillis();
        Launcher launcher = new Launcher(this.logDir, new String[0]);
        if (this.su) {
            launcher.arg(new String[]{"sudo", "-u", this.runAs, "-E", "PATH=" + this.path});
        }
        launcher.arg(new String[]{this.stool.getAbsolute()});
        Credentials svnCredentials = this.stage.session.svnCredentials();
        if (svnCredentials.username != null) {
            launcher.arg(new String[]{"-svnuser=" + svnCredentials.username});
            launcher.arg(new String[]{"-svnpassword=" + svnCredentials.password});
        }
        launcher.arg(new String[]{this.command, "-stage", "id=" + this.stage.getId()});
        launcher.arg(this.options);
        try (PrintWriter writer = new PrintWriter((Writer)((FileNode)this.logDir.join(new String[]{this.id + ".log"})).newWriter());){
            writer.println(StoolCallable.hide((String)StoolCallable.hide((String)launcher.toString(), (String)svnCredentials.password), (String)svnCredentials.username));
            FileNode running = ((FileNode)this.logDir.join(new String[]{this.id + ".running"})).mkfile();
            try {
                launcher.exec((Writer)writer);
            }
            catch (Failure e) {
                failure = e;
                e.printStackTrace(writer);
            }
            finally {
                running.deleteFile();
            }
            time = System.currentTimeMillis() - time;
            writer.println((failure == null ? "OK" : "FAILED") + " (ms= " + time + ")");
        }
        BuildStats buildStats = BuildStats.load((FileNode)this.logDir, (Stage)this.stage);
        buildStats.add(this.command, time);
        buildStats.save();
        return failure;
    }

    private static String hide(String str, String hide) {
        return hide == null ? str : str.replace(hide, "********");
    }
}

