/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard.config;

import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.oneandone.maven.embedded.Maven;
import net.oneandone.stool.dashboard.IndexController;
import net.oneandone.stool.dashboard.StageInfoCache;
import net.oneandone.stool.dashboard.config.RefreshTask;
import net.oneandone.stool.stage.Stage;
import net.oneandone.stool.users.Users;
import net.oneandone.stool.util.Environment;
import net.oneandone.stool.util.Logging;
import net.oneandone.stool.util.Session;
import net.oneandone.sushi.cli.Console;
import net.oneandone.sushi.fs.ReadLinkException;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackageClasses={IndexController.class})
public class DashboardConfiguration {
    @Bean
    public World world() {
        return new World();
    }

    @Bean
    public FileNode lib() throws ReadLinkException {
        return Session.locateLib((FileNode)this.bin());
    }

    @Bean
    public FileNode bin() {
        return this.world().file(System.getProperty("stool.bin"));
    }

    @Bean
    public String user() {
        return System.getProperty("user.name");
    }

    @Bean
    public Console console() {
        return Console.create((World)this.world());
    }

    @Bean
    public Session session() throws IOException {
        String svnpassword;
        String svnuser;
        Environment system = Environment.loadSystem();
        FileNode lib = this.lib();
        FileNode props = lib.join(new String[]{"dashboard.properties"});
        if (props.exists()) {
            Properties p = props.readProperties();
            svnuser = p.getProperty("svnuser");
            svnpassword = p.getProperty("svnpassword");
        } else {
            svnuser = null;
            svnpassword = null;
        }
        String user = this.user();
        system.setStoolBin(this.bin());
        return Session.load((Logging)Logging.create((FileNode)this.logs(), (String)"dashboard", (String)user), (String)user, (String)"dashboard", (Environment)system, (Console)this.console(), null, (String)svnuser, (String)svnpassword);
    }

    @Bean
    public Stage self() throws IOException {
        return Stage.load((Session)this.session(), (FileNode)this.world().file(System.getProperty("stool.backstage")));
    }

    @Bean
    public FileNode logs() {
        return this.world().file(System.getProperty("catalina.base")).join(new String[]{"logs"});
    }

    @Bean
    public Users users() throws IOException {
        return this.session().users;
    }

    @Bean
    public Maven maven() throws IOException {
        return this.self().maven();
    }

    @Bean
    public ExecutorService executorService() {
        return Executors.newCachedThreadPool();
    }

    @Bean
    public StageInfoCache stages() {
        return new StageInfoCache();
    }

    @Bean
    public Timer autoRefresh() throws IOException {
        Timer timer = new Timer("Refresh");
        timer.schedule((TimerTask)new RefreshTask(this.session(), this.logs()), 20000L, 60000L);
        return timer;
    }
}

