/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard;

import java.io.IOException;
import net.oneandone.stool.dashboard.ResourceNotFoundException;
import net.oneandone.sushi.fs.ExistsException;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processes"})
public class ProcessesController {
    @Autowired
    private FileNode logs;

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity state(@PathVariable(value="id") String id) throws IOException {
        FileNode stat = this.logs.join(new String[]{id + ".stat"});
        if (!stat.exists()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        String stoolProcess = stat.readString();
        return new ResponseEntity((Object)stoolProcess, HttpStatus.OK);
    }

    @RequestMapping(value={"{id}/log"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity log(@PathVariable(value="id") String id, @RequestParam(defaultValue="0") Integer index) throws IOException, InterruptedException {
        Node logfile;
        StringBuilder output = new StringBuilder();
        try {
            logfile = this.logFile(id);
        }
        catch (ResourceNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        long size = 0L;
        boolean exists = this.logs.join(new String[]{id + ".running"}).exists();
        for (String line : logfile.readLines()) {
            output.append(line).append("<br />");
            size += (long)line.length();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set((Object)"X-Running", (Object)Boolean.toString(exists));
        headers.set((Object)"X-Size", (Object)Long.toString(size));
        return new ResponseEntity((Object)output.toString(), (MultiValueMap)headers, HttpStatus.OK);
    }

    public Node logFile(String id) throws InterruptedException, ExistsException {
        FileNode logfile = this.logs.join(new String[]{id + ".log"});
        int i = 0;
        do {
            if (logfile.exists()) {
                return logfile;
            }
            Thread.sleep(500L);
        } while (++i <= 20);
        throw new ResourceNotFoundException();
    }
}

