/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.stool.dashboard;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import net.oneandone.stool.dashboard.BuildStats;
import net.oneandone.stool.stage.Stage;
import net.oneandone.stool.util.Session;
import net.oneandone.stool.util.Subversion;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.launcher.Failure;
import net.oneandone.sushi.launcher.Launcher;

/*
 * Exception performing whole class analysis ignored.
 */
public class StoolCallable
implements Callable<Failure> {
    private final FileNode stoolRaw;
    private final String command;
    private final String[] options;
    private final String id;
    private final Stage stage;
    private final FileNode logDir;
    private final boolean su;
    private final String runAs;

    public static StoolCallable create(String id, FileNode logs, Stage stage, String command, String ... options) throws IOException {
        Session session = stage.session;
        return new StoolCallable(session.bin("stool-raw.sh"), command, options, stage, id, logs, session.configuration.shared, stage.owner());
    }

    public StoolCallable(FileNode stoolRaw, String command, String[] options, Stage stage, String id, FileNode logDir, boolean su, String runAs) {
        this.stoolRaw = stoolRaw;
        this.command = command;
        this.options = options;
        this.id = id;
        this.stage = stage;
        this.logDir = logDir;
        this.su = su;
        this.runAs = runAs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Failure call() throws Exception {
        Failure failure = null;
        long time = System.currentTimeMillis();
        Launcher launcher = new Launcher(this.logDir, new String[0]);
        if (this.su) {
            launcher.arg(new String[]{"sudo", "-u", this.runAs});
        }
        launcher.arg(new String[]{this.stoolRaw.getAbsolute()});
        Subversion subversion = this.stage.session.subversion();
        if (subversion.username != null) {
            launcher.arg(new String[]{"-svnuser", subversion.username});
            launcher.arg(new String[]{"-svnpassword", subversion.password});
        }
        launcher.arg(new String[]{this.command, "-stage", this.stage.getName()});
        if (this.command.equals("refresh")) {
            launcher.arg(new String[]{"-autorechown"});
            launcher.arg(new String[]{"-autorestart"});
        }
        launcher.arg(this.options);
        try (PrintWriter writer = new PrintWriter((Writer)this.logDir.join(new String[]{this.id + ".log"}).createWriter());){
            writer.println(StoolCallable.hide((String)StoolCallable.hide((String)launcher.toString(), (String)subversion.password), (String)subversion.username));
            FileNode running = this.logDir.join(new String[]{this.id + ".running"}).mkfile();
            try {
                launcher.exec((Writer)writer);
            }
            catch (Failure e) {
                failure = e;
                e.printStackTrace(writer);
            }
            finally {
                running.deleteFile();
            }
            time = System.currentTimeMillis() - time;
            writer.println((failure == null ? "OK" : "FAILED") + " (ms= " + time + ")");
        }
        BuildStats buildStats = BuildStats.load((FileNode)this.logDir, (Stage)this.stage);
        buildStats.add(this.command, time);
        buildStats.save();
        return failure;
    }

    private static String hide(String str, String hide) {
        return hide == null ? str : str.replace(hide, "********");
    }
}

