/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.util;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.doclet.DocletEnvironment;
import net.oneandone.neberus.Options;
import net.oneandone.neberus.annotation.ApiDocumentation;
import net.oneandone.neberus.annotation.ApiIgnore;
import net.oneandone.neberus.annotation.ApiLabel;
import net.oneandone.neberus.model.FormParameters;
import net.oneandone.neberus.parse.RestMethodData;

public abstract class JavaDocUtils {
    private static final String JSON_IGNORE = "com.fasterxml.jackson.annotation.JsonIgnore";
    private static final String JSON_IGNORE_LEGACY = "org.codehaus.jackson.annotate.JsonIgnore";
    private static final String JSON_PROPERTY = "com.fasterxml.jackson.annotation.JsonProperty";
    private static final String JSON_PROPERTY_LEGACY = "org.codehaus.jackson.annotate.JsonProperty";
    public static final String XML_TRANSIENT = "javax.xml.bind.annotation.XmlTransient";
    public static final String XML_ROOT_ELEMENT = "javax.xml.bind.annotation.XmlRootElement";
    public static final String JACKSON_XML_ROOT_ELEMENT = "com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement";

    private JavaDocUtils() {
    }

    public static List<? extends AnnotationMirror> getAnnotationDesc(TypeElement clazz, Class annotationClass, DocletEnvironment environment) {
        List<? extends AnnotationMirror> annotationMirrors = JavaDocUtils.collectAllAnnotationMirrors(clazz, environment);
        return JavaDocUtils.getAnnotationDesc(annotationMirrors, annotationClass);
    }

    public static List<? extends AnnotationMirror> getAnnotationDesc(ExecutableElement method, Class annotationClass, DocletEnvironment environment) {
        return JavaDocUtils.getAnnotationDesc(method, annotationClass.getCanonicalName(), environment);
    }

    public static List<? extends AnnotationMirror> getAnnotationDesc(ExecutableElement method, String annotationClass, DocletEnvironment environment) {
        Optional<ExecutableElement> interfaceMethod = JavaDocUtils.getInterfaceMethod(method, environment);
        List<Object> onInterface = Collections.emptyList();
        if (interfaceMethod.isPresent()) {
            onInterface = JavaDocUtils.getDirectAnnotationDesc(interfaceMethod.get().getAnnotationMirrors(), annotationClass);
        }
        return !onInterface.isEmpty() ? onInterface : JavaDocUtils.getDirectAnnotationDesc(method.getAnnotationMirrors(), annotationClass);
    }

    public static List<? extends AnnotationMirror> getAnnotationDesc(ExecutableElement method, VariableElement param, Class annotationClass, int index, DocletEnvironment environment) {
        return JavaDocUtils.getAnnotationDesc(method, param, annotationClass.getCanonicalName(), index, environment);
    }

    public static List<? extends AnnotationMirror> getAnnotationDesc(ExecutableElement method, VariableElement param, String annotationClass, int index, DocletEnvironment environment) {
        Optional<VariableElement> interfaceParam = JavaDocUtils.getInterfaceParameter(method, index, environment);
        List<Object> onInterface = Collections.emptyList();
        if (interfaceParam.isPresent()) {
            onInterface = JavaDocUtils.getDirectAnnotationDesc(interfaceParam.get().getAnnotationMirrors(), annotationClass);
        }
        return !onInterface.isEmpty() ? onInterface : JavaDocUtils.getDirectAnnotationDesc(param.getAnnotationMirrors(), annotationClass);
    }

    public static List<? extends AnnotationMirror> getAnnotationDesc(Element field, Class annotationClass) {
        return JavaDocUtils.getDirectAnnotationDesc(field.getAnnotationMirrors(), annotationClass.getCanonicalName());
    }

    private static List<? extends AnnotationMirror> getAnnotationDesc(Element field, String annotationClass) {
        return JavaDocUtils.getDirectAnnotationDesc(field.getAnnotationMirrors(), annotationClass);
    }

    private static List<? extends AnnotationMirror> getAnnotationDesc(VariableElement ctorParam, String annotationClass) {
        return JavaDocUtils.getDirectAnnotationDesc(ctorParam.getAnnotationMirrors(), annotationClass);
    }

    private static List<? extends AnnotationMirror> getAnnotationDesc(List<? extends AnnotationMirror> annotations, Class annotationClass) {
        return JavaDocUtils.getDirectAnnotationDesc(annotations, annotationClass.getCanonicalName());
    }

    private static List<? extends AnnotationMirror> getDirectAnnotationDesc(List<? extends AnnotationMirror> annotations, String annotationClass) {
        return annotations.stream().filter(a -> ((TypeElement)a.getAnnotationType().asElement()).getQualifiedName().toString().equals(annotationClass)).collect(Collectors.toList());
    }

    public static <T> T getAnnotationValue(List<? extends AnnotationMirror> annotationMirrors, String annotationClass, String key) {
        Optional findFirst = JavaDocUtils.getDirectAnnotationDesc(annotationMirrors, annotationClass).stream().findFirst();
        if (findFirst.isEmpty()) {
            return null;
        }
        return JavaDocUtils.extractValue((AnnotationMirror)findFirst.get(), key);
    }

    public static <T> T getAnnotationValue(TypeElement clazz, Class annotationClass, String key, DocletEnvironment environment) {
        Optional findFirst = JavaDocUtils.getAnnotationDesc(clazz, annotationClass, environment).stream().findFirst();
        if (findFirst.isEmpty()) {
            return null;
        }
        return JavaDocUtils.extractValue((AnnotationMirror)findFirst.get(), key);
    }

    public static <T> T getAnnotationValue(ExecutableElement method, Class annotationClass, String key, DocletEnvironment environment) {
        return JavaDocUtils.getAnnotationValue(method, annotationClass.getCanonicalName(), key, environment);
    }

    public static <T> T getAnnotationValue(ExecutableElement method, String annotationClass, String key, DocletEnvironment environment) {
        Optional findFirst = JavaDocUtils.getAnnotationDesc(method, annotationClass, environment).stream().findFirst();
        if (findFirst.isEmpty()) {
            return null;
        }
        return JavaDocUtils.extractValue((AnnotationMirror)findFirst.get(), key);
    }

    public static <T> T getDirectAnnotationValue(Element field, Class annotationClass, String key) {
        return JavaDocUtils.getDirectAnnotationValue(field, annotationClass.getCanonicalName(), key);
    }

    public static <T> T getDirectAnnotationValue(Element field, String annotationClass, String key) {
        Optional findFirst = JavaDocUtils.getAnnotationDesc(field, annotationClass).stream().findFirst();
        if (findFirst.isEmpty()) {
            return null;
        }
        return JavaDocUtils.extractValue((AnnotationMirror)findFirst.get(), key);
    }

    public static <T> T getAnnotationValue(ExecutableElement method, VariableElement param, Class annotationClass, int index, String key, DocletEnvironment environment) {
        return JavaDocUtils.getAnnotationValue(method, param, annotationClass.getCanonicalName(), index, key, environment);
    }

    public static <T> T getAnnotationValue(ExecutableElement method, VariableElement param, String annotationClass, int index, String key, DocletEnvironment environment) {
        Optional findFirst = JavaDocUtils.getAnnotationDesc(method, param, annotationClass, index, environment).stream().findFirst();
        if (findFirst.isEmpty()) {
            return null;
        }
        return JavaDocUtils.extractValue((AnnotationMirror)findFirst.get(), key);
    }

    public static <T> T getDirectAnnotationValue(VariableElement ctorParam, Class annotationClass, String key) {
        return JavaDocUtils.getDirectAnnotationValue(ctorParam, annotationClass.getCanonicalName(), key);
    }

    public static <T> T getDirectAnnotationValue(VariableElement ctorParam, String annotationClass, String key) {
        Optional findFirst = JavaDocUtils.getAnnotationDesc(ctorParam, annotationClass).stream().findFirst();
        if (findFirst.isEmpty()) {
            return null;
        }
        return JavaDocUtils.extractValue((AnnotationMirror)findFirst.get(), key);
    }

    public static <T> T getAnnotationValue(ExecutableElement method, VariableElement parameter, Class annotationClass, String key, int index, DocletEnvironment environment) {
        Optional findFirst = JavaDocUtils.getAnnotationDesc(method, parameter, annotationClass, index, environment).stream().findFirst();
        if (findFirst.isEmpty()) {
            return null;
        }
        return JavaDocUtils.extractValue((AnnotationMirror)findFirst.get(), key);
    }

    public static List<? extends AnnotationMirror> getAnnotations(ExecutableElement method, VariableElement parameter, int index, DocletEnvironment environment) {
        Optional<VariableElement> interfaceParam = JavaDocUtils.getInterfaceParameter(method, index, environment);
        ArrayList<? extends AnnotationMirror> annotations = new ArrayList<AnnotationMirror>(parameter.getAnnotationMirrors());
        interfaceParam.ifPresent(value -> annotations.addAll(value.getAnnotationMirrors()));
        return annotations;
    }

    public static boolean hasDirectAnnotation(VariableElement param, Class annotationClass) {
        return JavaDocUtils.hasDirectAnnotation(param, annotationClass.getCanonicalName());
    }

    public static boolean hasDirectAnnotation(VariableElement param, String annotationClass) {
        return JavaDocUtils.hasAnnotation(param.getAnnotationMirrors(), annotationClass);
    }

    public static Optional<TypeElement> getInterfaceClass(TypeElement clazz, DocletEnvironment environment) {
        return clazz.getInterfaces().stream().filter(iface -> !iface.toString().startsWith("java.") && environment.getTypeUtils().asElement((TypeMirror)iface) != null).map(iface -> (TypeElement)environment.getTypeUtils().asElement((TypeMirror)iface)).filter(element -> JavaDocUtils.hasAnnotation(element, ApiDocumentation.class, environment)).findFirst();
    }

    private static Optional<TypeElement> getInterfaceClass(ExecutableElement method, DocletEnvironment environment) {
        return JavaDocUtils.getInterfaceClass((TypeElement)method.getEnclosingElement(), environment);
    }

    private static Optional<ExecutableElement> getInterfaceMethod(ExecutableElement method, DocletEnvironment environment) {
        Optional<TypeElement> interfaceClass = JavaDocUtils.getInterfaceClass(method, environment);
        if (interfaceClass.isEmpty()) {
            return Optional.empty();
        }
        return JavaDocUtils.getExecutableElements(interfaceClass.get()).stream().filter(e -> environment.getElementUtils().overrides(method, (ExecutableElement)e, (TypeElement)method.getEnclosingElement())).findFirst();
    }

    private static Optional<VariableElement> getInterfaceParameter(ExecutableElement method, int index, DocletEnvironment environment) {
        Optional<ExecutableElement> methodInterface = JavaDocUtils.getInterfaceMethod(method, environment);
        if (methodInterface.isEmpty() || methodInterface.get().getParameters().size() < index - 1) {
            return Optional.empty();
        }
        return Optional.of(methodInterface.get().getParameters().get(index));
    }

    public static <T> T extractValue(AnnotationMirror findFirst, String key) {
        Optional<Map.Entry> evPair = findFirst.getElementValues().entrySet().stream().filter(ev -> ((ExecutableElement)ev.getKey()).getSimpleName().toString().equals(key)).findFirst();
        if (evPair.isEmpty()) {
            return null;
        }
        Object value = ((AnnotationValue)evPair.get().getValue()).getValue();
        return (T)value;
    }

    public static boolean hasAnnotation(ExecutableElement method, VariableElement parameter, Class annotationClass, int index, DocletEnvironment environment) {
        Optional<VariableElement> interfaceParam = JavaDocUtils.getInterfaceParameter(method, index, environment);
        boolean definedOnInterface = false;
        if (interfaceParam.isPresent()) {
            definedOnInterface = JavaDocUtils.hasAnnotation(interfaceParam.get().getAnnotationMirrors(), annotationClass);
        }
        return definedOnInterface || JavaDocUtils.hasAnnotation(parameter.getAnnotationMirrors(), annotationClass);
    }

    public static boolean hasAnnotation(ExecutableElement method, Class annotationClass, DocletEnvironment environment) {
        return JavaDocUtils.hasAnnotation(method, annotationClass.getCanonicalName(), environment);
    }

    public static boolean hasAnnotation(ExecutableElement method, String annotationClass, DocletEnvironment environment) {
        Optional<ExecutableElement> interfaceMethod = JavaDocUtils.getInterfaceMethod(method, environment);
        boolean definedOnInterface = false;
        if (interfaceMethod.isPresent()) {
            definedOnInterface = JavaDocUtils.hasAnnotation(interfaceMethod.get().getAnnotationMirrors(), annotationClass);
        }
        return definedOnInterface || JavaDocUtils.hasAnnotation(method.getAnnotationMirrors(), annotationClass);
    }

    public static boolean hasAnnotation(TypeElement clazz, Class annotationClass, DocletEnvironment environment) {
        List<? extends AnnotationMirror> allAnnotationMirrors = JavaDocUtils.collectAllAnnotationMirrors(clazz, environment);
        return JavaDocUtils.hasAnnotation(allAnnotationMirrors, annotationClass);
    }

    private static List<? extends AnnotationMirror> collectAllAnnotationMirrors(TypeElement clazz, DocletEnvironment environment) {
        ArrayList<? extends AnnotationMirror> allAnnotationMirrors = new ArrayList<AnnotationMirror>();
        if (clazz == null) {
            return allAnnotationMirrors;
        }
        allAnnotationMirrors.addAll(clazz.getAnnotationMirrors());
        clazz.getInterfaces().forEach(iface -> allAnnotationMirrors.addAll(JavaDocUtils.collectAllAnnotationMirrors((TypeElement)environment.getTypeUtils().asElement((TypeMirror)iface), environment)));
        Optional.ofNullable(clazz.getSuperclass()).ifPresent(superClass -> allAnnotationMirrors.addAll(JavaDocUtils.collectAllAnnotationMirrors((TypeElement)environment.getTypeUtils().asElement((TypeMirror)superClass), environment)));
        return allAnnotationMirrors;
    }

    private static boolean hasAnnotation(List<? extends AnnotationMirror> annotations, Class annotationClass) {
        return JavaDocUtils.hasAnnotation(annotations, annotationClass.getCanonicalName());
    }

    private static boolean hasAnnotation(List<? extends AnnotationMirror> annotations, String annotationClass) {
        return annotations.stream().anyMatch(a -> ((TypeElement)a.getAnnotationType().asElement()).getQualifiedName().toString().equals(annotationClass));
    }

    public static String getCommentTextFromInterfaceOrClass(TypeElement clazz, DocletEnvironment environment, boolean stripInlineTags) {
        Optional<TypeElement> interfaceClass = JavaDocUtils.getInterfaceClass(clazz, environment);
        String onInterface = null;
        if (interfaceClass.isPresent()) {
            onInterface = JavaDocUtils.getCommentText(interfaceClass.get(), environment, stripInlineTags);
        }
        return onInterface != null ? onInterface : JavaDocUtils.getCommentText(clazz, environment, stripInlineTags);
    }

    public static String getCommentTextFromInterfaceOrClass(ExecutableElement method, DocletEnvironment environment, boolean stripInlineTags) {
        Optional<ExecutableElement> interfaceMethod = JavaDocUtils.getInterfaceMethod(method, environment);
        String onInterface = null;
        if (interfaceMethod.isPresent()) {
            onInterface = JavaDocUtils.getCommentText(interfaceMethod.get(), environment, stripInlineTags);
        }
        return onInterface != null ? onInterface : JavaDocUtils.getCommentText(method, environment, stripInlineTags);
    }

    public static DocCommentTree getDocCommentTreeFromInterfaceOrClass(ExecutableElement method, DocletEnvironment environment) {
        Optional<ExecutableElement> interfaceMethod = JavaDocUtils.getInterfaceMethod(method, environment);
        DocCommentTree onInterface = null;
        if (interfaceMethod.isPresent()) {
            onInterface = environment.getDocTrees().getDocCommentTree(interfaceMethod.get());
        }
        return onInterface != null ? onInterface : environment.getDocTrees().getDocCommentTree(method);
    }

    public static ParamTree getParamTag(ExecutableElement method, int index, Map<String, ParamTree> paramTags, DocletEnvironment environment) {
        String name;
        Optional<ExecutableElement> interfaceMethod = JavaDocUtils.getInterfaceMethod(method, environment);
        if (interfaceMethod.isPresent() && paramTags.containsKey(name = interfaceMethod.get().getParameters().get(index).getSimpleName().toString())) {
            return paramTags.get(name);
        }
        return paramTags.get(method.getParameters().get(index).getSimpleName().toString());
    }

    public static Map<String, ParamTree> getParamTags(ExecutableElement method, DocletEnvironment environment) {
        Optional<ExecutableElement> interfaceMethod = JavaDocUtils.getInterfaceMethod(method, environment);
        Map<Object, Object> onInterface = new HashMap();
        if (interfaceMethod.isPresent()) {
            onInterface = JavaDocUtils.getBlockTags(interfaceMethod.get(), environment).stream().filter(d -> d instanceof ParamTree).map(d -> (ParamTree)d).collect(Collectors.toMap(p -> p.getName().getName().toString(), p -> p));
        }
        Map<String, ParamTree> onClass = JavaDocUtils.getBlockTags(method, environment).stream().filter(d -> d instanceof ParamTree).map(d -> (ParamTree)d).collect(Collectors.toMap(p -> p.getName().getName().toString(), p -> p));
        onClass.putAll(onInterface);
        return onClass;
    }

    public static String getParamTreeComment(ParamTree param) {
        List<? extends DocTree> description = param.getDescription();
        if (description.isEmpty()) {
            return "";
        }
        return JavaDocUtils.getCommentTextWithoutInlineTags(description);
    }

    public static List<? extends DocTree> getTags(ExecutableElement method, DocletEnvironment environment) {
        Optional<ExecutableElement> interfaceMethod = JavaDocUtils.getInterfaceMethod(method, environment);
        List<? extends DocTree> onInterface = null;
        if (interfaceMethod.isPresent()) {
            onInterface = environment.getDocTrees().getDocCommentTree(interfaceMethod.get()).getBlockTags();
        }
        return onInterface != null ? onInterface : environment.getDocTrees().getDocCommentTree(method).getBlockTags();
    }

    public static boolean containedFieldNamesAreNotAvailableOrPackageExcluded(TypeMirror fieldType, Options options) {
        Element element = options.environment.getTypeUtils().asElement(fieldType);
        return element == null || options.scanPackages.stream().noneMatch(pack -> JavaDocUtils.getPackageName(element, options.environment).startsWith((String)pack)) || JavaDocUtils.getDataFields(fieldType, options.environment).isEmpty() || JavaDocUtils.getDataFields(fieldType, options.environment).keySet().stream().anyMatch(k -> k.matches("arg\\d"));
    }

    public static String getPublicName(VariableElement param) {
        if (JavaDocUtils.hasDirectAnnotation(param, JSON_PROPERTY)) {
            return (String)JavaDocUtils.getDirectAnnotationValue(param, JSON_PROPERTY, "value");
        }
        if (JavaDocUtils.hasDirectAnnotation(param, JSON_PROPERTY_LEGACY)) {
            return (String)JavaDocUtils.getDirectAnnotationValue(param, JSON_PROPERTY_LEGACY, "value");
        }
        return param.getSimpleName().toString();
    }

    public static Map<String, TypeMirror> getDataFields(RestMethodData.ParameterInfo param, DocletEnvironment environment) {
        LinkedHashMap<String, TypeMirror> dataFields = new LinkedHashMap<String, TypeMirror>();
        if (JavaDocUtils.equalsClass(param.entityClass, FormParameters.class, environment)) {
            param.nestedParameters.forEach(np -> dataFields.put(np.name, np.displayClass != null ? np.displayClass : np.entityClass));
        } else {
            dataFields.putAll(JavaDocUtils.getDataFields(param.displayClass != null ? param.displayClass : param.entityClass, environment));
        }
        return dataFields;
    }

    private static boolean equalsClass(TypeMirror typeMirror, Class<?> otherClass, DocletEnvironment environment) {
        if (typeMirror.getKind().isPrimitive()) {
            return false;
        }
        Element element = environment.getTypeUtils().asElement(typeMirror);
        if (element == null) {
            return false;
        }
        PackageElement packageElement = environment.getElementUtils().getPackageOf(element);
        return element.getSimpleName().toString().equals(otherClass.getSimpleName()) && packageElement.getQualifiedName().toString().equals(otherClass.getPackageName());
    }

    public static Map<String, TypeMirror> getDataFields(TypeMirror type, DocletEnvironment environment) {
        Optional superTypeMirror;
        if (type.getKind().isPrimitive()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, TypeMirror> dataFields = new LinkedHashMap<String, TypeMirror>();
        List<VariableElement> fields = JavaDocUtils.getVisibleFields(type, environment);
        fields.forEach(field -> {
            TypeMirror fieldType = field.asType();
            dataFields.put(JavaDocUtils.getPublicName(field), fieldType);
        });
        if (fields.isEmpty()) {
            JavaDocUtils.getGetters(type, dataFields, environment);
        }
        if ((superTypeMirror = environment.getTypeUtils().directSupertypes(type).stream().findFirst()).isPresent() && !JavaDocUtils.isJavaType((TypeMirror)superTypeMirror.get(), environment)) {
            dataFields.putAll(JavaDocUtils.getDataFields((TypeMirror)superTypeMirror.get(), environment));
        }
        return dataFields;
    }

    private static void getGetters(TypeMirror type, Map<String, TypeMirror> dataFields, DocletEnvironment environment) {
        if (type.getKind().isPrimitive()) {
            return;
        }
        List<ExecutableElement> getters = JavaDocUtils.getVisibleGetters(type, environment);
        if (!JavaDocUtils.isJavaType(type, environment)) {
            getters.forEach(getter -> {
                TypeMirror fieldType = getter.getReturnType();
                dataFields.put(JavaDocUtils.getNameFromGetter(getter, environment), fieldType);
            });
        }
        if (getters.isEmpty()) {
            ExecutableElement chosenCtor = null;
            TypeElement element = (TypeElement)environment.getTypeUtils().asElement(type);
            List ctors = environment.getElementUtils().getAllMembers(element).stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).collect(Collectors.toList());
            for (ExecutableElement ctor : ctors) {
                if (chosenCtor == null) {
                    chosenCtor = ctor;
                    continue;
                }
                if (JavaDocUtils.getVisibleCtorParameters(ctor).size() <= JavaDocUtils.getVisibleCtorParameters(chosenCtor).size()) continue;
                chosenCtor = ctor;
            }
            if (chosenCtor != null) {
                for (VariableElement param : JavaDocUtils.getVisibleCtorParameters(chosenCtor)) {
                    dataFields.put(JavaDocUtils.getPublicName(param), param.asType());
                }
            }
        }
    }

    public static boolean isArrayType(TypeMirror type) {
        return type instanceof ArrayType;
    }

    public static boolean isCollectionType(TypeMirror type) {
        return type != null && (type instanceof ArrayType || type.toString().startsWith("java.util.List") || type.toString().startsWith("java.util.Set"));
    }

    public static TypeMirror getExtendedCollectionType(TypeMirror type, DocletEnvironment environment) {
        Element element = environment.getTypeUtils().asElement(type);
        if (!(element instanceof TypeElement)) {
            return null;
        }
        TypeElement typeElement = (TypeElement)element;
        List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            if (!JavaDocUtils.isCollectionType(typeMirror)) continue;
            return typeMirror;
        }
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass instanceof NoType) {
            return null;
        }
        if (JavaDocUtils.isCollectionType(superclass)) {
            return superclass;
        }
        return JavaDocUtils.getExtendedCollectionType(superclass, environment);
    }

    public static boolean isMapType(TypeMirror type) {
        return type != null && type.toString().startsWith("java.util.Map");
    }

    public static String getTypeString(TypeMirror type, DocletEnvironment environment) {
        if (type.getKind().isPrimitive()) {
            return JavaDocUtils.getPrimitiveTypeString(type);
        }
        Element element = environment.getTypeUtils().asElement(type);
        if (element == null) {
            return "String";
        }
        if (JavaDocUtils.isEnum(type, environment)) {
            StringJoiner sj = new StringJoiner("|");
            JavaDocUtils.getEnumValuesAsList(type, environment).forEach(ev -> sj.add(ev.getSimpleName().toString()));
            return sj.toString();
        }
        Object name = element.getSimpleName().toString();
        if (JavaDocUtils.isArrayType(type)) {
            name = (String)name + "[]";
        }
        if (((String)name).equals("byte[]")) {
            return "String";
        }
        return name;
    }

    public static String getSimpleTypeName(TypeMirror type, DocletEnvironment environment) {
        if (type.getKind().isPrimitive()) {
            return JavaDocUtils.getPrimitiveTypeString(type);
        }
        Element element = environment.getTypeUtils().asElement(type);
        if (type instanceof ArrayType) {
            element = environment.getTypeUtils().asElement(((ArrayType)type).getComponentType());
        }
        if (element == null) {
            return "String";
        }
        String simpleName = JavaDocUtils.getPublicName(element);
        if (type instanceof ArrayType) {
            return simpleName + "[]";
        }
        if (JavaDocUtils.isCollectionType(type)) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
            return simpleName + "[" + JavaDocUtils.getSimpleTypeName(typeArguments.get(0), environment) + "]";
        }
        if (JavaDocUtils.isMapType(type)) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
            return simpleName + "[" + JavaDocUtils.getSimpleTypeName(typeArguments.get(0), environment) + ", " + JavaDocUtils.getSimpleTypeName(typeArguments.get(1), environment) + "]";
        }
        return simpleName;
    }

    public static String getPublicName(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        String publicName = null;
        if (JavaDocUtils.hasAnnotation(annotationMirrors, ApiLabel.class)) {
            publicName = (String)JavaDocUtils.getAnnotationValue(annotationMirrors, ApiLabel.class.getCanonicalName(), "value");
        } else if (JavaDocUtils.hasAnnotation(annotationMirrors, XML_ROOT_ELEMENT)) {
            publicName = (String)JavaDocUtils.getAnnotationValue(annotationMirrors, XML_ROOT_ELEMENT, "name");
        } else if (JavaDocUtils.hasAnnotation(annotationMirrors, JACKSON_XML_ROOT_ELEMENT)) {
            publicName = (String)JavaDocUtils.getAnnotationValue(annotationMirrors, JACKSON_XML_ROOT_ELEMENT, "localName");
        }
        if (publicName == null) {
            publicName = element.getSimpleName().toString();
        }
        return publicName;
    }

    private static String getPrimitiveTypeString(TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case SHORT: {
                return "short";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case CHAR: {
                return "char";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case VOID: {
                return "void";
            }
        }
        return "unknown";
    }

    public static boolean typeCantBeDocumented(TypeMirror type, Options options) {
        if (type != null && JavaDocUtils.equalsClass(type, FormParameters.class, options.environment)) {
            return false;
        }
        Element element = options.environment.getTypeUtils().asElement(type);
        return type == null || element == null || type.getKind().isPrimitive() || JavaDocUtils.getPackageName(element, options.environment).startsWith("java.") || JavaDocUtils.containedFieldNamesAreNotAvailableOrPackageExcluded(type, options);
    }

    public static boolean isJavaType(TypeMirror type, DocletEnvironment environment) {
        Element element = environment.getTypeUtils().asElement(type);
        String packageName = JavaDocUtils.getPackageName(element, environment);
        return packageName.startsWith("java.");
    }

    public static List<VariableElement> getVisibleFields(TypeMirror type, DocletEnvironment environment) {
        if (type.getKind().isPrimitive()) {
            return Collections.emptyList();
        }
        TypeElement element = (TypeElement)environment.getTypeUtils().asElement(type);
        List fields = environment.getElementUtils().getAllMembers(element).stream().filter(e -> e instanceof VariableElement).map(e -> (VariableElement)e).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC)).collect(Collectors.toList());
        return fields.stream().filter(JavaDocUtils::fieldIsVisible).collect(Collectors.toList());
    }

    private static boolean fieldIsVisible(VariableElement field) {
        return !JavaDocUtils.hasDirectAnnotation(field, ApiIgnore.class) && !JavaDocUtils.hasDirectAnnotation(field, XML_TRANSIENT) && !JavaDocUtils.hasDirectAnnotation(field, JSON_IGNORE) && !JavaDocUtils.hasDirectAnnotation(field, JSON_IGNORE_LEGACY) && !field.getModifiers().contains((Object)Modifier.STATIC) && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && field.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public static List<ExecutableElement> getVisibleGetters(TypeMirror type, DocletEnvironment environment) {
        if (JavaDocUtils.isJavaType(type, environment) || type.getKind().isPrimitive()) {
            return Collections.emptyList();
        }
        TypeElement element = (TypeElement)environment.getTypeUtils().asElement(type);
        List methods = environment.getElementUtils().getAllMembers(element).stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).filter(e -> e.getReturnType() != null).filter(e -> environment.getTypeUtils().isSameType(element.asType(), e.getEnclosingElement().asType())).collect(Collectors.toList());
        return methods.stream().filter(e -> JavaDocUtils.methodIsVisibleGetter(e, environment)).collect(Collectors.toList());
    }

    private static boolean methodIsVisibleGetter(ExecutableElement method, DocletEnvironment environment) {
        return !JavaDocUtils.hasAnnotation(method, ApiIgnore.class, environment) && !JavaDocUtils.hasAnnotation(method, XML_TRANSIENT, environment) && !JavaDocUtils.hasAnnotation(method, JSON_IGNORE, environment) && !JavaDocUtils.hasAnnotation(method, JSON_IGNORE_LEGACY, environment) && method.getSimpleName().toString().startsWith("get") && !method.getSimpleName().toString().equals("get") && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.TRANSIENT) && method.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public static List<VariableElement> getVisibleCtorParameters(ExecutableElement chosenCtor) {
        return chosenCtor.getParameters().stream().filter(JavaDocUtils::parameterIsVisible).collect(Collectors.toList());
    }

    private static boolean parameterIsVisible(VariableElement param) {
        return !JavaDocUtils.hasDirectAnnotation(param, ApiIgnore.class);
    }

    public static String getNameFromGetter(ExecutableElement getter, DocletEnvironment environment) {
        if (JavaDocUtils.hasAnnotation(getter, JSON_PROPERTY, environment)) {
            return (String)JavaDocUtils.getAnnotationValue(getter, JSON_PROPERTY, "value", environment);
        }
        if (JavaDocUtils.hasAnnotation(getter, JSON_PROPERTY_LEGACY, environment)) {
            return (String)JavaDocUtils.getAnnotationValue(getter, JSON_PROPERTY_LEGACY, "value", environment);
        }
        String simpleName = getter.getSimpleName().toString();
        return simpleName.substring(3, 4).toLowerCase() + simpleName.substring(4);
    }

    public static List<TypeElement> getTypeElements(DocletEnvironment environment) {
        return environment.getIncludedElements().stream().filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e).collect(Collectors.toList());
    }

    public static List<ExecutableElement> getExecutableElements(Element element) {
        return element.getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).collect(Collectors.toList());
    }

    public static List<ExecutableElement> getConstructors(TypeMirror typeMirror, DocletEnvironment environment) {
        return JavaDocUtils.getConstructors(environment.getTypeUtils().asElement(typeMirror));
    }

    public static List<ExecutableElement> getConstructors(Element element) {
        return JavaDocUtils.getExecutableElements(element).stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).collect(Collectors.toList());
    }

    public static String getCommentText(Element element, DocletEnvironment environment, boolean stripInlineTags) {
        if (!stripInlineTags) {
            return Optional.ofNullable(environment.getElementUtils().getDocComment(element)).orElse("");
        }
        DocCommentTree docCommentTree = environment.getDocTrees().getDocCommentTree(element);
        if (docCommentTree == null) {
            return "";
        }
        return JavaDocUtils.getCommentTextWithoutInlineTags(docCommentTree.getFullBody());
    }

    public static String getCommentTextWithoutInlineTags(List<? extends DocTree> description) {
        return description.stream().filter(tag -> tag instanceof TextTree || tag instanceof StartElementTree || tag instanceof EndElementTree).map(Object::toString).collect(Collectors.joining());
    }

    public static boolean isEnum(TypeMirror typeMirror, DocletEnvironment environment) {
        Element element = environment.getTypeUtils().asElement(typeMirror);
        return element != null && element.getKind() == ElementKind.ENUM;
    }

    public static String getPackageName(TypeMirror typeMirror, DocletEnvironment environment) {
        Element element = environment.getTypeUtils().asElement(typeMirror);
        return JavaDocUtils.getPackageName(element, environment);
    }

    public static String getPackageName(Element element, DocletEnvironment environment) {
        return environment.getElementUtils().getPackageOf(element).getQualifiedName().toString();
    }

    public static String getQualifiedName(TypeMirror typeMirror, DocletEnvironment environment) {
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            return JavaDocUtils.getQualifiedName(((ArrayType)typeMirror).getComponentType(), environment) + "[]";
        }
        Element element = environment.getTypeUtils().asElement(typeMirror);
        String name = JavaDocUtils.getPackageName(element, environment) + ".";
        if (element.getEnclosingElement().getKind().isClass()) {
            name = name + element.getEnclosingElement().getSimpleName() + "$";
        }
        return name + element.getSimpleName().toString();
    }

    public static Element asElement(TypeMirror typeMirror, DocletEnvironment environment) {
        return environment.getTypeUtils().asElement(typeMirror);
    }

    public static List<VariableElement> getEnumValuesAsList(TypeMirror enumType, DocletEnvironment environment) {
        Element element = environment.getTypeUtils().asElement(enumType);
        return JavaDocUtils.getEnumValuesAsList((TypeElement)element, environment);
    }

    public static List<VariableElement> getEnumValuesAsList(TypeElement element, DocletEnvironment environment) {
        return environment.getElementUtils().getAllMembers(element).stream().filter(m -> m.getKind() == ElementKind.ENUM_CONSTANT).map(m -> (VariableElement)m).collect(Collectors.toList());
    }

    public static List<? extends DocTree> getBlockTags(Element parameter, DocletEnvironment environment) {
        DocCommentTree docCommentTree = environment.getDocTrees().getDocCommentTree(parameter);
        return docCommentTree == null ? Collections.emptyList() : docCommentTree.getBlockTags();
    }

    public static List<? extends DocTree> getInlineTags(Element parameter, DocletEnvironment environment) {
        DocCommentTree docCommentTree = environment.getDocTrees().getDocCommentTree(parameter);
        return docCommentTree == null ? Collections.emptyList() : docCommentTree.getFullBody().stream().filter(d -> d.getKind() != DocTree.Kind.TEXT).collect(Collectors.toList());
    }

    public static Element getReferencedElement(Element e, DocTree dtree, DocletEnvironment environment) {
        DocCommentTree docCommentTree;
        TreePath elementPath = environment.getDocTrees().getPath(e);
        DocCommentTree docCommentTree2 = docCommentTree = e instanceof ExecutableElement ? JavaDocUtils.getDocCommentTreeFromInterfaceOrClass((ExecutableElement)e, environment) : environment.getDocTrees().getDocCommentTree(e);
        if (elementPath == null || docCommentTree == null) {
            return null;
        }
        DocTreePath path = DocTreePath.getPath(elementPath, docCommentTree, dtree);
        return path == null ? null : environment.getDocTrees().getElement(path);
    }
}

