/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public abstract class FileUtils {
    private FileUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File toCopy, File destFile) {
        try (FileInputStream fileInputStream = new FileInputStream(toCopy);){
            boolean bl;
            try (FileOutputStream fileOutputStream = new FileOutputStream(destFile);){
                bl = FileUtils.copyStream((InputStream)fileInputStream, fileOutputStream);
            }
            return bl;
        }
        catch (IOException e) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    private static boolean copyFilesRecusively(File toCopy, File destDir) {
        assert (destDir.isDirectory());
        if (!toCopy.isDirectory()) {
            return FileUtils.copyFile(toCopy, new File(destDir, toCopy.getName()));
        }
        File newDestDir = new File(destDir, toCopy.getName());
        if (!newDestDir.exists() && !newDestDir.mkdir()) {
            return false;
        }
        File[] listFiles = toCopy.listFiles();
        if (listFiles != null) {
            for (File child : listFiles) {
                if (FileUtils.copyFilesRecusively(child, newDestDir)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyJarResourcesRecursively(File destDir, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String filename = StringUtils.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            File f = new File(destDir, filename);
            if (!entry.isDirectory()) {
                InputStream entryInputStream = jarFile.getInputStream(entry);
                try {
                    if (FileUtils.copyStream(entryInputStream, f)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (entryInputStream != null) {
                        entryInputStream.close();
                    }
                    continue;
                }
            }
            if (FileUtils.ensureDirectoryExists(f)) continue;
            throw new IOException("Could not create directory: " + f.getAbsolutePath());
        }
        return true;
    }

    public static boolean copyResourcesRecursively(URL originUrl, File destination) {
        try {
            URLConnection urlConnection = originUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                return FileUtils.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
            }
            return FileUtils.copyFilesRecusively(new File(originUrl.getPath()), destination);
        }
        catch (IOException e) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    public static List<String> listFiles(URL originUrl) {
        ArrayList<String> files = new ArrayList<String>();
        if (originUrl == null) {
            return files;
        }
        try {
            URLConnection urlConnection = originUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                Enumeration<JarEntry> entries = ((JarURLConnection)urlConnection).getJarFile().entries();
                while (entries.hasMoreElements()) {
                    files.add(entries.nextElement().getName());
                }
            } else {
                String[] list = new File(originUrl.getPath()).list();
                if (list != null) {
                    files.addAll(Arrays.asList(list));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return files;
    }

    private static boolean copyStream(InputStream is, File f) {
        try {
            return FileUtils.copyStream(is, new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    private static boolean copyStream(InputStream is, OutputStream os) {
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
            return true;
        }
        catch (IOException e) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    private static boolean ensureDirectoryExists(File f) {
        return f.exists() || f.mkdir();
    }
}

