/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.shortcode;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.oneandone.neberus.shortcode.ShortCode;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;

public class ShortCodeExpander {
    private final Map<String, Function<String, String>> shortCodes;
    private final Pattern shortCodePattern = Pattern.compile("\\[\\[[^\\[]*]\\[[^\\[]*]]");

    public ShortCodeExpander() {
        this.shortCodes = this.loadShortCodes();
    }

    private Map<String, Function<String, String>> loadShortCodes() {
        Reflections reflections = new Reflections(new Object[0]);
        Set shortcodeClasses = reflections.getSubTypesOf(ShortCode.class);
        if (shortcodeClasses.isEmpty()) {
            return Collections.emptyMap();
        }
        String shortCodeNames = shortcodeClasses.stream().map(Class::getSimpleName).collect(Collectors.joining(", "));
        System.out.println("Loading shortcodes " + shortCodeNames);
        HashMap<String, Function<String, String>> loadedShortCodes = new HashMap<String, Function<String, String>>();
        shortcodeClasses.forEach(clazz -> {
            try {
                ShortCode shortCodeInstance = (ShortCode)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                loadedShortCodes.put(shortCodeInstance.getKey(), shortCodeInstance::process);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                System.err.println("Can't load shortcode " + clazz.getName() + ": " + e);
            }
        });
        return loadedShortCodes;
    }

    public String expand(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return input;
        }
        HashMap<String, String> matches = new HashMap<String, String>();
        Matcher matcher = this.shortCodePattern.matcher(input);
        while (matcher.find()) {
            String match = matcher.group();
            String key = match.replaceFirst("\\[\\[(.*)]\\[.*", "$1");
            String value = match.replaceFirst(".*]\\[(.*)]].*", "$1");
            if (this.shortCodes.containsKey(key)) {
                String expanded = this.shortCodes.get(key).apply(value);
                matches.put(match, expanded);
                continue;
            }
            System.err.println("Unknown shortcode key: " + key);
        }
        String output = input;
        for (Map.Entry match : matches.entrySet()) {
            output = output.replace((CharSequence)match.getKey(), (CharSequence)match.getValue());
        }
        return output;
    }
}

