/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.print.openapiv3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import net.oneandone.neberus.NeberusModule;
import net.oneandone.neberus.Options;
import net.oneandone.neberus.parse.RestClassData;
import net.oneandone.neberus.parse.RestMethodData;
import net.oneandone.neberus.parse.RestUsecaseData;
import net.oneandone.neberus.print.AsciiDocPrinter;
import net.oneandone.neberus.print.DocPrinter;
import net.oneandone.neberus.print.MarkdownPrinter;
import net.oneandone.neberus.shortcode.ShortCodeExpander;
import net.oneandone.neberus.util.JavaDocUtils;
import org.apache.commons.lang3.StringUtils;

public class OpenApiV3JsonPrinter
extends DocPrinter {
    private final ObjectMapper mapper;
    private final MarkdownPrinter markdownPrinter = new MarkdownPrinter();
    private final AsciiDocPrinter asciiDocPrinter = new AsciiDocPrinter();

    public OpenApiV3JsonPrinter(List<NeberusModule> modules, ShortCodeExpander expander, Options options) {
        super(modules, expander, options);
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public void printRestClassFile(RestClassData restClassData, List<RestClassData> allRestClasses, List<RestUsecaseData> restUsecases) {
    }

    @Override
    public void printIndexFile(List<RestClassData> restClasses, List<RestUsecaseData> restUsecases, String packageDoc) {
        OpenAPI openAPI = new OpenAPI();
        Components components = new Components();
        openAPI.info(this.getInfo(packageDoc)).paths(this.getPaths(restClasses, restUsecases, components)).components(components).servers(this.getServers());
        openAPI.addExtension("x-resources-metadata", this.getResourcesMetadata(restClasses));
        openAPI.addExtension("x-usecases", this.getUsecasesExtension(restUsecases));
        try {
            String jsonString = this.mapper.writeValueAsString((Object)openAPI);
            this.saveToFile(jsonString, this.options.outputDirectory + this.options.docBasePath, "openApi.json");
            String escapedJsonString = jsonString.replaceAll("\\\\", "\\\\\\\\").replaceAll("`", "\\\\`");
            String jsonVar = "var openApiJsonString = `" + escapedJsonString + "`;";
            this.saveToFile(jsonVar, this.options.outputDirectory + this.options.docBasePath, "openApi.js");
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private List<Server> getServers() {
        ArrayList<Server> servers = new ArrayList<Server>();
        this.options.apiHosts.forEach(host -> {
            String[] split = host.trim().split("\\[");
            Server server = new Server();
            server.url(split[0]);
            if (split.length > 1) {
                server.description(split[1].substring(0, split[1].length() - 1));
            }
            servers.add(server);
        });
        return servers;
    }

    private Map<String, Map<String, String>> getResourcesMetadata(List<RestClassData> restClasses) {
        return restClasses.stream().collect(Collectors.toMap(clazz -> clazz.className, clazz -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("description", this.expand(clazz.description));
            metadata.put("shortDescription", this.expand(clazz.shortDescription));
            metadata.put("label", clazz.label);
            return metadata;
        }));
    }

    private String expand(String description) {
        String htmlDescription;
        if (StringUtils.isBlank((CharSequence)description)) {
            return description;
        }
        switch (this.options.markup) {
            case MARKDOWN: {
                htmlDescription = this.markdownPrinter.print(description);
                break;
            }
            case ASCIIDOC: {
                htmlDescription = this.asciiDocPrinter.print(description);
                break;
            }
            default: {
                htmlDescription = description;
            }
        }
        String htmlReplacedDescription = htmlDescription.replaceAll("[^<br>](\n\n)", "$0<br>");
        return this.expander.expand(htmlReplacedDescription);
    }

    private Paths getPaths(List<RestClassData> restClasses, List<RestUsecaseData> restUsecases, Components components) {
        Paths paths = new Paths();
        restClasses.forEach(restClassData -> this.addRestClass((RestClassData)restClassData, restUsecases, paths, restClasses, components));
        return paths;
    }

    private Info getInfo(String packageDoc) {
        Info info = new Info();
        info.description(this.expand(packageDoc)).title(this.options.apiTitle).version(this.options.apiVersion);
        info.addExtension("x-generated-at", (Object)Instant.now().toString());
        info.addExtension("x-generated-by", (Object)"https://github.com/1and1/neberus");
        info.addExtension("x-generated-by-version", (Object)this.getClass().getPackage().getImplementationVersion());
        return info;
    }

    private HashMap<String, Object> getUsecasesExtension(List<RestUsecaseData> restUsecases) {
        if (restUsecases.isEmpty()) {
            return null;
        }
        HashMap<String, Object> usecaseOverview = new HashMap<String, Object>();
        restUsecases.forEach(restUsecaseData -> {
            usecaseOverview.put("description", this.expand(restUsecaseData.description));
            HashMap usecases = new HashMap();
            usecaseOverview.put("usecases", usecases);
            restUsecaseData.usecases.forEach(usecaseData -> {
                HashMap<String, Object> usecase = new HashMap<String, Object>();
                usecases.put(usecaseData.id, usecase);
                usecase.put("name", usecaseData.name);
                usecase.put("description", this.expand(usecaseData.description));
                LinkedList methods = new LinkedList();
                usecase.put("methods", methods);
                usecaseData.methods.forEach(usecaseMethodData -> {
                    HashMap<String, Object> method = new HashMap<String, Object>();
                    methods.add(method);
                    method.put("path", usecaseMethodData.path);
                    method.put("httpMethod", usecaseMethodData.httpMethod);
                    method.put("description", this.expand(usecaseMethodData.description));
                    Map<String, HashMap<String, String>> params = this.toStringMap(usecaseMethodData.parameters);
                    method.put("parameters", params);
                    Map<String, HashMap<String, String>> requestBody = this.toStringMap(usecaseMethodData.requestBody);
                    method.put("requestBody", requestBody);
                    Map<String, HashMap<String, String>> responseBody = this.toStringMap(usecaseMethodData.responseBody);
                    method.put("responseBody", responseBody);
                    RestMethodData linkedMethod = usecaseMethodData.linkedMethod;
                    if (linkedMethod != null) {
                        HashMap<String, String> linkedMethodMap = this.getLinkedMethodMap(linkedMethod);
                        method.put("linkedMethod", linkedMethodMap);
                    }
                });
            });
        });
        return usecaseOverview;
    }

    private HashMap<String, String> getLinkedMethodMap(RestMethodData linkedMethod) {
        HashMap<String, String> linkedMethodMap = new HashMap<String, String>();
        linkedMethodMap.put("operationId", this.getOperationId(linkedMethod));
        linkedMethodMap.put("resource", linkedMethod.containingClass.className);
        linkedMethodMap.put("label", linkedMethod.methodData.label);
        linkedMethodMap.put("httpMethod", linkedMethod.methodData.httpMethod);
        return linkedMethodMap;
    }

    private String getOperationId(RestMethodData linkedMethod) {
        return linkedMethod.methodData.httpMethod.toUpperCase() + "-" + linkedMethod.methodData.label.replaceAll("[^A-Za-z0-9]", "_");
    }

    private Map<String, HashMap<String, String>> toStringMap(Map<String, RestUsecaseData.UsecaseValueInfo> valueInfoMap) {
        return valueInfoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("value", ((RestUsecaseData.UsecaseValueInfo)e.getValue()).value);
            param.put("valueHint", ((RestUsecaseData.UsecaseValueInfo)e.getValue()).valueHint);
            return param;
        }));
    }

    private void addRestClass(RestClassData restClassData, List<RestUsecaseData> restUsecases, Paths paths, List<RestClassData> allRestClasses, Components components) {
        restClassData.methods.stream().collect(Collectors.groupingBy(e -> e.methodData.path)).forEach((path, methods) -> {
            PathItem pathItem;
            if (paths.containsKey(path)) {
                pathItem = (PathItem)paths.get(path);
            } else {
                pathItem = new PathItem();
                paths.addPathItem(path, pathItem);
            }
            methods.forEach(method -> pathItem.operation(PathItem.HttpMethod.valueOf((String)method.methodData.httpMethod), this.getOperation(restClassData, restUsecases, (RestMethodData)method, allRestClasses, components)));
        });
    }

    private Operation getOperation(RestClassData restClassData, List<RestUsecaseData> restUsecases, RestMethodData method, List<RestClassData> allRestClasses, Components components) {
        List<RestUsecaseData.UsecaseData> relatedUsecases;
        Operation operation = new Operation();
        operation.operationId(this.getOperationId(method)).summary(method.methodData.label).description(this.expand(method.methodData.description)).parameters(this.getParameterItems(restClassData, method.requestData.parameters, method.methodData, components)).deprecated(Boolean.valueOf(method.methodData.deprecated)).addTagsItem("resource:" + restClassData.className).requestBody(this.getRequestBody(method.requestData, method.methodData, components)).responses(this.getApiResponses(restClassData, method.responseData, method.methodData, components));
        if (method.methodData.deprecated) {
            operation.addExtension("x-deprecated-description", (Object)this.expand(method.methodData.deprecatedDescription));
        }
        if (!method.methodData.links.isEmpty()) {
            ArrayList linkedMethods = new ArrayList();
            for (ExecutableElement link : method.methodData.links) {
                for (RestClassData restClass : allRestClasses) {
                    Optional<RestMethodData> linkedMethod = restClass.methods.stream().filter(m -> m.methodData.methodDoc.equals(link)).findFirst();
                    linkedMethod.ifPresent(restMethodData -> linkedMethods.add(this.getLinkedMethodMap((RestMethodData)restMethodData)));
                }
            }
            operation.addExtension("x-linked-methods", linkedMethods);
        }
        if (method.methodData.printCurl) {
            operation.addExtension("x-curl-enabled", (Object)true);
            if (method.methodData.curl != null) {
                operation.addExtension("x-curl-example", (Object)method.methodData.curl);
            }
        }
        if (!(relatedUsecases = this.getRelatedUsecases(restUsecases, method)).isEmpty()) {
            List usecaseIds = relatedUsecases.stream().map(usecase -> usecase.id).collect(Collectors.toList());
            operation.addExtension("x-related-usecases", usecaseIds);
        }
        return operation;
    }

    private ApiResponses getApiResponses(RestClassData restClassData, List<RestMethodData.ResponseData> responseData, RestMethodData.MethodData methodData, Components components) {
        ApiResponses apiResponses = new ApiResponses();
        restClassData.commonResponseData.forEach(response -> {
            ApiResponse apiResponse = this.getApiResponse(restClassData, methodData, components, (RestMethodData.ResponseData)response);
            apiResponses.addApiResponse(String.valueOf(response.status.value), apiResponse);
        });
        responseData.forEach(response -> {
            ApiResponse apiResponse = this.getApiResponse(restClassData, methodData, components, (RestMethodData.ResponseData)response);
            apiResponses.addApiResponse(String.valueOf(response.status.value), apiResponse);
        });
        return apiResponses;
    }

    private ApiResponse getApiResponse(RestClassData restClassData, RestMethodData.MethodData methodData, Components components, RestMethodData.ResponseData response) {
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.description(this.expand(response.description));
        if (!response.entities.isEmpty()) {
            Content content = new Content();
            apiResponse.content(content);
            response.entities.forEach(entity -> {
                MediaType mediaType = new MediaType();
                if (StringUtils.isNotBlank((CharSequence)entity.description)) {
                    mediaType.addExtension("x-description", (Object)entity.description);
                }
                RestMethodData.ParameterInfo parameterInfo = new RestMethodData.ParameterInfo();
                parameterInfo.entityClass = entity.entityClass;
                parameterInfo.nestedParameters = entity.nestedParameters;
                mediaType.schema(this.toSchema(parameterInfo, entity.entityClass, Collections.emptyMap(), null, methodData, true, components));
                if (entity.contentType == null) {
                    System.err.println("Null content type for " + entity);
                }
                content.addMediaType(entity.contentType, mediaType);
                entity.examples.forEach(example -> {
                    Example ex = new Example();
                    ex.value((Object)example.value).description(this.expand(example.description));
                    mediaType.addExamples(example.title, ex);
                });
            });
        }
        response.headers.forEach(headerInfo -> {
            Header header = this.getHeader((RestMethodData.HeaderInfo)headerInfo);
            RestMethodData.HeaderInfo headerDefinition = restClassData.headerDefinitions.get(headerInfo.name);
            if (headerDefinition != null && StringUtils.isBlank((CharSequence)header.getDescription())) {
                header.description(this.expand(headerDefinition.description));
            }
            apiResponse.addHeaderObject(headerInfo.name, header);
        });
        return apiResponse;
    }

    private Header getHeader(RestMethodData.HeaderInfo headerInfo) {
        Header header = new Header();
        header.description(this.expand(headerInfo.description));
        header.required(Boolean.valueOf(headerInfo.isRequired()));
        header.deprecated(Boolean.valueOf(headerInfo.deprecated));
        if (headerInfo.deprecated) {
            header.addExtension("x-deprecated-description", (Object)this.expand(headerInfo.deprecatedDescription));
        }
        if (!headerInfo.allowedValues.isEmpty()) {
            ArrayList allowedValueList = new ArrayList();
            headerInfo.allowedValues.forEach(allowedValue -> {
                HashMap<String, String> allowedValueMap = new HashMap<String, String>();
                allowedValueMap.put("value", allowedValue.value);
                allowedValueMap.put("valueHint", allowedValue.valueHint);
                allowedValueList.add(allowedValueMap);
            });
            header.addExtension("x-allowed-values", allowedValueList);
        }
        return header;
    }

    private List<RestUsecaseData.UsecaseData> getRelatedUsecases(List<RestUsecaseData> restUsecases, RestMethodData method) {
        return restUsecases.stream().flatMap(u -> u.usecases.stream()).filter(usecase -> usecase.methods.stream().filter(usecaseMethodData -> usecaseMethodData.linkedMethod != null).anyMatch(usecaseMethodData -> usecaseMethodData.linkedMethod.equals(method))).collect(Collectors.toList());
    }

    private List<Parameter> getParameterItems(RestClassData restClassData, List<RestMethodData.ParameterInfo> parameters, RestMethodData.MethodData methodData, Components components) {
        return parameters.stream().filter(param -> param.parameterType != RestMethodData.ParameterType.BODY).map(param -> {
            RestMethodData.HeaderInfo headerDefinition;
            Parameter parameter = new Parameter();
            parameter.name(param.name).in(param.parameterType.name().toLowerCase()).description(this.expand(param.description)).deprecated(Boolean.valueOf(param.deprecated)).required(Boolean.valueOf(param.isRequired())).schema(this.toSchema((RestMethodData.ParameterInfo)param, param.entityClass, (Map<String, String>)new HashMap<String, String>(), null, methodData, true, components));
            parameter.addExtension("x-name-escaped", (Object)param.name.replaceAll("[^A-Za-z0-9]", "_"));
            if (param.deprecated) {
                parameter.addExtension("x-deprecated-description", (Object)this.expand(param.deprecatedDescription));
            }
            if (param.parameterType == RestMethodData.ParameterType.HEADER && StringUtils.isBlank((CharSequence)param.description) && (headerDefinition = restClassData.headerDefinitions.get(param.name)) != null) {
                parameter.description(this.expand(headerDefinition.description));
            }
            if (!param.allowedValues.isEmpty()) {
                ArrayList allowedValueList = new ArrayList();
                param.allowedValues.forEach(allowedValue -> {
                    HashMap<String, String> allowedValueMap = new HashMap<String, String>();
                    allowedValueMap.put("value", allowedValue.value);
                    allowedValueMap.put("valueHint", allowedValue.valueHint);
                    allowedValueList.add(allowedValueMap);
                });
                parameter.addExtension("x-allowed-values", allowedValueList);
            }
            return parameter;
        }).collect(Collectors.toList());
    }

    private RequestBody getRequestBody(RestMethodData.RequestData requestData, RestMethodData.MethodData methodData, Components components) {
        Optional<RestMethodData.Entity> fallbackBodyParam = requestData.entities.stream().filter(param -> StringUtils.isBlank((CharSequence)param.contentType)).findFirst();
        if (fallbackBodyParam.isEmpty()) {
            return null;
        }
        RequestBody requestBody = new RequestBody();
        Content content = new Content();
        requestBody.content(content);
        requestData.mediaType.forEach(type -> {
            MediaType mediaType = new MediaType();
            RestMethodData.Entity bodyParamForContentType = requestData.entities.stream().filter(param -> type.equals(param.contentType)).findFirst().orElse((RestMethodData.Entity)fallbackBodyParam.get());
            if (StringUtils.isNotBlank((CharSequence)bodyParamForContentType.description)) {
                mediaType.addExtension("x-description", (Object)bodyParamForContentType.description);
            }
            RestMethodData.ParameterInfo parameterInfo = new RestMethodData.ParameterInfo();
            parameterInfo.entityClass = bodyParamForContentType.entityClass;
            parameterInfo.nestedParameters = bodyParamForContentType.nestedParameters;
            mediaType.schema(this.toSchema(parameterInfo, bodyParamForContentType.entityClass, Collections.emptyMap(), null, methodData, true, components));
            bodyParamForContentType.examples.forEach(example -> {
                Example ex = new Example();
                ex.value((Object)example.value).description(this.expand(example.description));
                mediaType.addExamples(example.title, ex);
            });
            content.addMediaType(type, mediaType);
        });
        return requestBody;
    }

    private Schema toSchema(RestMethodData.ParameterInfo param, TypeMirror type, Map<String, String> parameterUsecaseValues, String parent, RestMethodData.MethodData methodData, boolean skipEnhance, Components components) {
        String qualifiedName = JavaDocUtils.getQualifiedName(param.entityClass, this.options.environment);
        if (components.getSchemas() != null && components.getSchemas().containsKey(qualifiedName)) {
            Schema refSchema = new Schema();
            refSchema.$ref("#/components/schemas/" + qualifiedName);
            return refSchema;
        }
        if (JavaDocUtils.isCollectionType(param.entityClass)) {
            return this.processArrayType(param, param.entityClass, parameterUsecaseValues, parent, methodData, skipEnhance, components);
        }
        if (JavaDocUtils.isMapType(param.entityClass)) {
            return this.processMapType(param, param.entityClass, parameterUsecaseValues, parent, methodData, skipEnhance, components);
        }
        ObjectSchema schema = new ObjectSchema();
        schema.description(this.expand(param.description));
        schema.type(JavaDocUtils.getSimpleTypeName(param.entityClass, this.options.environment));
        schema.addExtension("x-java-type", (Object)JavaDocUtils.getSimpleTypeName(param.entityClass, this.options.environment));
        schema.addExtension("x-java-type-required", (Object)param.isRequired());
        this.addConstraints((Schema)schema, param);
        this.addAllowedValues((Schema)schema, param);
        schema.deprecated(Boolean.valueOf(param.deprecated));
        if (!StringUtils.isBlank((CharSequence)param.deprecatedDescription)) {
            schema.addExtension("x-deprecated-description", (Object)this.expand(param.deprecatedDescription));
        }
        for (RestMethodData.ParameterInfo nestedParam : param.nestedParameters) {
            if (JavaDocUtils.isCollectionType(nestedParam.entityClass)) {
                schema.addProperties(nestedParam.name, (Schema)this.processArrayType(nestedParam, nestedParam.entityClass, parameterUsecaseValues, parent, methodData, skipEnhance, components));
                continue;
            }
            if (JavaDocUtils.isMapType(nestedParam.entityClass)) {
                schema.addProperties(nestedParam.name, (Schema)this.processMapType(nestedParam, nestedParam.entityClass, parameterUsecaseValues, parent, methodData, skipEnhance, components));
                continue;
            }
            if (JavaDocUtils.containedFieldNamesAreNotAvailableOrPackageExcluded(nestedParam.entityClass, this.options) || nestedParam.entityClass.equals(type)) {
                schema.addProperties(nestedParam.name, this.getSimpleSchema(nestedParam, nestedParam.entityClass));
                continue;
            }
            schema.addProperties(nestedParam.name, this.processType(nestedParam, nestedParam.entityClass, nestedParam.name, parameterUsecaseValues, this.concat(parent), methodData, skipEnhance, components));
        }
        schema.addExtension("x-java-type-expandable", (Object)(schema.getProperties() != null ? 1 : 0));
        if (!JavaDocUtils.containedFieldNamesAreNotAvailableOrPackageExcluded(param.entityClass, this.options)) {
            components.addSchemas(qualifiedName, (Schema)schema);
            Schema refSchema = new Schema();
            refSchema.$ref("#/components/schemas/" + qualifiedName);
            return refSchema;
        }
        return schema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Schema processType(RestMethodData.ParameterInfo param, TypeMirror type, String fieldName, Map<String, String> parameterUsecaseValues, String parent, RestMethodData.MethodData methodData, boolean skipEnhance, Components components) {
        ObjectSchema schema = new ObjectSchema();
        schema.type(JavaDocUtils.getSimpleTypeName(type, this.options.environment));
        schema.addExtension("x-java-type", (Object)JavaDocUtils.getSimpleTypeName(type, this.options.environment));
        if (param != null) {
            schema.addExtension("x-java-type-required", (Object)param.isRequired());
            schema.description(this.expand(param.description));
            schema.deprecated(Boolean.valueOf(param.deprecated));
            if (!StringUtils.isBlank((CharSequence)param.deprecatedDescription)) {
                schema.addExtension("x-deprecated-description", (Object)this.expand(param.deprecatedDescription));
            }
        }
        this.addConstraints((Schema)schema, param);
        this.addAllowedValues((Schema)schema, param);
        if (this.isDocumentableSimpleType(type, fieldName)) {
            schema = this.toSchema(param, type, parameterUsecaseValues, this.concat(parent, fieldName), methodData, skipEnhance, components);
        } else if (JavaDocUtils.isMapType(type)) {
            MapSchema mapSchema = this.processMapType(param, type, parameterUsecaseValues, this.concat(parent, fieldName), methodData, skipEnhance, components);
            if (fieldName != null) {
                schema.addProperties(fieldName, (Schema)mapSchema);
            } else {
                schema = mapSchema;
            }
        } else if (JavaDocUtils.isCollectionType(type)) {
            ArraySchema arraySchema = this.processArrayType(param, type, parameterUsecaseValues, this.concat(parent, fieldName), methodData, skipEnhance, components);
            if (fieldName == null) throw new IllegalArgumentException("field name is required for array type");
            schema.addProperties(fieldName, (Schema)arraySchema);
        } else if (fieldName != null) {
            schema = this.getSimpleSchema(param, type);
        }
        schema.addExtension("x-java-type-expandable", (Object)(schema.getProperties() != null || schema.getAdditionalProperties() != null ? 1 : 0));
        return schema;
    }

    private MapSchema processMapType(RestMethodData.ParameterInfo param, TypeMirror type, Map<String, String> parameterUsecaseValues, String parent, RestMethodData.MethodData methodData, boolean skipEnhance, Components components) {
        TypeMirror valueTypeMirror;
        MapSchema mapSchema = new MapSchema();
        mapSchema.addExtension("x-java-type", (Object)JavaDocUtils.getSimpleTypeName(type, this.options.environment));
        mapSchema.addExtension("x-java-type-expandable", (Object)true);
        if (param != null) {
            mapSchema.addExtension("x-java-type-required", (Object)param.isRequired());
            mapSchema.description(this.expand(param.description));
            mapSchema.deprecated(Boolean.valueOf(param.deprecated));
            if (!StringUtils.isBlank((CharSequence)param.deprecatedDescription)) {
                mapSchema.addExtension("x-deprecated-description", (Object)this.expand(param.deprecatedDescription));
            }
        }
        this.addConstraints((Schema)mapSchema, param);
        this.addAllowedValues((Schema)mapSchema, param);
        RestMethodData.ParameterInfo valueType = param != null && !param.nestedParameters.isEmpty() ? param.nestedParameters.stream().filter(p -> p.name.equals("[value]")).findFirst().get() : null;
        TypeMirror typeMirror = valueTypeMirror = valueType != null ? valueType.entityClass : ((DeclaredType)type).getTypeArguments().get(1);
        if (JavaDocUtils.isCollectionType(valueTypeMirror)) {
            mapSchema.additionalProperties((Object)this.processArrayType(valueType, valueTypeMirror, parameterUsecaseValues, parent, methodData, skipEnhance, components));
        } else if (!(valueTypeMirror == null || JavaDocUtils.asElement(valueTypeMirror, this.options.environment) == null || valueTypeMirror.getKind().isPrimitive() || JavaDocUtils.getQualifiedName(valueTypeMirror, this.options.environment).startsWith("java.lang") || JavaDocUtils.isEnum(valueTypeMirror, this.options.environment))) {
            mapSchema.additionalProperties((Object)this.processType(valueType, valueTypeMirror, null, parameterUsecaseValues, parent, methodData, skipEnhance, components));
        } else {
            Schema schema = new Schema();
            schema.addExtension("x-java-type", (Object)JavaDocUtils.getSimpleTypeName(valueTypeMirror, this.options.environment));
            schema.addExtension("x-java-type-expandable", (Object)(!JavaDocUtils.typeCantBeDocumented(valueTypeMirror, this.options) ? 1 : 0));
            schema.type(JavaDocUtils.getTypeString(valueTypeMirror, this.options.environment));
            mapSchema.additionalProperties((Object)schema);
        }
        return mapSchema;
    }

    private ArraySchema processArrayType(RestMethodData.ParameterInfo param, TypeMirror type, Map<String, String> parameterUsecaseValues, String parent, RestMethodData.MethodData methodData, boolean skipEnhance, Components components) {
        TypeMirror valueTypeMirror;
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.addExtension("x-java-type", (Object)JavaDocUtils.getSimpleTypeName(type, this.options.environment));
        if (param != null) {
            arraySchema.addExtension("x-java-type-required", (Object)param.isRequired());
            arraySchema.description(this.expand(param.description));
            arraySchema.deprecated(Boolean.valueOf(param.deprecated));
            if (!StringUtils.isBlank((CharSequence)param.deprecatedDescription)) {
                arraySchema.addExtension("x-deprecated-description", (Object)this.expand(param.deprecatedDescription));
            }
        }
        this.addConstraints((Schema)arraySchema, param);
        this.addAllowedValues((Schema)arraySchema, param);
        RestMethodData.ParameterInfo valueType = param != null && !param.nestedParameters.isEmpty() ? param.nestedParameters.get(0) : null;
        TypeMirror fallbackValue = type instanceof ArrayType ? ((ArrayType)type).getComponentType() : ((DeclaredType)type).getTypeArguments().get(0);
        TypeMirror typeMirror = valueTypeMirror = valueType != null ? valueType.entityClass : fallbackValue;
        if (JavaDocUtils.isCollectionType(valueTypeMirror)) {
            arraySchema.items((Schema)this.processArrayType(valueType, valueTypeMirror, parameterUsecaseValues, parent, methodData, skipEnhance, components));
        } else if (JavaDocUtils.isMapType(valueTypeMirror)) {
            arraySchema.items((Schema)this.processMapType(valueType, valueTypeMirror, parameterUsecaseValues, parent, methodData, skipEnhance, components));
        } else if (!(valueType == null || JavaDocUtils.asElement(valueTypeMirror, this.options.environment) == null || valueTypeMirror.getKind().isPrimitive() || JavaDocUtils.getQualifiedName(valueTypeMirror, this.options.environment).startsWith("java.lang") || JavaDocUtils.isEnum(valueTypeMirror, this.options.environment))) {
            arraySchema.items(this.toSchema(valueType, valueTypeMirror, parameterUsecaseValues, parent, methodData, skipEnhance, components));
        } else {
            arraySchema.items(this.getSimpleSchema(valueType, valueTypeMirror));
        }
        arraySchema.addExtension("x-java-type-expandable", (Object)(arraySchema.getItems() != null && valueTypeMirror.getKind() != TypeKind.BYTE ? 1 : 0));
        return arraySchema;
    }

    private Schema getSimpleSchema(RestMethodData.ParameterInfo param, TypeMirror type) {
        Schema schema = new Schema();
        schema.addExtension("x-java-type", (Object)JavaDocUtils.getSimpleTypeName(type, this.options.environment));
        schema.addExtension("x-java-type-expandable", (Object)false);
        schema.type(JavaDocUtils.getSimpleTypeName(type, this.options.environment));
        if (param != null) {
            schema.addExtension("x-java-type-required", (Object)param.isRequired());
            schema.description(this.expand(param.description));
            schema.deprecated(Boolean.valueOf(param.deprecated));
            if (!StringUtils.isBlank((CharSequence)param.deprecatedDescription)) {
                schema.addExtension("x-deprecated-description", (Object)this.expand(param.deprecatedDescription));
            }
        }
        this.addConstraints(schema, param);
        this.addAllowedValues(schema, param);
        if (JavaDocUtils.isEnum(type, this.options.environment)) {
            schema.setEnum(JavaDocUtils.getEnumValuesAsList(type, this.options.environment).stream().map(ev -> ev.getSimpleName().toString()).collect(Collectors.toList()));
        }
        return schema;
    }

    private void addAllowedValues(Schema schema, RestMethodData.ParameterInfo param) {
        if (param == null) {
            return;
        }
        if (!param.allowedValues.isEmpty()) {
            ArrayList allowedValueList = new ArrayList();
            param.allowedValues.forEach(allowedValue -> {
                HashMap<String, String> allowedValueMap = new HashMap<String, String>();
                allowedValueMap.put("value", allowedValue.value);
                allowedValueMap.put("valueHint", allowedValue.valueHint);
                allowedValueList.add(allowedValueMap);
            });
            schema.addExtension("x-allowed-values", allowedValueList);
        }
    }

    private void addConstraints(Schema schema, RestMethodData.ParameterInfo param) {
        if (param == null || param.constraints == null || param.constraints.isEmpty()) {
            return;
        }
        param.constraints.forEach((arg_0, arg_1) -> this.lambda$addConstraints$34(schema, param, arg_0, arg_1));
    }

    private Optional<BigDecimal> getBigDecimal(Map<String, String> map, String key) {
        return this.getInteger(map, key).map(BigDecimal::valueOf);
    }

    private Optional<Integer> getInteger(Map<String, String> map, String key) {
        return Optional.ofNullable(map.get(key)).map(Integer::parseInt);
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$addConstraints$34(Schema schema, RestMethodData.ParameterInfo param, String name, Map constraint) {
        var5_5 = name;
        var6_6 = -1;
        switch (var5_5.hashCode()) {
            case 873562992: {
                if (!var5_5.equals("Pattern")) break;
                var6_6 = 0;
                break;
            }
            case 2577441: {
                if (!var5_5.equals("Size")) break;
                var6_6 = 1;
                break;
            }
            case 77362: {
                if (!var5_5.equals("Min")) break;
                var6_6 = 2;
                break;
            }
            case 77124: {
                if (!var5_5.equals("Max")) break;
                var6_6 = 3;
                break;
            }
            case 812449305: {
                if (!var5_5.equals("Positive")) break;
                var6_6 = 4;
                break;
            }
            case 1441925796: {
                if (!var5_5.equals("PositiveOrZero")) break;
                var6_6 = 5;
                break;
            }
            case 985755733: {
                if (!var5_5.equals("Negative")) break;
                var6_6 = 6;
                break;
            }
            case 1033822176: {
                if (!var5_5.equals("NegativeOrZero")) break;
                var6_6 = 7;
            }
        }
        switch (var6_6) {
            case 0: {
                Optional.ofNullable((String)constraint.get("regexp")).ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, pattern(java.lang.String ), (Ljava/lang/String;)V)((Schema)schema));
                break;
            }
            case 1: {
                if (JavaDocUtils.isMapType(param.entityClass)) ** GOTO lbl48
                if (!JavaDocUtils.isCollectionType(param.entityClass)) ** GOTO lbl54
lbl48:
                // 2 sources

                this.getInteger(constraint, "min").ifPresent((Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, minItems(java.lang.Integer ), (Ljava/lang/Integer;)V)((Schema)schema));
                this.getInteger(constraint, "max").ifPresent((Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, maxItems(java.lang.Integer ), (Ljava/lang/Integer;)V)((Schema)schema));
                break;
lbl54:
                // 1 sources

                this.getInteger(constraint, "min").ifPresent((Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, minLength(java.lang.Integer ), (Ljava/lang/Integer;)V)((Schema)schema));
                this.getInteger(constraint, "max").ifPresent((Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, maxLength(java.lang.Integer ), (Ljava/lang/Integer;)V)((Schema)schema));
                break;
            }
            case 2: {
                this.getBigDecimal(constraint, "value").ifPresent((Consumer<BigDecimal>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, minimum(java.math.BigDecimal ), (Ljava/math/BigDecimal;)V)((Schema)schema));
                break;
            }
            case 3: {
                this.getBigDecimal(constraint, "value").ifPresent((Consumer<BigDecimal>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, maximum(java.math.BigDecimal ), (Ljava/math/BigDecimal;)V)((Schema)schema));
                break;
            }
            case 4: {
                schema.minimum(BigDecimal.ONE);
                break;
            }
            case 5: {
                schema.minimum(BigDecimal.ZERO);
                break;
            }
            case 6: {
                schema.maximum(new BigDecimal(-1));
                break;
            }
            case 7: {
                schema.maximum(BigDecimal.ZERO);
                break;
            }
        }
    }
}

