/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import net.oneandone.neberus.Options;
import net.oneandone.neberus.annotation.ApiUsecase;
import net.oneandone.neberus.annotation.ApiUsecases;
import net.oneandone.neberus.parse.RestClassData;
import net.oneandone.neberus.parse.RestUsecaseData;
import net.oneandone.neberus.util.JavaDocUtils;

public class UsecaseParser {
    private final Options options;

    public UsecaseParser(Options options) {
        this.options = options;
    }

    public RestUsecaseData parse(TypeElement typeElement, List<RestClassData> restClasses) {
        RestUsecaseData restUsecaseData = new RestUsecaseData();
        restUsecaseData.description = JavaDocUtils.getCommentTextFromInterfaceOrClass(typeElement, this.options.environment, false);
        this.getUsecaseAnnotations(typeElement).forEach(usecaseAnnotation -> this.addUsecase(restUsecaseData, (AnnotationMirror)usecaseAnnotation, restClasses, typeElement));
        return restUsecaseData;
    }

    private void addUsecase(RestUsecaseData restUsecaseData, AnnotationMirror usecaseAnnotation, List<RestClassData> restClasses, TypeElement typeElement) {
        String name = (String)JavaDocUtils.extractValue(usecaseAnnotation, "name");
        String description = (String)JavaDocUtils.extractValue(usecaseAnnotation, "description");
        List usecaseMethods = (List)JavaDocUtils.extractValue(usecaseAnnotation, "methods");
        int idInt = (name == null ? 1 : name.hashCode()) + (description == null ? 1 : description.hashCode()) + typeElement.getQualifiedName().toString().hashCode();
        String id = String.valueOf(idInt);
        RestUsecaseData.UsecaseData usecaseData = new RestUsecaseData.UsecaseData(id);
        restUsecaseData.usecases.add(usecaseData);
        usecaseData.name = name;
        String string = usecaseData.description = description != null ? description : "";
        if (usecaseMethods != null) {
            usecaseMethods.forEach(method -> this.addMethod(usecaseData, (AnnotationValue)method, restClasses));
        }
    }

    private void addMethod(RestUsecaseData.UsecaseData usecaseData, AnnotationValue method, List<RestClassData> restClasses) {
        AnnotationMirror methodDesc = (AnnotationMirror)method.getValue();
        String methodPath = (String)JavaDocUtils.extractValue(methodDesc, "path");
        String methodHttpMethod = (String)JavaDocUtils.extractValue(methodDesc, "httpMethod");
        String methodDescription = (String)JavaDocUtils.extractValue(methodDesc, "description");
        RestUsecaseData.UsecaseMethodData usecaseMethodData = new RestUsecaseData.UsecaseMethodData();
        usecaseData.methods.add(usecaseMethodData);
        usecaseMethodData.path = methodPath;
        usecaseMethodData.httpMethod = methodHttpMethod;
        usecaseMethodData.description = methodDescription;
        this.addLinkedMethod(restClasses, usecaseMethodData);
        this.addParameters(methodDesc, usecaseMethodData);
        this.addRequestBody(methodDesc, usecaseMethodData);
        this.addResponseBody(methodDesc, usecaseMethodData);
    }

    private void addResponseBody(AnnotationMirror methodDesc, RestUsecaseData.UsecaseMethodData usecaseMethodData) {
        List responseBody = (List)JavaDocUtils.extractValue(methodDesc, "responseBody");
        if (responseBody != null) {
            AnnotationMirror responseValueDesc = (AnnotationMirror)((AnnotationValue)responseBody.get(0)).getValue();
            String responseValueContentType = (String)JavaDocUtils.extractValue(responseValueDesc, "contentType");
            String responseValueValue = (String)JavaDocUtils.extractValue(responseValueDesc, "value");
            String responseValueValueHint = (String)JavaDocUtils.extractValue(responseValueDesc, "valueHint");
            usecaseMethodData.responseBody.put(responseValueContentType, new RestUsecaseData.UsecaseValueInfo(responseValueValue, responseValueValueHint));
        }
    }

    private void addRequestBody(AnnotationMirror methodDesc, RestUsecaseData.UsecaseMethodData usecaseMethodData) {
        List requestBody = (List)JavaDocUtils.extractValue(methodDesc, "requestBody");
        if (requestBody != null) {
            AnnotationMirror responseValueDesc = (AnnotationMirror)((AnnotationValue)requestBody.get(0)).getValue();
            String responseValueContentType = (String)JavaDocUtils.extractValue(responseValueDesc, "contentType");
            String responseValueValue = (String)JavaDocUtils.extractValue(responseValueDesc, "value");
            String responseValueValueHint = (String)JavaDocUtils.extractValue(responseValueDesc, "valueHint");
            usecaseMethodData.requestBody.put(responseValueContentType, new RestUsecaseData.UsecaseValueInfo(responseValueValue, responseValueValueHint));
        }
    }

    private void addParameters(AnnotationMirror methodDesc, RestUsecaseData.UsecaseMethodData usecaseMethodData) {
        List parameters = (List)JavaDocUtils.extractValue(methodDesc, "parameters");
        if (parameters != null) {
            parameters.forEach(parameter -> {
                AnnotationMirror parameterDesc = (AnnotationMirror)parameter.getValue();
                String paramName = (String)JavaDocUtils.extractValue(parameterDesc, "name");
                String paramValue = (String)JavaDocUtils.extractValue(parameterDesc, "value");
                String paramValueHint = (String)JavaDocUtils.extractValue(parameterDesc, "valueHint");
                usecaseMethodData.parameters.put(paramName, new RestUsecaseData.UsecaseValueInfo(paramValue, paramValueHint));
            });
        }
    }

    private void addLinkedMethod(List<RestClassData> restClasses, RestUsecaseData.UsecaseMethodData usecaseMethodData) {
        usecaseMethodData.linkedMethod = restClasses.stream().flatMap(rc -> rc.methods.stream()).filter(m -> m.methodData.path.equals(usecaseMethodData.path) && m.methodData.httpMethod.equals(usecaseMethodData.httpMethod)).findFirst().orElse(null);
    }

    private List<? extends AnnotationMirror> getUsecaseAnnotations(TypeElement classDoc) {
        Optional<TypeElement> interfaceClass = JavaDocUtils.getInterfaceClass(classDoc, this.options.environment);
        ArrayList<? extends AnnotationMirror> annotations = new ArrayList<AnnotationMirror>(classDoc.getAnnotationMirrors());
        if (interfaceClass.isPresent()) {
            annotations.addAll(interfaceClass.get().getAnnotationMirrors());
        }
        return annotations.stream().flatMap(a -> {
            if (((TypeElement)a.getAnnotationType().asElement()).getQualifiedName().toString().equals(ApiUsecases.class.getName())) {
                List values = (List)JavaDocUtils.extractValue(a, "value");
                return values.stream().map(method -> (AnnotationMirror)method.getValue());
            }
            return Stream.of(a);
        }).filter(a -> ((TypeElement)a.getAnnotationType().asElement()).getQualifiedName().toString().equals(ApiUsecase.class.getName())).collect(Collectors.toList());
    }
}

