/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.oneandone.neberus.parse.RestMethodData;

public class RestUsecaseData {
    public String description;
    public List<UsecaseData> usecases = new ArrayList<UsecaseData>();
    private static final Set<String> ALLOWED_REST_METHODS = Arrays.stream(new String[]{"GET", "PUT", "POST", "HEAD", "DELETE", "PATCH"}).collect(Collectors.toSet());

    public void validate(boolean ignoreErrors) {
        this.usecases.forEach(usecase -> usecase.methods.forEach(method -> {
            if (!ALLOWED_REST_METHODS.contains(method.httpMethod)) {
                System.err.println("Unsupported REST method in usecase: " + method.httpMethod);
                if (!ignoreErrors) {
                    throw new IllegalStateException();
                }
            }
            if (method.linkedMethod == null) {
                return;
            }
            method.parameters.keySet().forEach(paramKey -> {
                if (!this.containsParameter(method.linkedMethod.requestData.parameters, (String)paramKey)) {
                    System.err.println("Method defined in usecase <" + usecase.name + "> contains parameter <" + paramKey + "> that is not present in the linked method <" + method.linkedMethod.methodData.label + ">");
                    if (!ignoreErrors) {
                        throw new IllegalStateException();
                    }
                }
            });
            method.requestBody.keySet().forEach(contentType -> {
                if (method.linkedMethod.requestData == null || method.linkedMethod.requestData.mediaType == null || !method.linkedMethod.requestData.mediaType.contains(contentType)) {
                    System.err.println("Method defined in usecase <" + usecase.name + "> contains request body with content-type <" + contentType + "> that is not present in the linked method <" + method.linkedMethod.methodData.label + ">");
                    if (!ignoreErrors) {
                        throw new IllegalStateException();
                    }
                }
            });
            Set linkedResponseContentTypes = method.linkedMethod.responseData.stream().flatMap(r -> r.entities.stream().map(e -> e.contentType)).collect(Collectors.toSet());
            method.responseBody.keySet().forEach(contentType -> {
                if (!linkedResponseContentTypes.contains(contentType)) {
                    System.err.println("Method defined in usecase <" + usecase.name + "> contains response body with content-type <" + contentType + "> that is not present in the linked method <" + method.linkedMethod.methodData.label + ">");
                    if (!ignoreErrors) {
                        throw new IllegalStateException();
                    }
                }
            });
        }));
    }

    private boolean containsParameter(List<RestMethodData.ParameterInfo> params, String paramKey) {
        return RestUsecaseData.getParameter(params, paramKey).isPresent();
    }

    public static Optional<RestMethodData.ParameterInfo> getParameter(List<RestMethodData.ParameterInfo> params, String paramKey) {
        String[] split = paramKey.split("\\.", 2);
        String head = split[0];
        Optional<RestMethodData.ParameterInfo> param = params.stream().filter(p -> p.parameterType != RestMethodData.ParameterType.BODY && p.name.equals(paramKey) || p.name.equals(head)).findFirst();
        if (!param.isPresent()) {
            Optional<RestMethodData.ParameterInfo> body = params.stream().filter(p -> p.parameterType == RestMethodData.ParameterType.BODY).findFirst();
            if (body.isPresent()) {
                param = body.get().nestedParameters.stream().filter(p -> p.name.equals(head)).findFirst();
            }
            if (!param.isPresent()) {
                return Optional.empty();
            }
        }
        if (split.length == 1 || param.get().parameterType != RestMethodData.ParameterType.BODY) {
            return param;
        }
        String tail = split[1];
        return RestUsecaseData.getParameter(param.get().nestedParameters, tail);
    }

    public static class UsecaseValueInfo {
        public String value;
        public String valueHint;

        public UsecaseValueInfo(String value, String valueHint) {
            this.value = value;
            this.valueHint = valueHint;
        }
    }

    public static class UsecaseMethodData {
        public RestMethodData linkedMethod;
        public String path;
        public String httpMethod;
        public String description;
        public Map<String, UsecaseValueInfo> parameters = new LinkedHashMap<String, UsecaseValueInfo>();
        public Map<String, UsecaseValueInfo> requestBody = new LinkedHashMap<String, UsecaseValueInfo>();
        public Map<String, UsecaseValueInfo> responseBody = new LinkedHashMap<String, UsecaseValueInfo>();
    }

    public static class UsecaseData {
        public String id;
        public String name;
        public String description;
        public List<UsecaseMethodData> methods;

        public UsecaseData(String id) {
            this.id = id;
            this.methods = new ArrayList<UsecaseMethodData>();
        }
    }
}

