/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import net.oneandone.neberus.model.ApiStatus;
import net.oneandone.neberus.parse.RequiredStatus;
import net.oneandone.neberus.parse.RestClassData;

public class RestMethodData {
    private static final String[] NO_BODY_METHODS = new String[]{"GET", "DELETE"};
    public RestClassData containingClass;
    public MethodData methodData;
    public RequestData requestData;
    public List<ParameterInfo> responseValues;
    public List<ResponseData> responseData;

    public RestMethodData(String httpMethod) {
        this.methodData = new MethodData(httpMethod);
        this.requestData = new RequestData();
        this.responseData = new ArrayList<ResponseData>();
        this.responseValues = new ArrayList<ParameterInfo>();
    }

    public void validate(boolean ignoreErrors) {
        boolean invalid = false;
        String methodAndClass = " for method " + this.methodData.methodDoc.getEnclosingElement() + "." + this.methodData.methodDoc;
        invalid |= !this.validateResponses(methodAndClass);
        invalid |= !this.validateForCurl(methodAndClass);
        invalid |= !this.validateBodyExistenceForHttpMethod(methodAndClass);
        if ((invalid |= !this.validateContentTypeWhenBodyExists(methodAndClass)) && !ignoreErrors) {
            throw new IllegalStateException();
        }
    }

    private boolean validateResponses(String methodAndClass) {
        boolean valid = true;
        Map<ApiStatus, List<ResponseData>> groupedResponses = this.responseData.stream().collect(Collectors.groupingBy(r -> r.status));
        for (Map.Entry<ApiStatus, List<ResponseData>> entry : groupedResponses.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            valid = false;
            System.err.println("Found multiple responses for the same status <" + (Object)((Object)entry.getKey()) + "> but only one is allowed" + methodAndClass);
        }
        return valid;
    }

    private boolean validateBodyExistenceForHttpMethod(String methodAndClass) {
        boolean valid = true;
        if (Arrays.stream(NO_BODY_METHODS).anyMatch(e -> e.equals(this.methodData.httpMethod))) {
            if (this.requestData.mediaType != null && !this.requestData.mediaType.isEmpty()) {
                System.err.println("Consumes MediaType is not allowed in combination with HttpMethod " + this.methodData.httpMethod + methodAndClass);
                valid = false;
            }
            if (this.requestData.parameters.stream().anyMatch(p -> p.parameterType == ParameterType.BODY) || !this.requestData.entities.isEmpty()) {
                System.err.println("Body parameter is not allowed in combination with HttpMethod " + this.methodData.httpMethod + methodAndClass);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validateContentTypeWhenBodyExists(String methodAndClass) {
        boolean valid = true;
        if (!(!this.requestData.parameters.stream().anyMatch(p -> p.parameterType == ParameterType.BODY) && this.requestData.entities.isEmpty() || this.requestData.mediaType != null && !this.requestData.mediaType.isEmpty())) {
            System.err.println("'Consumes' mediatype is required for method with body parameter" + methodAndClass);
            valid = false;
        }
        return valid;
    }

    private boolean validateForCurl(String methodAndClass) {
        boolean valid = true;
        if (this.methodData.printCurl && this.methodData.curl == null && Arrays.stream(NO_BODY_METHODS).noneMatch(e -> e.equals(this.methodData.httpMethod)) && this.requestData.parameters.stream().anyMatch(p -> p.parameterType == ParameterType.BODY) && (this.requestData.mediaType == null || this.requestData.mediaType.isEmpty())) {
            System.err.println("Consumes MediaType is required to generate curl" + methodAndClass);
            valid = false;
        }
        return valid;
    }

    public String toString() {
        return "RestMethodData{containingClass=" + (this.containingClass != null ? this.containingClass.className : null) + ", methodData=" + this.methodData + ", requestData=" + this.requestData + ", responseValues=" + this.responseValues + ", responseData=" + this.responseData + "}";
    }

    public static class AllowedValue {
        public String value;
        public String valueHint;

        public AllowedValue(String value, String valueHint) {
            this.value = value;
            this.valueHint = valueHint;
        }

        public String toString() {
            return "AllowedValue{value='" + this.value + "', valueHint='" + this.valueHint + "'}";
        }
    }

    public static class HeaderInfo {
        public String name;
        public String description;
        public List<AllowedValue> allowedValues = new ArrayList<AllowedValue>();
        public RequiredStatus required = RequiredStatus.UNSET;
        public boolean deprecated;
        public String deprecatedDescription = "";

        public boolean isRequired() {
            return this.required != RequiredStatus.OPTIONAL;
        }

        public String toString() {
            return "HeaderInfo{name='" + this.name + "', description='" + this.description + "', allowedValues=" + this.allowedValues + ", required=" + this.required + ", deprecated=" + this.deprecated + ", deprecatedDescription=" + this.deprecatedDescription + "}";
        }
    }

    public static class Example {
        public String title;
        public String description;
        public String value;

        public String toString() {
            return "Example{title='" + this.title + "', description='" + this.description + "', value='" + this.value + "'}";
        }
    }

    public static class Entity {
        public List<Example> examples;
        public String description = "";
        public TypeMirror entityClass;
        public String contentType = "";
        public List<ParameterInfo> nestedParameters = new ArrayList<ParameterInfo>();

        public Entity() {
            this.examples = new ArrayList<Example>();
        }

        public String toString() {
            return "Entity{examples=" + this.examples + ", description='" + this.description + "', entityClass=" + this.entityClass + ", contentType='" + this.contentType + "', nestedParameters=" + this.nestedParameters + "}";
        }
    }

    public static class ResponseData {
        public ApiStatus status;
        public String description = "";
        public List<HeaderInfo> headers = new ArrayList<HeaderInfo>();
        public List<Entity> entities = new ArrayList<Entity>();

        public String toString() {
            return "ResponseData{status=" + this.status + ", description=" + this.description + ", headers=" + this.headers + "}";
        }
    }

    public static class ParameterInfo {
        public String name = "";
        public ParameterType parameterType;
        public TypeMirror entityClass;
        public TypeMirror displayClass;
        public String description = "";
        public List<AllowedValue> allowedValues = new ArrayList<AllowedValue>();
        public List<ParameterInfo> nestedParameters = new ArrayList<ParameterInfo>();
        public RequiredStatus required = RequiredStatus.UNSET;
        public boolean deprecated;
        public String deprecatedDescription = "";
        public Map<String, Map<String, String>> constraints = new HashMap<String, Map<String, String>>();

        public boolean isRequired() {
            return this.required != RequiredStatus.OPTIONAL;
        }

        public void merge(ParameterInfo other) {
            this.name = other.name.equals("") ? this.name : other.name;
            this.parameterType = other.parameterType == null ? this.parameterType : other.parameterType;
            this.description = other.description.equals("") ? this.description : other.description;
            this.allowedValues = new ArrayList<AllowedValue>(this.allowedValues);
            this.allowedValues.addAll(other.allowedValues);
            this.entityClass = other.entityClass == null ? this.entityClass : other.entityClass;
            this.displayClass = other.displayClass == null ? this.displayClass : other.displayClass;
            this.required = other.required.ordinal() > this.required.ordinal() ? other.required : this.required;
            this.constraints.putAll(other.constraints);
        }

        public String toString() {
            return "ParameterInfo{name=" + this.name + ", parameterType=" + this.parameterType + ", entityClass=" + this.entityClass + ", displayClass=" + this.displayClass + ", description=" + this.description + ", allowedValues=" + this.allowedValues + ", nestedParameters=" + this.nestedParameters + ", required=" + this.required + ", constraints=" + this.constraints + "}";
        }
    }

    public static enum ParameterType {
        PATH,
        QUERY,
        BODY,
        HEADER,
        UNSET;

    }

    public static class RequestData {
        public List<ParameterInfo> parameters = new ArrayList<ParameterInfo>();
        public List<String> mediaType;
        public List<Entity> entities = new ArrayList<Entity>();

        public String toString() {
            return "RequestData{parameters=" + this.parameters + ", mediaType=" + this.mediaType + ", entities=" + this.entities + "}";
        }
    }

    public static class MethodData {
        public ExecutableElement methodDoc;
        public String httpMethod;
        public String path = "";
        public String label = "";
        public String description = "";
        public String curl;
        public boolean printCurl = false;
        public boolean deprecated = false;
        public String deprecatedDescription;
        public List<ExecutableElement> links = new ArrayList<ExecutableElement>();

        public MethodData(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public String toString() {
            return "MethodData{methodDoc=" + this.methodDoc + ", httpMethod='" + this.httpMethod + "', path='" + this.path + "', label='" + this.label + "', description='" + this.description + "', curl='" + this.curl + "', printCurl=" + this.printCurl + ", deprecated=" + this.deprecated + ", deprecatedDescription='" + this.deprecatedDescription + "', links=" + this.links + "}";
        }
    }
}

