/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import net.oneandone.neberus.parse.RestMethodData;

public class RestClassData {
    public TypeElement classDoc;
    public String label;
    public String className;
    public String description;
    public String shortDescription;
    public List<RestMethodData> methods = new ArrayList<RestMethodData>();
    public Map<String, RestMethodData.HeaderInfo> headerDefinitions = new LinkedHashMap<String, RestMethodData.HeaderInfo>();
    public List<RestMethodData.ResponseData> commonResponseData = new LinkedList<RestMethodData.ResponseData>();

    public void validate(boolean ignoreErrors) {
        HashMap methodLabels = new HashMap();
        this.methods.forEach(method -> {
            if (methodLabels.containsKey(method.methodData.label)) {
                if (method.methodData.methodDoc == methodLabels.get(method.methodData.label)) {
                    return;
                }
                System.err.println("Method labels must be unique. Found duplicate value <" + method.methodData.label + "> in class <" + this.className + ">.\nConflicting:\n" + method.methodData.methodDoc + "\nand\n" + methodLabels.get(method.methodData.label));
                if (!ignoreErrors) {
                    throw new IllegalArgumentException();
                }
            }
            methodLabels.put(method.methodData.label, method.methodData.methodDoc);
        });
    }

    public String toString() {
        return "RestClassData{classDoc=" + this.classDoc + ", label='" + this.label + "', className='" + this.className + "', description='" + this.description + "', methods=" + this.methods + ", headerDefinitions=" + this.headerDefinitions + ", commonResponseData=" + this.commonResponseData + "}";
    }
}

