/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.parse;

import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import net.oneandone.neberus.Options;
import net.oneandone.neberus.annotation.ApiAllowedValue;
import net.oneandone.neberus.annotation.ApiAllowedValues;
import net.oneandone.neberus.annotation.ApiCurl;
import net.oneandone.neberus.annotation.ApiDescription;
import net.oneandone.neberus.annotation.ApiIgnore;
import net.oneandone.neberus.annotation.ApiLabel;
import net.oneandone.neberus.annotation.ApiOptional;
import net.oneandone.neberus.annotation.ApiParameter;
import net.oneandone.neberus.annotation.ApiParameters;
import net.oneandone.neberus.annotation.ApiRequestEntities;
import net.oneandone.neberus.annotation.ApiRequestEntity;
import net.oneandone.neberus.annotation.ApiRequired;
import net.oneandone.neberus.annotation.ApiResponse;
import net.oneandone.neberus.annotation.ApiResponses;
import net.oneandone.neberus.annotation.ApiType;
import net.oneandone.neberus.model.ApiStatus;
import net.oneandone.neberus.model.FormParameters;
import net.oneandone.neberus.parse.RequiredStatus;
import net.oneandone.neberus.parse.RestMethodData;
import net.oneandone.neberus.util.JavaDocUtils;

public abstract class MethodParser {
    protected final Options options;
    public static final String VALUE = "value";
    public static final String VALUE_HINT = "valueHint";
    public static final String DETAIL = "detail";
    public static final String TYPE = "type";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";

    public MethodParser(Options options) {
        this.options = options;
    }

    public RestMethodData parseMethod(ExecutableElement method, String httpMethod) {
        try {
            System.out.println(" - " + method);
            RestMethodData data = new RestMethodData(httpMethod);
            this.addMethodData(method, data);
            this.addRequestData(method, data);
            this.addResponseData(method, data);
            data.validate(this.options.ignoreErrors);
            return data;
        }
        catch (Exception e) {
            System.out.println("Error parsing method " + method);
            throw e;
        }
    }

    protected void addRequestData(ExecutableElement method, RestMethodData data) {
        this.addMediaType(method, data);
        this.addParameters(method, data);
        this.addCustomParameters(method, data);
        this.sortByTypeAndOptionalAndDeprecatedState(data.requestData.parameters);
        this.addCustomRequestEntities(method, data);
    }

    protected boolean skipParameter(ExecutableElement methodDoc, VariableElement parameter, int index) {
        return JavaDocUtils.hasAnnotation(methodDoc, parameter, ApiIgnore.class, index, this.options.environment);
    }

    protected void addParameters(ExecutableElement method, RestMethodData data) {
        List<? extends VariableElement> parameters = method.getParameters();
        Map<String, ParamTree> paramTags = JavaDocUtils.getParamTags(method, this.options.environment);
        RestMethodData.ParameterInfo formParamContainer = null;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            if (this.skipParameter(method, parameter, i)) continue;
            RestMethodData.ParameterInfo parameterInfo = this.parseParameter(method, parameter, paramTags, i);
            if (this.getFormParam(method, parameters.get(i), i) != null) {
                if (formParamContainer == null) {
                    formParamContainer = new RestMethodData.ParameterInfo();
                    formParamContainer.entityClass = this.options.environment.getElementUtils().getTypeElement(FormParameters.class.getCanonicalName()).asType();
                    formParamContainer.parameterType = RestMethodData.ParameterType.BODY;
                    formParamContainer.name = "Form";
                    data.requestData.parameters.add(formParamContainer);
                }
                if (parameterInfo.displayClass != null) {
                    parameterInfo.entityClass = parameterInfo.displayClass;
                }
                formParamContainer.nestedParameters.add(parameterInfo);
                continue;
            }
            data.requestData.parameters.add(parameterInfo);
        }
        List<RestMethodData.ParameterInfo> bodyParams = data.requestData.parameters.stream().filter(p -> p.parameterType == RestMethodData.ParameterType.BODY).collect(Collectors.toList());
        bodyParams.forEach(p -> {
            data.requestData.parameters.remove(p);
            RestMethodData.Entity entity = new RestMethodData.Entity();
            entity.entityClass = p.entityClass;
            entity.description = p.description;
            entity.nestedParameters = p.nestedParameters;
            data.requestData.entities.add(entity);
        });
        this.sortByTypeAndOptionalAndDeprecatedState(data.requestData.parameters);
    }

    protected void addCustomRequestEntities(ExecutableElement method, RestMethodData data) {
        List entityDefinitions = (List)JavaDocUtils.getAnnotationValue(method, ApiRequestEntities.class, VALUE, this.options.environment);
        if (entityDefinitions != null) {
            entityDefinitions.forEach(repsonse -> this.addCustomRequestEntity((AnnotationMirror)repsonse.getValue(), data));
        } else {
            List<? extends AnnotationMirror> singleEntityDefinition = JavaDocUtils.getAnnotationDesc(method, ApiRequestEntity.class, this.options.environment);
            singleEntityDefinition.forEach(annotationMirror -> this.addCustomRequestEntity((AnnotationMirror)annotationMirror, data));
        }
    }

    private void addCustomRequestEntity(AnnotationMirror entityDefinition, RestMethodData data) {
        TypeElement element;
        RestMethodData.Entity entity = new RestMethodData.Entity();
        entity.contentType = (String)JavaDocUtils.extractValue(entityDefinition, "contentType");
        entity.description = (String)JavaDocUtils.extractValue(entityDefinition, DESCRIPTION);
        entity.entityClass = (TypeMirror)JavaDocUtils.extractValue(entityDefinition, "entityClass");
        if (entity.contentType == null) {
            String string = entity.contentType = data.requestData.mediaType == null ? null : data.requestData.mediaType.get(0);
        }
        if (entity.description == null && (element = (TypeElement)this.options.environment.getTypeUtils().asElement(entity.entityClass)) != null) {
            entity.description = JavaDocUtils.getCommentTextFromInterfaceOrClass(element, this.options.environment, false);
        }
        List examples = (List)JavaDocUtils.extractValue(entityDefinition, "examples");
        entity.examples.addAll(this.getExamples(examples));
        this.addNestedParameters(entity.entityClass, entity.nestedParameters, new ArrayList<TypeMirror>());
        data.requestData.entities.add(entity);
    }

    protected abstract String getPathParam(ExecutableElement var1, VariableElement var2, int var3);

    protected abstract String getQueryParam(ExecutableElement var1, VariableElement var2, int var3);

    protected abstract String getHeaderParam(ExecutableElement var1, VariableElement var2, int var3);

    protected abstract String getFormParam(ExecutableElement var1, VariableElement var2, int var3);

    protected RestMethodData.ParameterInfo parseParameter(ExecutableElement method, VariableElement parameter, Map<String, ParamTree> paramTags, int index) {
        try {
            RestMethodData.ParameterInfo parameterInfo = this.getBasicParameterInfo(method, parameter, index);
            ParamTree paramTag = JavaDocUtils.getParamTag(method, index, paramTags, this.options.environment);
            if (paramTag != null) {
                parameterInfo.description = JavaDocUtils.getParamTreeComment(paramTag);
                List<? extends DocTree> paramBlockTags = JavaDocUtils.getBlockTags(parameter, this.options.environment);
                this.getAllowedValuesFromSeeTag(method, paramBlockTags).ifPresent(av -> {
                    parameterInfo.allowedValues = av;
                });
                this.getAllowedValuesFromLinkTag(method, paramTag.getDescription()).ifPresent(av -> {
                    parameterInfo.allowedValues = av;
                });
                this.getConstraintsFromSeeTag(method, paramBlockTags).ifPresent(av -> {
                    parameterInfo.constraints = av;
                });
                this.getConstraintsFromLinkTag(method, paramTag.getDescription()).ifPresent(av -> {
                    parameterInfo.constraints = av;
                });
            }
            this.addAllowedValuesFromAnnotation(method, parameter, index, parameterInfo);
            return parameterInfo;
        }
        catch (Exception e) {
            System.out.println("Error parsing parameter " + parameter);
            throw e;
        }
    }

    protected RequiredStatus getRequiredStatus(ExecutableElement method, VariableElement parameter, int index) {
        if (JavaDocUtils.hasAnnotation(method, parameter, ApiRequired.class, index, this.options.environment)) {
            return RequiredStatus.REQUIRED;
        }
        if (JavaDocUtils.hasAnnotation(method, parameter, ApiOptional.class, index, this.options.environment)) {
            return RequiredStatus.OPTIONAL;
        }
        return RequiredStatus.UNSET;
    }

    private RequiredStatus getRequiredStatus(ExecutableElement getter) {
        if (JavaDocUtils.hasAnnotation(getter, ApiRequired.class, this.options.environment)) {
            return RequiredStatus.REQUIRED;
        }
        if (JavaDocUtils.hasAnnotation(getter, ApiOptional.class, this.options.environment)) {
            return RequiredStatus.OPTIONAL;
        }
        return RequiredStatus.UNSET;
    }

    private RequiredStatus getRequiredStatus(VariableElement param) {
        if (JavaDocUtils.hasDirectAnnotation(param, ApiRequired.class)) {
            return RequiredStatus.REQUIRED;
        }
        if (JavaDocUtils.hasDirectAnnotation(param, ApiOptional.class)) {
            return RequiredStatus.OPTIONAL;
        }
        return RequiredStatus.UNSET;
    }

    private RestMethodData.ParameterInfo getBasicParameterInfo(ExecutableElement method, VariableElement parameter, int index) {
        RestMethodData.ParameterInfo parameterInfo = new RestMethodData.ParameterInfo();
        String pathParam = this.getPathParam(method, parameter, index);
        String queryParam = this.getQueryParam(method, parameter, index);
        String headerParam = this.getHeaderParam(method, parameter, index);
        parameterInfo.entityClass = parameter.asType();
        parameterInfo.displayClass = (TypeMirror)JavaDocUtils.getAnnotationValue(method, parameter, ApiType.class, VALUE, index, this.options.environment);
        parameterInfo.constraints = this.getConstraints(JavaDocUtils.getAnnotations(method, parameter, index, this.options.environment));
        parameterInfo.required = this.getRequiredStatus(method, parameter, index);
        parameterInfo.deprecated = JavaDocUtils.hasAnnotation(method, parameter, Deprecated.class, index, this.options.environment);
        if (pathParam != null) {
            parameterInfo.name = pathParam;
            parameterInfo.parameterType = RestMethodData.ParameterType.PATH;
        } else if (queryParam != null) {
            parameterInfo.name = queryParam;
            parameterInfo.parameterType = RestMethodData.ParameterType.QUERY;
        } else if (headerParam != null) {
            parameterInfo.name = headerParam;
            parameterInfo.parameterType = RestMethodData.ParameterType.HEADER;
        } else {
            parameterInfo.name = parameter.getSimpleName().toString();
            parameterInfo.parameterType = RestMethodData.ParameterType.BODY;
            this.addNestedParameters(parameterInfo.displayClass != null ? parameterInfo.displayClass : parameterInfo.entityClass, parameterInfo.nestedParameters, new ArrayList<TypeMirror>());
            this.sortByTypeAndOptionalAndDeprecatedState(parameterInfo.nestedParameters);
        }
        return parameterInfo;
    }

    protected void addNestedMap(TypeMirror type, List<RestMethodData.ParameterInfo> parentList) {
        List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
        RestMethodData.ParameterInfo nestedInfoKey = new RestMethodData.ParameterInfo();
        parentList.add(nestedInfoKey);
        nestedInfoKey.name = "[key]";
        nestedInfoKey.parameterType = RestMethodData.ParameterType.BODY;
        nestedInfoKey.entityClass = typeArguments.get(0);
        if (!JavaDocUtils.typeCantBeDocumented(typeArguments.get(0), this.options)) {
            TypeElement typeElement = (TypeElement)this.options.environment.getTypeUtils().asElement(typeArguments.get(0));
            nestedInfoKey.description = JavaDocUtils.getCommentTextFromInterfaceOrClass(typeElement, this.options.environment, false);
            this.addNestedParameters(typeArguments.get(0), nestedInfoKey.nestedParameters, new ArrayList<TypeMirror>());
        }
        RestMethodData.ParameterInfo nestedInfoValue = new RestMethodData.ParameterInfo();
        parentList.add(nestedInfoValue);
        nestedInfoValue.name = "[value]";
        nestedInfoValue.entityClass = typeArguments.get(1);
        if (!JavaDocUtils.typeCantBeDocumented(typeArguments.get(1), this.options)) {
            TypeElement typeElement = (TypeElement)this.options.environment.getTypeUtils().asElement(typeArguments.get(1));
            nestedInfoValue.description = JavaDocUtils.getCommentTextFromInterfaceOrClass(typeElement, this.options.environment, false);
            this.addNestedParameters(typeArguments.get(1), nestedInfoValue.nestedParameters, new ArrayList<TypeMirror>());
        }
    }

    protected void addNestedArray(TypeMirror type, List<RestMethodData.ParameterInfo> parentList) {
        TypeMirror typeArgument = type instanceof ArrayType ? ((ArrayType)type).getComponentType() : ((DeclaredType)type).getTypeArguments().get(0);
        RestMethodData.ParameterInfo nestedInfo = new RestMethodData.ParameterInfo();
        nestedInfo.entityClass = typeArgument;
        parentList.add(nestedInfo);
        nestedInfo.name = "[element]";
        if (!JavaDocUtils.typeCantBeDocumented(typeArgument, this.options)) {
            TypeElement typeElement = (TypeElement)this.options.environment.getTypeUtils().asElement(typeArgument);
            nestedInfo.description = JavaDocUtils.getCommentTextFromInterfaceOrClass(typeElement, this.options.environment, false);
            this.addNestedParameters(typeArgument, nestedInfo.nestedParameters, new ArrayList<TypeMirror>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNestedParameters(TypeMirror type, List<RestMethodData.ParameterInfo> parentList, List<TypeMirror> parentTypes) {
        try {
            parentTypes.add(type);
            if (JavaDocUtils.isCollectionType(type)) {
                this.addNestedArray(type, parentList);
            } else if (JavaDocUtils.isMapType(type)) {
                this.addNestedMap(type, parentList);
            } else {
                if (JavaDocUtils.typeCantBeDocumented(type, this.options)) {
                    return;
                }
                List<VariableElement> fields = JavaDocUtils.getVisibleFields(type, this.options.environment);
                fields.forEach(field -> this.addNestedField(type, parentList, parentTypes, (VariableElement)field));
                if (!fields.isEmpty()) {
                    return;
                }
                List<ExecutableElement> getters = JavaDocUtils.getVisibleGetters(type, this.options.environment);
                getters.forEach(getter -> this.addNestedGetter(type, parentList, parentTypes, (ExecutableElement)getter));
                if (!getters.isEmpty()) {
                    return;
                }
                ExecutableElement chosenCtor = this.getCtorDoc(type);
                if (chosenCtor == null) {
                    return;
                }
                Map<String, ParamTree> paramTags = JavaDocUtils.getParamTags(chosenCtor, this.options.environment);
                for (VariableElement param : JavaDocUtils.getVisibleCtorParameters(chosenCtor)) {
                    this.addNestedCtorParam(type, parentList, parentTypes, paramTags, param);
                }
            }
        }
        finally {
            this.sortByTypeAndOptionalAndDeprecatedState(parentList);
        }
    }

    private void sortByTypeAndOptionalAndDeprecatedState(List<RestMethodData.ParameterInfo> parentList) {
        parentList.sort((a, b) -> {
            int compareType;
            if (a.parameterType != null && b.parameterType != null && (compareType = a.parameterType.compareTo(b.parameterType)) != 0) {
                return compareType;
            }
            int compareOpt = Integer.compare(a.required.ordinal(), b.required.ordinal());
            if (compareOpt != 0) {
                return compareOpt;
            }
            return Boolean.compare(a.deprecated, b.deprecated);
        });
    }

    private ExecutableElement getCtorDoc(TypeMirror type) {
        ExecutableElement chosenCtor = null;
        for (ExecutableElement ctor : JavaDocUtils.getConstructors(type, this.options.environment)) {
            if (chosenCtor == null) {
                chosenCtor = ctor;
                continue;
            }
            if (ctor.getParameters().size() <= chosenCtor.getParameters().size()) continue;
            chosenCtor = ctor;
        }
        return chosenCtor;
    }

    private void addNestedCtorParam(TypeMirror type, List<RestMethodData.ParameterInfo> parentList, List<TypeMirror> parentTypes, Map<String, ParamTree> paramTags, VariableElement param) {
        RestMethodData.ParameterInfo nestedInfo = new RestMethodData.ParameterInfo();
        ParamTree paramTag = paramTags.get(param.getSimpleName().toString());
        nestedInfo.name = JavaDocUtils.getPublicName(param);
        nestedInfo.allowedValues = this.getAllowedValuesFromType(param.asType());
        nestedInfo.entityClass = param.asType();
        nestedInfo.constraints = this.getConstraints(param.getAnnotationMirrors());
        nestedInfo.required = this.getRequiredStatus(param);
        nestedInfo.deprecated = JavaDocUtils.hasDirectAnnotation(param, Deprecated.class);
        this.addAllowedValuesFromAnnotation(param, nestedInfo);
        if (paramTag != null) {
            nestedInfo.description = JavaDocUtils.getParamTreeComment(paramTag);
            List<? extends DocTree> paramBlockTags = JavaDocUtils.getBlockTags(param, this.options.environment);
            this.getAllowedValuesFromSeeTag(param, paramBlockTags).ifPresent(av -> {
                nestedInfo.allowedValues = av;
            });
            this.getConstraintsFromLinkTag(param, paramBlockTags).ifPresent(av -> {
                nestedInfo.constraints = av;
            });
        }
        parentList.add(nestedInfo);
        if (!type.equals(param.asType()) && !parentTypes.contains(param.asType())) {
            this.addNestedParameters(param.asType(), nestedInfo.nestedParameters, parentTypes);
        }
    }

    private void addNestedGetter(TypeMirror type, List<RestMethodData.ParameterInfo> parentList, List<TypeMirror> parentTypes, ExecutableElement getter) {
        RestMethodData.ParameterInfo nestedInfo = new RestMethodData.ParameterInfo();
        nestedInfo.name = JavaDocUtils.getNameFromGetter(getter, this.options.environment);
        List<? extends DocTree> getterBlockTags = JavaDocUtils.getBlockTags(getter, this.options.environment);
        List<? extends DocTree> getterInlineTags = JavaDocUtils.getInlineTags(getter, this.options.environment);
        Optional<DocTree> returnTag = getterBlockTags.stream().filter(tag -> ReturnTree.class.isAssignableFrom(tag.getClass())).findFirst();
        nestedInfo.description = returnTag.isPresent() ? JavaDocUtils.getCommentTextWithoutInlineTags(((ReturnTree)returnTag.get()).getDescription()) : JavaDocUtils.getCommentTextFromInterfaceOrClass(getter, this.options.environment, true);
        nestedInfo.allowedValues = this.getAllowedValuesFromType(getter.getReturnType());
        nestedInfo.entityClass = getter.getReturnType();
        nestedInfo.constraints = this.getConstraints(getter.getAnnotationMirrors());
        nestedInfo.required = this.getRequiredStatus(getter);
        nestedInfo.deprecated = JavaDocUtils.hasAnnotation(getter, Deprecated.class, this.options.environment);
        getterBlockTags.stream().filter(tag -> tag instanceof DeprecatedTree).map(tag -> (DeprecatedTree)tag).findFirst().ifPresent(deprecatedTree -> {
            nestedInfo.deprecatedDescription = deprecatedTree.getBody().stream().map(Object::toString).collect(Collectors.joining());
        });
        this.getAllowedValuesFromSeeTag(getter, getterBlockTags).ifPresent(av -> {
            nestedInfo.allowedValues = av;
        });
        this.getAllowedValuesFromLinkTag(getter, getterInlineTags).ifPresent(av -> {
            nestedInfo.allowedValues = av;
        });
        this.getConstraintsFromSeeTag(getter, getterBlockTags).ifPresent(av -> {
            nestedInfo.constraints = av;
        });
        this.getConstraintsFromLinkTag(getter, getterInlineTags).ifPresent(av -> {
            nestedInfo.constraints = av;
        });
        if (nestedInfo.allowedValues.isEmpty()) {
            this.addAllowedValuesFromAnnotation(getter, nestedInfo);
        }
        parentList.add(nestedInfo);
        if (!type.equals(getter.getReturnType()) && !parentTypes.contains(getter.getReturnType())) {
            this.addNestedParameters(getter.getReturnType(), nestedInfo.nestedParameters, parentTypes);
        }
    }

    private void addNestedField(TypeMirror type, List<RestMethodData.ParameterInfo> parentList, List<TypeMirror> parentTypes, VariableElement field) {
        RestMethodData.ParameterInfo nestedInfo = new RestMethodData.ParameterInfo();
        nestedInfo.parameterType = RestMethodData.ParameterType.BODY;
        nestedInfo.name = JavaDocUtils.getPublicName(field);
        nestedInfo.description = JavaDocUtils.getCommentText(field, this.options.environment, true);
        nestedInfo.allowedValues = this.getAllowedValuesFromType(field.asType());
        nestedInfo.entityClass = field.asType();
        nestedInfo.constraints = this.getConstraints(field.getAnnotationMirrors());
        nestedInfo.required = this.getRequiredStatus(field);
        nestedInfo.deprecated = JavaDocUtils.hasDirectAnnotation(field, Deprecated.class);
        JavaDocUtils.getBlockTags(field, this.options.environment).stream().filter(tag -> tag instanceof DeprecatedTree).map(tag -> (DeprecatedTree)tag).findFirst().ifPresent(deprecatedTree -> {
            nestedInfo.deprecatedDescription = deprecatedTree.getBody().stream().map(Object::toString).collect(Collectors.joining());
        });
        List<? extends DocTree> fieldBlockTags = JavaDocUtils.getBlockTags(field, this.options.environment);
        List<? extends DocTree> fieldInlineTags = JavaDocUtils.getInlineTags(field, this.options.environment);
        this.getAllowedValuesFromSeeTag(field, fieldBlockTags).ifPresent(av -> {
            nestedInfo.allowedValues = av;
        });
        this.getAllowedValuesFromLinkTag(field, fieldInlineTags).ifPresent(av -> {
            nestedInfo.allowedValues = av;
        });
        this.getConstraintsFromSeeTag(field, fieldBlockTags).ifPresent(av -> {
            nestedInfo.constraints = av;
        });
        this.getConstraintsFromLinkTag(field, fieldInlineTags).ifPresent(av -> {
            nestedInfo.constraints = av;
        });
        if (nestedInfo.allowedValues.isEmpty()) {
            this.addAllowedValuesFromAnnotation(field, nestedInfo);
        }
        parentList.add(nestedInfo);
        if (!type.equals(field.asType()) && !parentTypes.contains(field.asType())) {
            this.addNestedParameters(field.asType(), nestedInfo.nestedParameters, parentTypes);
        }
    }

    private void addAllowedValuesFromAnnotation(Element memberDoc, RestMethodData.ParameterInfo nestedInfo) {
        List parameters = (List)JavaDocUtils.getDirectAnnotationValue(memberDoc, ApiAllowedValues.class, VALUE);
        if (parameters != null) {
            parameters.forEach(repsonse -> this.addAllowedValuesFromAnnotation((AnnotationMirror)repsonse.getValue(), nestedInfo.allowedValues));
        } else {
            List<? extends AnnotationMirror> singleParameter = JavaDocUtils.getAnnotationDesc(memberDoc, ApiAllowedValue.class);
            singleParameter.forEach(annotationMirror -> this.addAllowedValuesFromAnnotation((AnnotationMirror)annotationMirror, nestedInfo.allowedValues));
        }
    }

    private void addAllowedValuesFromAnnotation(ExecutableElement memberDoc, VariableElement param, int index, RestMethodData.ParameterInfo nestedInfo) {
        List parameters = (List)JavaDocUtils.getDirectAnnotationValue(param, ApiAllowedValues.class, VALUE);
        if (parameters != null) {
            parameters.forEach(repsonse -> this.addAllowedValuesFromAnnotation((AnnotationMirror)repsonse.getValue(), nestedInfo.allowedValues));
        } else {
            List<? extends AnnotationMirror> singleParameter = JavaDocUtils.getAnnotationDesc(memberDoc, param, ApiAllowedValue.class, index, this.options.environment);
            singleParameter.forEach(annotationMirror -> this.addAllowedValuesFromAnnotation((AnnotationMirror)annotationMirror, nestedInfo.allowedValues));
        }
    }

    private void addAllowedValuesFromAnnotation(AnnotationMirror annotationMirror, List<RestMethodData.AllowedValue> allowedValues) {
        TypeMirror enumClass = (TypeMirror)JavaDocUtils.extractValue(annotationMirror, "enumValues");
        if (enumClass != null && !enumClass.toString().equals(Enum.class.getCanonicalName())) {
            allowedValues.addAll(this.getAllowedValuesFromType(enumClass));
        } else {
            String value = (String)JavaDocUtils.extractValue(annotationMirror, VALUE);
            String valueHint = (String)JavaDocUtils.extractValue(annotationMirror, VALUE_HINT);
            RestMethodData.AllowedValue allowedValue = new RestMethodData.AllowedValue(value, valueHint);
            allowedValues.add(allowedValue);
        }
    }

    protected List<RestMethodData.AllowedValue> getAllowedValuesFromType(TypeMirror type) {
        if (!JavaDocUtils.isEnum(type, this.options.environment)) {
            return new ArrayList<RestMethodData.AllowedValue>();
        }
        return JavaDocUtils.getEnumValuesAsList(type, this.options.environment).stream().map(enumValue -> {
            String valueHint = JavaDocUtils.getCommentText(enumValue, this.options.environment, true);
            return new RestMethodData.AllowedValue(enumValue.getSimpleName().toString(), valueHint);
        }).collect(Collectors.toList());
    }

    protected Optional<List<RestMethodData.AllowedValue>> getAllowedValuesFromLinkTag(Element e, List<? extends DocTree> tags) {
        return tags.stream().filter(tag -> LinkTree.class.isAssignableFrom(tag.getClass())).map(tag -> (LinkTree)tag).findFirst().map(linkTree -> {
            Element referencedElement = JavaDocUtils.getReferencedElement(e, linkTree.getReference(), this.options.environment);
            if (referencedElement != null && TypeElement.class.isAssignableFrom(referencedElement.getClass())) {
                return this.getAllowedValuesFromType(referencedElement.asType());
            }
            return null;
        });
    }

    protected Optional<List<RestMethodData.AllowedValue>> getAllowedValuesFromSeeTag(Element e, List<? extends DocTree> tags) {
        return tags.stream().filter(tag -> SeeTree.class.isAssignableFrom(tag.getClass())).map(tag -> (SeeTree)tag).findFirst().map(seeTree -> {
            ArrayList values = new ArrayList();
            seeTree.getReference().forEach(referenced -> {
                Element referencedElement = JavaDocUtils.getReferencedElement(e, referenced, this.options.environment);
                if (referencedElement != null && TypeElement.class.isAssignableFrom(referencedElement.getClass())) {
                    values.addAll(this.getAllowedValuesFromType(referencedElement.asType()));
                }
            });
            return values;
        });
    }

    protected Optional<Map<String, Map<String, String>>> getConstraintsFromLinkTag(Element e, List<? extends DocTree> tags) {
        return tags.stream().filter(tag -> tag instanceof LinkTree).map(tag -> (LinkTree)tag).findFirst().map(linkTree -> {
            Element referencedElement = JavaDocUtils.getReferencedElement(e, linkTree.getReference(), this.options.environment);
            if (referencedElement != null) {
                return this.getConstraints(referencedElement.getAnnotationMirrors());
            }
            return null;
        });
    }

    protected Optional<Map<String, Map<String, String>>> getConstraintsFromSeeTag(Element e, List<? extends DocTree> tags) {
        return tags.stream().filter(tag -> SeeTree.class.isAssignableFrom(tag.getClass())).map(tag -> (SeeTree)tag).findFirst().map(seeTree -> {
            HashMap values = new HashMap();
            seeTree.getReference().forEach(referenced -> {
                Element referencedElement = JavaDocUtils.getReferencedElement(e, referenced, this.options.environment);
                if (referencedElement != null) {
                    values.putAll(this.getConstraints(referencedElement.getAnnotationMirrors()));
                }
            });
            return values;
        });
    }

    protected void addCustomParameters(ExecutableElement method, RestMethodData data) {
        List parameters = (List)JavaDocUtils.getAnnotationValue(method, ApiParameters.class, VALUE, this.options.environment);
        if (parameters != null) {
            parameters.forEach(repsonse -> this.addCustomParameter((AnnotationMirror)repsonse.getValue(), data));
        } else {
            List<? extends AnnotationMirror> singleParameter = JavaDocUtils.getAnnotationDesc(method, ApiParameter.class, this.options.environment);
            singleParameter.forEach(annotationMirror -> this.addCustomParameter((AnnotationMirror)annotationMirror, data));
        }
    }

    protected void addCustomParameter(AnnotationMirror parameterDesc, RestMethodData data) {
        RestMethodData.ParameterInfo parameterInfo = this.parseCustomParameterInfo(parameterDesc);
        List<RestMethodData.ParameterInfo> parameters = data.requestData.parameters;
        this.addParameterInfo(parameters, parameterInfo);
    }

    protected void addParameterInfo(List<RestMethodData.ParameterInfo> parameters, RestMethodData.ParameterInfo parameterInfo) {
        if (parameterInfo.entityClass == null) {
            parameterInfo.entityClass = this.options.environment.getElementUtils().getTypeElement("java.lang.String").asType();
        }
        parameters.add(parameterInfo);
    }

    protected RestMethodData.ParameterInfo parseCustomParameterInfo(AnnotationMirror parameterDesc) {
        Boolean deprecated;
        VariableElement type;
        String description;
        RestMethodData.ParameterInfo parameterInfo = new RestMethodData.ParameterInfo();
        String name = (String)JavaDocUtils.extractValue(parameterDesc, "name");
        if (name != null) {
            parameterInfo.name = name;
        }
        if ((description = (String)JavaDocUtils.extractValue(parameterDesc, DESCRIPTION)) != null) {
            parameterInfo.description = description;
        }
        parameterInfo.parameterType = (type = (VariableElement)JavaDocUtils.extractValue(parameterDesc, TYPE)) != null ? RestMethodData.ParameterType.valueOf(type.getSimpleName().toString()) : RestMethodData.ParameterType.UNSET;
        List allowedValues = (List)JavaDocUtils.extractValue(parameterDesc, "allowedValues");
        if (allowedValues != null) {
            for (AnnotationValue allowedValue : allowedValues) {
                AnnotationMirror allowedValueDesc = (AnnotationMirror)allowedValue.getValue();
                this.addAllowedValuesFromAnnotation(allowedValueDesc, parameterInfo.allowedValues);
            }
        }
        parameterInfo.entityClass = (TypeMirror)JavaDocUtils.extractValue(parameterDesc, "entityClass");
        Boolean optional = (Boolean)JavaDocUtils.extractValue(parameterDesc, "optional");
        if (optional != null) {
            parameterInfo.required = optional != false ? RequiredStatus.OPTIONAL : RequiredStatus.REQUIRED;
        }
        parameterInfo.deprecated = (deprecated = (Boolean)JavaDocUtils.extractValue(parameterDesc, "deprecated")) != null && deprecated != false;
        parameterInfo.deprecatedDescription = (String)JavaDocUtils.extractValue(parameterDesc, "deprecatedDescription");
        return parameterInfo;
    }

    private Map<String, Map<String, String>> getConstraints(List<? extends AnnotationMirror> annotations) {
        HashMap<String, Map<String, String>> constraints = new HashMap<String, Map<String, String>>();
        annotations.stream().filter(this::isValidationConstraint).forEach(annotation -> {
            String key = annotation.getAnnotationType().asElement().getSimpleName().toString();
            HashMap params = new HashMap();
            annotation.getAnnotationType().asElement().getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).forEach(element -> {
                if (element.getDefaultValue() == null) {
                    return;
                }
                Object defaultValue = element.getDefaultValue().getValue();
                if (defaultValue instanceof Number) {
                    params.put(element.getSimpleName().toString(), defaultValue.toString());
                }
            });
            annotation.getElementValues().forEach((element, value) -> params.put(element.getSimpleName().toString(), value.getValue().toString()));
            constraints.put(key, params);
        });
        return constraints;
    }

    private boolean isValidationConstraint(AnnotationMirror annotation) {
        if (annotation.getAnnotationType().asElement() == null) {
            return false;
        }
        return annotation.getAnnotationType().asElement().getAnnotationMirrors().stream().anyMatch(a -> {
            String packageName = this.options.environment.getElementUtils().getPackageOf(a.getAnnotationType().asElement()).getQualifiedName().toString();
            String simpleName = a.getAnnotationType().asElement().getSimpleName().toString();
            return packageName.equals("javax.validation") && simpleName.equals("Constraint");
        });
    }

    protected void addMethodData(ExecutableElement method, RestMethodData data) {
        data.methodData.methodDoc = method;
        this.addPath(method, data);
        this.addLabel(method, data);
        this.addDescription(method, data);
        this.addCurl(method, data);
        this.addDeprecated(method, data);
    }

    protected abstract String getRootPath(TypeElement var1);

    protected abstract String getPath(ExecutableElement var1);

    protected void addPath(ExecutableElement method, RestMethodData data) {
        String path;
        String rootPath = this.getRootPath((TypeElement)method.getEnclosingElement());
        if (rootPath != null) {
            data.methodData.path = rootPath;
        }
        if ((path = this.getPath(method)) != null) {
            String divider;
            String string = divider = data.methodData.path.endsWith("/") || path.startsWith("/") ? "" : "/";
            if (data.methodData.path.endsWith("/") && path.startsWith("/")) {
                path = path.replaceFirst("/", "");
            }
            data.methodData.path = data.methodData.path + divider + path;
        }
    }

    protected void addDescription(ExecutableElement method, RestMethodData data) {
        String description = (String)JavaDocUtils.getAnnotationValue(method, ApiDescription.class, VALUE, this.options.environment);
        if (description != null) {
            data.methodData.description = description;
        } else {
            DocCommentTree docCommentTree = JavaDocUtils.getDocCommentTreeFromInterfaceOrClass(method, this.options.environment);
            if (docCommentTree != null) {
                data.methodData.description = docCommentTree.getFullBody().stream().filter(tag -> tag instanceof TextTree || tag instanceof StartElementTree || tag instanceof EndElementTree || tag instanceof LinkTree).map(Object::toString).collect(Collectors.joining());
                docCommentTree.getFullBody().stream().filter(LinkTree.class::isInstance).map(LinkTree.class::cast).forEach(linkTree -> {
                    Element referencedMember = JavaDocUtils.getReferencedElement(method, linkTree.getReference(), this.options.environment);
                    if (referencedMember instanceof ExecutableElement) {
                        data.methodData.links.add((ExecutableElement)referencedMember);
                    }
                });
            } else {
                data.methodData.description = JavaDocUtils.getCommentTextFromInterfaceOrClass(method, this.options.environment, true);
            }
        }
    }

    protected void addCurl(ExecutableElement methodDoc, RestMethodData data) {
        if (!JavaDocUtils.getAnnotationDesc(methodDoc, ApiCurl.class, this.options.environment).isEmpty()) {
            data.methodData.printCurl = true;
            String curl = (String)JavaDocUtils.getAnnotationValue(methodDoc, ApiCurl.class, VALUE, this.options.environment);
            if (curl != null) {
                data.methodData.curl = curl;
            }
        }
    }

    protected void addLabel(ExecutableElement method, RestMethodData data) {
        String label = (String)JavaDocUtils.getAnnotationValue(method, ApiLabel.class, VALUE, this.options.environment);
        data.methodData.label = label != null ? label : method.getSimpleName().toString();
    }

    protected void addDeprecated(ExecutableElement method, RestMethodData data) {
        List<? extends AnnotationMirror> deprecatedAnnotation = JavaDocUtils.getAnnotationDesc(method, Deprecated.class, this.options.environment);
        if (!deprecatedAnnotation.isEmpty()) {
            data.methodData.deprecated = true;
            Optional<DeprecatedTree> deprecatedTag = JavaDocUtils.getTags(method, this.options.environment).stream().filter(tag -> tag instanceof DeprecatedTree).map(tag -> (DeprecatedTree)tag).findFirst();
            if (deprecatedTag.isPresent()) {
                data.methodData.deprecatedDescription = deprecatedTag.get().getBody().stream().map(Object::toString).collect(Collectors.joining());
                deprecatedTag.get().getBody().stream().filter(tag -> tag instanceof LinkTree).map(tag -> (LinkTree)tag).forEach(linkTree -> {
                    Element referencedMember = JavaDocUtils.getReferencedElement(method, linkTree.getReference(), this.options.environment);
                    if (referencedMember instanceof ExecutableElement) {
                        data.methodData.links.add((ExecutableElement)referencedMember);
                    }
                });
            }
        }
    }

    protected abstract List<AnnotationValue> getConsumes(ExecutableElement var1);

    protected abstract List<AnnotationValue> getProduces(ExecutableElement var1);

    protected void addMediaType(ExecutableElement method, RestMethodData data) {
        List<AnnotationValue> consumes = this.getConsumes(method);
        if (consumes != null) {
            data.requestData.mediaType = consumes.stream().map(av -> (String)av.getValue()).collect(Collectors.toList());
        }
    }

    protected void addResponseData(ExecutableElement method, RestMethodData data) {
        this.addResponsesFromAnnotations(method, data);
    }

    protected void addResponsesFromAnnotations(ExecutableElement method, RestMethodData data) {
        List<AnnotationValue> produces = this.getProduces(method);
        List responses = (List)JavaDocUtils.getAnnotationValue(method, ApiResponses.class, VALUE, this.options.environment);
        if (responses != null) {
            responses.forEach(repsonse -> this.addResponse((AnnotationMirror)repsonse.getValue(), data, produces));
        } else {
            List<? extends AnnotationMirror> singleResponse = JavaDocUtils.getAnnotationDesc(method, ApiResponse.class, this.options.environment);
            singleResponse.forEach(annotationMirror -> this.addResponse((AnnotationMirror)annotationMirror, data, produces));
        }
    }

    protected void addResponse(AnnotationMirror response, RestMethodData data, List<AnnotationValue> produces) {
        RestMethodData.ResponseData responseData = new RestMethodData.ResponseData();
        data.responseData.add(responseData);
        this.addCommonResponseData(response, produces, responseData);
    }

    protected TypeMirror getResponseEntityClass(ExecutableElement method, AnnotationMirror response) {
        return (TypeMirror)JavaDocUtils.extractValue(response, "entityClass");
    }

    protected void addCommonResponseData(AnnotationMirror response, List<AnnotationValue> produces, RestMethodData.ResponseData responseData) {
        List entities;
        List headers;
        VariableElement status = (VariableElement)JavaDocUtils.extractValue(response, "status");
        responseData.status = ApiStatus.valueOf(status.getSimpleName().toString());
        String description = (String)JavaDocUtils.extractValue(response, DESCRIPTION);
        if (description != null) {
            responseData.description = description;
        }
        if ((headers = (List)JavaDocUtils.extractValue(response, "headers")) != null) {
            for (AnnotationValue header : headers) {
                Boolean deprecated;
                AnnotationMirror headerDesc = (AnnotationMirror)header.getValue();
                RestMethodData.HeaderInfo headerInfo = new RestMethodData.HeaderInfo();
                headerInfo.name = (String)JavaDocUtils.extractValue(headerDesc, "name");
                headerInfo.description = (String)JavaDocUtils.extractValue(headerDesc, DESCRIPTION);
                Boolean optional = (Boolean)JavaDocUtils.extractValue(headerDesc, "optional");
                if (optional != null) {
                    headerInfo.required = optional != false ? RequiredStatus.OPTIONAL : RequiredStatus.REQUIRED;
                }
                headerInfo.deprecated = (deprecated = (Boolean)JavaDocUtils.extractValue(headerDesc, "deprecated")) != null && deprecated != false;
                headerInfo.deprecatedDescription = (String)JavaDocUtils.extractValue(headerDesc, "deprecatedDescription");
                List allowedValues = (List)JavaDocUtils.extractValue(headerDesc, "allowedValues");
                if (allowedValues != null) {
                    for (AnnotationValue allowedValue : allowedValues) {
                        AnnotationMirror allowedValueDesc = (AnnotationMirror)allowedValue.getValue();
                        this.addAllowedValuesFromAnnotation(allowedValueDesc, headerInfo.allowedValues);
                    }
                }
                responseData.headers.add(headerInfo);
            }
        }
        if ((entities = (List)JavaDocUtils.extractValue(response, "entities")) != null) {
            for (AnnotationValue entity : entities) {
                String contentTypeFromResponse;
                TypeMirror extendedCollectionType;
                TypeElement element;
                AnnotationMirror entityDesc = (AnnotationMirror)entity.getValue();
                RestMethodData.Entity responseEntity = new RestMethodData.Entity();
                responseData.entities.add(responseEntity);
                responseEntity.entityClass = (TypeMirror)JavaDocUtils.extractValue(entityDesc, "entityClass");
                responseEntity.description = (String)JavaDocUtils.extractValue(entityDesc, DESCRIPTION);
                if (responseEntity.description == null && (element = (TypeElement)this.options.environment.getTypeUtils().asElement(responseEntity.entityClass)) != null) {
                    responseEntity.description = JavaDocUtils.getCommentTextFromInterfaceOrClass(element, this.options.environment, false);
                }
                if ((extendedCollectionType = JavaDocUtils.getExtendedCollectionType(responseEntity.entityClass, this.options.environment)) != null) {
                    responseEntity.entityClass = extendedCollectionType;
                }
                responseEntity.contentType = (contentTypeFromResponse = (String)JavaDocUtils.extractValue(entityDesc, "contentType")) != null ? contentTypeFromResponse : (String)produces.get(0).getValue();
                this.addNestedParameters(responseEntity.entityClass, responseEntity.nestedParameters, new ArrayList<TypeMirror>());
                List examples = (List)JavaDocUtils.extractValue(entityDesc, "examples");
                responseEntity.examples.addAll(this.getExamples(examples));
            }
        }
    }

    private List<RestMethodData.Example> getExamples(List<AnnotationValue> examples) {
        ArrayList<RestMethodData.Example> exampleList = new ArrayList<RestMethodData.Example>();
        if (examples != null) {
            for (AnnotationValue example : examples) {
                AnnotationMirror exampleDesc = (AnnotationMirror)example.getValue();
                RestMethodData.Example exampleData = new RestMethodData.Example();
                exampleData.title = (String)JavaDocUtils.extractValue(exampleDesc, TITLE);
                exampleData.value = (String)JavaDocUtils.extractValue(exampleDesc, VALUE);
                exampleData.description = (String)JavaDocUtils.extractValue(exampleDesc, DESCRIPTION);
                exampleList.add(exampleData);
            }
        }
        return exampleList;
    }
}

