/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.neberus.parse;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import net.oneandone.neberus.annotation.ApiCommonResponse;
import net.oneandone.neberus.annotation.ApiCommonResponses;
import net.oneandone.neberus.annotation.ApiDescription;
import net.oneandone.neberus.annotation.ApiHeaderDefinition;
import net.oneandone.neberus.annotation.ApiHeaderDefinitions;
import net.oneandone.neberus.annotation.ApiIgnore;
import net.oneandone.neberus.annotation.ApiLabel;
import net.oneandone.neberus.parse.MethodParser;
import net.oneandone.neberus.parse.RestClassData;
import net.oneandone.neberus.parse.RestMethodData;
import net.oneandone.neberus.util.JavaDocUtils;

public abstract class ClassParser {
    MethodParser methodParser;

    public ClassParser(MethodParser methodParser) {
        this.methodParser = methodParser;
    }

    public RestClassData parse(TypeElement classDoc) {
        RestClassData restClassData = new RestClassData();
        this.addLabel(classDoc, restClassData);
        this.addHeaders(classDoc, restClassData);
        this.addResponsesFromAnnotations(classDoc, restClassData);
        this.addDescription(classDoc, restClassData);
        restClassData.className = classDoc.getSimpleName().toString();
        restClassData.classDoc = classDoc;
        List methods = classDoc.getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).collect(Collectors.toList());
        for (ExecutableElement method : methods) {
            List<RestMethodData> parsedMethodDataList = this.parseMethods(method);
            if (parsedMethodDataList == null) continue;
            parsedMethodDataList.forEach(parsedMethodData -> {
                parsedMethodData.containingClass = restClassData;
                restClassData.methods.add((RestMethodData)parsedMethodData);
            });
        }
        return restClassData;
    }

    protected abstract List<String> getHttpMethods(ExecutableElement var1);

    private List<RestMethodData> parseMethods(ExecutableElement method) {
        List<String> httpMethods = this.getHttpMethods(method);
        if (httpMethods == null || JavaDocUtils.hasAnnotation(method, ApiIgnore.class, this.methodParser.options.environment)) {
            return Collections.emptyList();
        }
        return httpMethods.stream().map(httpMethod -> this.methodParser.parseMethod(method, (String)httpMethod)).collect(Collectors.toList());
    }

    protected void addLabel(TypeElement classDoc, RestClassData restClassData) {
        String label = (String)JavaDocUtils.getAnnotationValue(classDoc, ApiLabel.class, "value", this.methodParser.options.environment);
        restClassData.label = label != null ? label : classDoc.getSimpleName().toString();
    }

    protected void addDescription(TypeElement classDoc, RestClassData restClassData) {
        restClassData.shortDescription = (String)JavaDocUtils.getAnnotationValue(classDoc, ApiDescription.class, "value", this.methodParser.options.environment);
        restClassData.description = JavaDocUtils.getCommentTextFromInterfaceOrClass(classDoc, this.methodParser.options.environment, false);
    }

    protected void addHeaders(TypeElement classDoc, RestClassData restClassData) {
        List headers = (List)JavaDocUtils.getAnnotationValue(classDoc, ApiHeaderDefinitions.class, "value", this.methodParser.options.environment);
        if (headers != null) {
            headers.forEach(header -> this.addHeader((AnnotationMirror)header.getValue(), restClassData));
        } else {
            List<? extends AnnotationMirror> singleResponse = JavaDocUtils.getAnnotationDesc(classDoc, ApiHeaderDefinition.class, this.methodParser.options.environment);
            singleResponse.forEach(annotationDesc -> this.addHeader((AnnotationMirror)annotationDesc, restClassData));
        }
    }

    protected void addHeader(AnnotationMirror headerDesc, RestClassData restClassData) {
        String name = (String)JavaDocUtils.extractValue(headerDesc, "name");
        String description = (String)JavaDocUtils.extractValue(headerDesc, "description");
        RestMethodData.HeaderInfo headerInfo = new RestMethodData.HeaderInfo();
        headerInfo.name = name;
        headerInfo.description = description;
        restClassData.headerDefinitions.put(name, headerInfo);
    }

    protected void addResponsesFromAnnotations(TypeElement classDoc, RestClassData restClassData) {
        List produces = Collections.emptyList();
        RestMethodData tmpRestMethodData = new RestMethodData("tmp");
        List<? extends AnnotationMirror> responses = JavaDocUtils.getAnnotationDesc(classDoc, ApiCommonResponses.class, this.methodParser.options.environment);
        if (responses != null) {
            responses.stream().flatMap(container -> {
                List vs = (List)JavaDocUtils.extractValue(container, "value");
                if (vs == null) {
                    return Stream.empty();
                }
                return vs.stream();
            }).forEach(repsonse -> this.methodParser.addResponse((AnnotationMirror)repsonse.getValue(), tmpRestMethodData, produces));
        }
        List<? extends AnnotationMirror> singleResponse = JavaDocUtils.getAnnotationDesc(classDoc, ApiCommonResponse.class, this.methodParser.options.environment);
        singleResponse.forEach(annotationDesc -> this.methodParser.addResponse((AnnotationMirror)annotationDesc, tmpRestMethodData, produces));
        restClassData.commonResponseData.addAll(tmpRestMethodData.responseData);
    }
}

