/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.launcher.Failure;
import net.oneandone.sushi.launcher.Launcher;
import org.apache.maven.plugin.logging.Log;

public final class Subversion {
    private static final Pattern PATTERN = Pattern.compile("^URL:(.*)$", 10);

    public static Launcher launcher(FileNode dir, SvnCredentials credentials, String ... args) {
        Launcher launcher = new Launcher(dir, new String[]{"svn", "--non-interactive", "--no-auth-cache"});
        if (credentials != null && credentials.username() != null) {
            launcher = launcher.arg(new String[]{"--username", credentials.username()});
        }
        if (credentials != null && credentials.password() != null) {
            launcher = launcher.arg(new String[]{"--password", credentials.password()});
        }
        return launcher.arg(args);
    }

    public static boolean exists(FileNode dir, SvnCredentials credentials, String svnurl) {
        try {
            Subversion.launcher(dir, credentials, "ls", svnurl).exec();
            return true;
        }
        catch (Failure e) {
            return false;
        }
    }

    public static void sparseCheckout(Log log, FileNode result, String svnurl, String revision, boolean tryChanges, SvnCredentials credentials) throws Failure {
        log.debug((CharSequence)Subversion.launcher(result.getParent(), credentials, "co", "-r", revision, "--depth", "empty", svnurl, result.getName()).exec());
        log.debug((CharSequence)Subversion.launcher(result, credentials, "up", "-r", revision, "pom.xml").exec());
        if (tryChanges) {
            log.debug((CharSequence)Subversion.launcher(result, credentials, "up", "-r", revision, "--depth", "empty", "src/changes").exec());
            log.debug((CharSequence)Subversion.launcher(result, credentials, "up", "-r", revision, "--depth", "empty", "src").exec());
            log.debug((CharSequence)Subversion.launcher(result, credentials, "up", "-r", revision, "src/changes/changes.xml").exec());
        }
    }

    private Subversion() {
    }

    public static String workspaceUrl(FileNode directory, SvnCredentials credentials) throws Failure {
        String str = Subversion.launcher(directory, credentials, "info").exec();
        Matcher matcher = PATTERN.matcher(str);
        if (!matcher.find()) {
            throw new IllegalStateException("cannot determine checkout url in " + str);
        }
        return matcher.group(1).trim();
    }

    public static class SvnCredentials {
        private final String username;
        private final String password;

        public static final SvnCredentials NONE() {
            return new SvnCredentials(null, null);
        }

        public SvnCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        private String username() {
            return this.username;
        }

        private String password() {
            return this.password;
        }
    }
}

