/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.DependencyContext;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.lifecycle.internal.PhaseRecorder;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;

public class FilteringMojoExecutor
extends MojoExecutor {
    private final LifecycleModuleBuilder builder;
    private final Field field;
    private final MojoExecutor baseExecutor;
    private final Filter filter;
    private final DefaultLifecycles defaultLifecycles;
    private static final String PRERELEASE_CHECK_PREFIX = "prerelease-check";
    public static final Filter ALL = new Filter(){

        @Override
        public String toString() {
            return "%all%";
        }

        @Override
        public boolean include(boolean nested, MojoExecution execution) {
            return true;
        }
    };
    public static final Filter CHECK = new Filter(){

        @Override
        public String toString() {
            return "%check%";
        }

        @Override
        public boolean include(boolean nested, MojoExecution execution) {
            return nested ? true : execution.getExecutionId().startsWith(FilteringMojoExecutor.PRERELEASE_CHECK_PREFIX);
        }
    };
    public static final Filter NONE_CHECK = new Filter(){

        @Override
        public String toString() {
            return "%none-check%";
        }

        @Override
        public boolean include(boolean nested, MojoExecution execution) {
            return !execution.getExecutionId().startsWith(FilteringMojoExecutor.PRERELEASE_CHECK_PREFIX);
        }
    };
    public static final Filter DEPLOY = new Filter(){

        @Override
        public String toString() {
            return "%deploy%";
        }

        @Override
        public boolean include(boolean nested, MojoExecution execution) {
            return nested ? true : "deploy".equals(execution.getLifecyclePhase());
        }
    };

    public static FilteringMojoExecutor install(PlexusContainer container, Filter filter) {
        FilteringMojoExecutor result;
        try {
            LifecycleModuleBuilder builder = (LifecycleModuleBuilder)container.lookup(LifecycleModuleBuilder.class);
            Field field = builder.getClass().getDeclaredField("mojoExecutor");
            field.setAccessible(true);
            result = new FilteringMojoExecutor(builder, field, (MojoExecutor)field.get(builder), filter, (DefaultLifecycles)container.lookup(DefaultLifecycles.class));
            field.set(builder, (Object)result);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public FilteringMojoExecutor(LifecycleModuleBuilder builder, Field field, MojoExecutor baseExecutor, Filter filter, DefaultLifecycles defaultLifecyles) {
        this.builder = builder;
        this.field = field;
        this.baseExecutor = baseExecutor;
        this.filter = filter;
        this.defaultLifecycles = defaultLifecyles;
    }

    public void uninstall() {
        try {
            this.field.set(this.builder, this.baseExecutor);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public DependencyContext newDependencyContext(MavenSession session, List<MojoExecution> mojoExecutions) {
        return this.baseExecutor.newDependencyContext(session, mojoExecutions);
    }

    public void execute(MavenSession session, List<MojoExecution> mojoExecutions, ProjectIndex projectIndex) throws LifecycleExecutionException {
        this.baseExecutor.execute(session, this.filter(false, mojoExecutions), projectIndex);
    }

    public void execute(MavenSession session, MojoExecution mojoExecution, ProjectIndex projectIndex, DependencyContext dependencyContext, PhaseRecorder phaseRecorder) throws LifecycleExecutionException {
        this.baseExecutor.execute(session, mojoExecution, projectIndex, dependencyContext, phaseRecorder);
    }

    public void ensureDependenciesAreResolved(MojoDescriptor mojoDescriptor, MavenSession session, DependencyContext dependencyContext) throws LifecycleExecutionException {
        this.baseExecutor.ensureDependenciesAreResolved(mojoDescriptor, session, dependencyContext);
    }

    public List<MavenProject> executeForkedExecutions(MojoExecution mojoExecution, MavenSession session, ProjectIndex projectIndex) throws LifecycleExecutionException {
        return this.baseExecutor.executeForkedExecutions(mojoExecution, session, projectIndex);
    }

    private List<MojoExecution> filter(boolean nested, List<MojoExecution> orig) {
        ArrayList<MojoExecution> result = new ArrayList<MojoExecution>();
        for (MojoExecution execution : orig) {
            if (!this.filter.include(nested, execution)) continue;
            result.add(execution);
            for (Map.Entry entry : execution.getForkedExecutions().entrySet()) {
                execution.setForkedExecutions((String)entry.getKey(), this.filter(true, (List)entry.getValue()));
            }
        }
        return result;
    }

    public static abstract class Filter {
        public abstract String toString();

        public abstract boolean include(boolean var1, MojoExecution var2);
    }
}

