/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.oneandone.maven.plugins.prerelease.core.Descriptor;
import net.oneandone.maven.plugins.prerelease.core.PendingUpdates;
import net.oneandone.maven.plugins.prerelease.core.RevisionMismatch;
import net.oneandone.maven.plugins.prerelease.core.SvnUrlMismatch;
import net.oneandone.maven.plugins.prerelease.core.UncommitedChanges;
import net.oneandone.maven.plugins.prerelease.util.Subversion;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.launcher.Failure;
import net.oneandone.sushi.util.Strings;
import net.oneandone.sushi.xml.Selector;
import net.oneandone.sushi.xml.XmlException;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WorkingCopy {
    public final FileNode directory;
    public final List<FileNode> modifications;
    public final SortedSet<Long> revisions;
    public final SortedSet<Long> changes;
    public final List<String> pendingUpdates;
    public final Subversion.SvnCredentials svnCredentials;

    public static WorkingCopy load(FileNode workingCopy, Subversion.SvnCredentials credentials) throws IOException, SAXException, XmlException {
        String output = Subversion.launcher(workingCopy, credentials, "--xml", "-v", "--show-updates", "status").exec();
        World world = workingCopy.getWorld();
        Document doc = world.getXml().getBuilder().parseString(output);
        Selector selector = world.getXml().getSelector();
        ArrayList<FileNode> modifications = new ArrayList<FileNode>();
        TreeSet<Long> revisions = new TreeSet<Long>();
        TreeSet<Long> changes = new TreeSet<Long>();
        HashMap<String, Long> maybePendings = new HashMap<String, Long>();
        for (Element element : selector.elements((Node)doc, "status/target/entry")) {
            String path = element.getAttribute("path");
            Element wcStatus = selector.element((Node)element, "wc-status");
            String props = wcStatus.getAttribute("props");
            if ("normal".equals(wcStatus.getAttribute("item")) && ("none".equals(props) || "normal".equals(props))) {
                long revision = Long.parseLong(wcStatus.getAttribute("revision"));
                revisions.add(revision);
                long change = Long.parseLong(selector.element((Node)wcStatus, "commit").getAttribute("revision"));
                changes.add(change);
                if (selector.elementOpt((Node)element, "repos-status") == null) continue;
                maybePendings.put(element.getAttribute("path"), change);
                continue;
            }
            modifications.add(workingCopy.join(new String[]{path}));
        }
        if (changes.size() == 0) {
            throw new IOException("Cannot determine svn status - is this directory under svn?");
        }
        if (revisions.size() == 0) {
            throw new IllegalStateException();
        }
        if ((Long)changes.last() > (Long)revisions.last()) {
            throw new IllegalStateException(changes.last() + " vs " + revisions.last());
        }
        ArrayList<String> pendings = new ArrayList<String>();
        for (Map.Entry entry : maybePendings.entrySet()) {
            if ((Long)entry.getValue() >= (Long)revisions.last()) continue;
            output = Subversion.launcher(workingCopy, credentials, "log", "--xml", "-q", "-r" + ((Long)entry.getValue() + 1L) + ":" + revisions.last(), (String)entry.getKey()).exec();
            doc = world.getXml().getBuilder().parseString(output);
            if (selector.elements((Node)doc, "log/logentry").size() <= 0) continue;
            pendings.add((String)entry.getKey());
        }
        return new WorkingCopy(workingCopy, modifications, revisions, changes, pendings, credentials);
    }

    public WorkingCopy(FileNode directory, List<FileNode> modifications, SortedSet<Long> revisions, SortedSet<Long> changes, List<String> pendingUpdates, Subversion.SvnCredentials svnCredentials) {
        this.directory = directory;
        this.modifications = modifications;
        this.revisions = revisions;
        this.changes = changes;
        this.pendingUpdates = pendingUpdates;
        this.svnCredentials = svnCredentials;
    }

    public long revision() {
        return this.changes.last();
    }

    public void check() throws UncommitedChanges, PendingUpdates {
        if (!this.modifications.isEmpty()) {
            throw new UncommitedChanges(this.modifications);
        }
        if (!this.pendingUpdates.isEmpty()) {
            throw new PendingUpdates(this.revisions.last(), this.pendingUpdates);
        }
    }

    public Descriptor checkCompatibility(Descriptor descriptor) throws Exception {
        String svnurlWorkspace = Subversion.workspaceUrl(this.directory, this.svnCredentials);
        if (!(svnurlWorkspace = Strings.removeRightOpt((String)svnurlWorkspace, (String)"/")).equals(descriptor.svnOrig)) {
            throw new SvnUrlMismatch(svnurlWorkspace, descriptor.svnOrig);
        }
        if (this.revision() != descriptor.revision) {
            throw new RevisionMismatch(this.revision(), descriptor.revision);
        }
        return descriptor;
    }

    public void update(Log log) throws Failure {
        log.info((CharSequence)Subversion.launcher(this.directory, this.svnCredentials, "update").exec());
    }
}

