/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.oneandone.maven.plugins.prerelease.Base;
import net.oneandone.maven.plugins.prerelease.core.Archive;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="swap", requiresProject=false)
public class Swap
extends Base {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() throws Exception {
        int level;
        int count = 0;
        List<FileNode> storages = this.storages();
        HashSet<String> relatives = new HashSet<String>();
        for (level = 0; level < storages.size(); ++level) {
            FileNode storage = storages.get(level);
            this.getLog().info((CharSequence)("storage " + (level + 1) + ": " + storage.getAbsolute()));
            List archives = storage.find(new String[]{"*/*"});
            for (Node candidate : archives) {
                if (!candidate.isDirectory()) continue;
                relatives.add(candidate.getRelative((Node)storage));
            }
        }
        this.getLog().info((CharSequence)("archives found: " + relatives.size()));
        for (String relative : relatives) {
            Archive archive = Archive.tryOpen(Swap.directories(storages, relative));
            if (archive == null) {
                this.getLog().info((CharSequence)("skipped because it is locked: " + relative));
                continue;
            }
            try {
                archive.wipe(this.keep);
                for (FileNode src : archive.list().values()) {
                    level = Swap.findLevel(storages, (Node)src);
                    this.getLog().debug((CharSequence)(src + ": level " + level));
                    if (level == storages.size() - 1) {
                        this.getLog().debug((CharSequence)("already in final storage: " + src));
                        continue;
                    }
                    FileNode dest = storages.get(level + 1).join(new String[]{relative, src.getName()});
                    dest.getParent().mkdirsOpt();
                    src.move((Node)dest);
                    this.getLog().info((CharSequence)("swapped " + src.getAbsolute() + " -> " + dest.getAbsolute()));
                    ++count;
                }
            }
            finally {
                archive.close();
            }
        }
        this.getLog().info((CharSequence)(count + " archives swapped."));
    }

    private static int findLevel(List<FileNode> storages, Node prerelease) {
        for (int level = 0; level < storages.size(); ++level) {
            if (!prerelease.hasAnchestor((Node)storages.get(level))) continue;
            return level;
        }
        throw new IllegalStateException(prerelease.toString());
    }

    private static List<FileNode> directories(List<FileNode> storages, String relative) {
        ArrayList<FileNode> result = new ArrayList<FileNode>();
        for (FileNode storage : storages) {
            result.add(storage.join(new String[]{relative}));
        }
        return result;
    }
}

