/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.launcher.Failure;
import net.oneandone.sushi.launcher.Launcher;
import org.apache.maven.plugin.logging.Log;

public final class Subversion {
    private static final Pattern PATTERN = Pattern.compile("^URL:(.*)$", 10);

    public static Launcher launcher(FileNode dir, String ... args) {
        return new Launcher(dir, new String[]{"svn", "--non-interactive", "--no-auth-cache"}).arg(args);
    }

    public static boolean exists(FileNode dir, String svnurl) {
        try {
            Subversion.launcher(dir, "ls", svnurl).exec();
            return true;
        }
        catch (Failure e) {
            return false;
        }
    }

    public static void sparseCheckout(Log log, FileNode result, String svnurl, String revision, boolean tryChanges) throws Failure {
        log.debug((CharSequence)Subversion.launcher(result.getParent(), "co", "-r", revision, "--depth", "empty", svnurl, result.getName()).exec());
        log.debug((CharSequence)Subversion.launcher(result, "up", "-r", revision, "pom.xml").exec());
        if (tryChanges) {
            log.debug((CharSequence)Subversion.launcher(result, "up", "-r", revision, "--depth", "empty", "src").exec());
            log.debug((CharSequence)Subversion.launcher(result, "up", "-r", revision, "--depth", "empty", "src/changes").exec());
            log.debug((CharSequence)Subversion.launcher(result, "up", "-r", revision, "src/changes/changes.xml").exec());
        }
    }

    private Subversion() {
    }

    public static String workspaceUrl(FileNode directory) throws Failure {
        String str = Subversion.launcher(directory, "info").exec();
        Matcher matcher = PATTERN.matcher(str);
        if (!matcher.find()) {
            throw new IllegalStateException("cannot determine checkout url in " + str);
        }
        return matcher.group(1).trim();
    }
}

