/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.oneandone.maven.plugins.prerelease.core.BaseExecutionListener;
import net.oneandone.maven.plugins.prerelease.core.Prerelease;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.project.MavenProject;

public class PrepareExecutionListener
extends BaseExecutionListener {
    private final Prerelease prerelease;
    private final Map<String, String> initialProperties;

    public PrepareExecutionListener(Prerelease prerelease, ExecutionListener base) {
        super(base);
        this.prerelease = prerelease;
        this.initialProperties = new HashMap<String, String>();
    }

    @Override
    public void projectStarted(ExecutionEvent event) {
        this.initialProperties(event.getSession().getCurrentProject());
        super.projectStarted(event);
    }

    @Override
    public void projectSucceeded(ExecutionEvent event) {
        super.projectSucceeded(event);
        this.saveModified(event.getSession().getCurrentProject());
    }

    private void initialProperties(MavenProject project) {
        for (Map.Entry<Object, Object> entry : project.getProperties().entrySet()) {
            if (entry.getValue() instanceof String) {
                this.initialProperties.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            throw new IllegalStateException();
        }
    }

    public void saveModified(MavenProject project) {
        Map<String, String> deployProperties = this.prerelease.descriptor.deployProperties;
        for (Map.Entry<Object, Object> entry : project.getProperties().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String old = this.initialProperties.get(entry.getKey());
            if (entry.getValue().equals(old)) continue;
            deployProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            this.prerelease.descriptor.save(this.prerelease.target);
        }
        catch (IOException e) {
            throw new RuntimeException("TODO", e);
        }
    }
}

