/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.oneandone.maven.plugins.prerelease.core.Prerelease;
import net.oneandone.maven.plugins.prerelease.util.BuildException;
import net.oneandone.maven.plugins.prerelease.util.FilteringMojoExecutor;
import net.oneandone.maven.plugins.prerelease.util.PromoteExecutionListener;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.util.Separator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class Maven {
    private final World world;
    private final Log log;
    private final MavenSession parentSession;
    private final ArtifactRepository localRepository;
    private final ExecutionListener executionListener;
    private final MavenProjectHelper projectHelper;
    private final List<ArtifactRepository> remoteRepositories;
    private final ProjectBuilder builder;

    public Maven(World world, Log log, MavenSession parentSession, ArtifactRepository localRepository, ExecutionListener executionListener, MavenProjectHelper projectHelper, ProjectBuilder builder, List<ArtifactRepository> remoteRepositories) {
        this.world = world;
        this.log = log;
        this.parentSession = parentSession;
        this.localRepository = localRepository;
        this.executionListener = executionListener;
        this.projectHelper = projectHelper;
        this.builder = builder;
        this.remoteRepositories = remoteRepositories;
    }

    public FileNode getLocalRepositoryDir() {
        return this.world.file(this.localRepository.getBasedir());
    }

    public ExecutionListener getExecutionListener() {
        return this.executionListener;
    }

    public void build(FileNode basedir, Map<String, String> userProperties, FilteringMojoExecutor.Filter filter, String ... goals) throws Exception {
        this.build(basedir, userProperties, this.executionListener, filter, goals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(FileNode basedir, Map<String, String> userProperties, ExecutionListener theExecutionListener, FilteringMojoExecutor.Filter filter, String ... goals) throws BuildException {
        MavenExecutionResult result;
        org.apache.maven.Maven maven;
        MavenExecutionRequest request = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)this.parentSession.getRequest());
        DefaultPlexusContainer container = (DefaultPlexusContainer)this.parentSession.getContainer();
        try {
            maven = (org.apache.maven.Maven)container.lookup(org.apache.maven.Maven.class);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException(e);
        }
        request.setPom(basedir.join(new String[]{"pom.xml"}).toPath().toFile());
        request.setProjectPresent(true);
        request.setGoals(Arrays.asList(goals));
        request.setBaseDirectory(basedir.toPath().toFile());
        request.setUserProperties(Maven.merged(request.getUserProperties(), userProperties));
        request.setExecutionListener(theExecutionListener);
        FilteringMojoExecutor mojoExecutor = FilteringMojoExecutor.install((PlexusContainer)container, filter);
        this.log.info((CharSequence)("[" + basedir + " " + filter + "] mvn " + Maven.props(request.getUserProperties()) + Separator.SPACE.join((Object[])goals)));
        this.nestedOutputOn();
        try {
            result = maven.execute(request);
        }
        finally {
            this.nestedOutputOff();
            mojoExecutor.uninstall();
        }
        Throwable exception = null;
        for (Throwable e : result.getExceptions()) {
            if (exception == null) {
                exception = new BuildException("build failed: " + e, e);
                continue;
            }
            exception.addSuppressed(e);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static String props(Properties props) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            builder.append("-D").append(entry.getKey());
            if (!((String)entry.getValue()).isEmpty()) {
                builder.append('=').append(entry.getValue());
            }
            builder.append(' ');
        }
        return builder.toString();
    }

    private static Properties merged(Properties left, Map<String, String> right) {
        Properties result = new Properties(left);
        result.putAll(right);
        return result;
    }

    public void deployPrerelease(Log log, Map<String, String> propertyArgs, Prerelease prerelease) throws Exception {
        PromoteExecutionListener listener = new PromoteExecutionListener(prerelease, this.projectHelper, this.executionListener);
        try {
            this.build(prerelease.checkout, prerelease.descriptor.releaseProps(propertyArgs), listener, FilteringMojoExecutor.DEPLOY, "deploy");
        }
        catch (BuildException e) {
            if (listener.isDeploySuccess()) {
                log.warn((CharSequence)"Promote succeeded: your artifacts have been deployed, and your svn tag was created. ");
                log.warn((CharSequence)"However, some optional deploy goals failed with this exception:");
                log.warn((Throwable)e);
                log.warn((CharSequence)"Thus, you can use your release, but someone should have a look at this exception.");
            }
            throw e;
        }
    }

    public void deploySnapshot(FileNode directory, Log log, Map<String, String> propertyArgs, Prerelease prerelease) throws Exception {
        PromoteExecutionListener listener = new PromoteExecutionListener(prerelease, this.projectHelper, this.executionListener);
        try {
            this.build(directory, propertyArgs, listener, FilteringMojoExecutor.DEPLOY, "deploy");
        }
        catch (BuildException e) {
            if (listener.isDeploySuccess()) {
                log.warn((CharSequence)"Snapshot deployment succeeded.");
                log.warn((CharSequence)"However, some optional deploy goals failed with this exception:");
                log.warn((Throwable)e);
                log.warn((CharSequence)"Thus, you can use your snapshots, but someone should have a look at this exception.");
            }
            throw e;
        }
    }

    public List<FileNode> files(List<Artifact> artifacts) {
        ArrayList<FileNode> result = new ArrayList<FileNode>();
        for (Artifact a : artifacts) {
            result.add(this.file(a));
        }
        return result;
    }

    public FileNode file(Artifact artifact) {
        return this.world.file(artifact.getFile());
    }

    public MavenProject loadPom(FileNode file) throws ProjectBuildingException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.parentSession.getProjectBuildingRequest());
        request.setRemoteRepositories(this.remoteRepositories);
        request.setProcessPlugins(false);
        request.setValidationLevel(0);
        request.setSystemProperties(System.getProperties());
        request.setRepositoryMerging(ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT);
        request.setResolveDependencies(false);
        ProjectBuildingResult result = this.builder.build(file.toPath().toFile(), (ProjectBuildingRequest)request);
        return result.getProject();
    }

    private void nestedOutputOn() {
        this.log.info((CharSequence)"\u001b[2m");
    }

    private void nestedOutputOff() {
        this.log.info((CharSequence)"\u001b[0m");
    }
}

