/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.xml.Selector;
import net.oneandone.sushi.xml.XmlException;
import org.apache.maven.plugin.MojoExecutionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public final class Transform {
    public static void adjustPom(FileNode pom, String expectedVersion, String nextVersion, String svnurl, String tag) throws IOException, MojoExecutionException, SAXException, XmlException {
        Document document = pom.readXml();
        Selector selector = new Selector();
        selector.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (!prefix.equals("M")) {
                    throw new IllegalStateException("prefix: " + prefix);
                }
                return "http://maven.apache.org/POM/4.0.0";
            }

            @Override
            public String getPrefix(String namespaceURI) {
                throw new IllegalStateException();
            }

            public Iterator getPrefixes(String namespaceURI) {
                throw new IllegalStateException();
            }
        });
        Element element = selector.element((Node)document, "/M:project/M:version");
        if (!expectedVersion.equals(element.getTextContent().trim())) {
            throw new MojoExecutionException("expected version " + expectedVersion + ", got " + element.getTextContent().trim());
        }
        element.setTextContent(nextVersion);
        if (tag != null) {
            Transform.scm(selector.elementOpt((Node)document, "/M:project/M:scm/M:connection"), svnurl, tag);
            Transform.scm(selector.elementOpt((Node)document, "/M:project/M:scm/M:developerConnection"), svnurl, tag);
            Transform.scm(selector.elementOpt((Node)document, "/M:project/M:scm/M:url"), svnurl, tag);
        }
        Transform.writeRaw(document, pom);
    }

    public static void writeRaw(Document document, FileNode file) throws IOException {
        DOMImplementationLS ls = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = ls.createLSSerializer();
        LSOutput output = ls.createLSOutput();
        OutputStream stream = file.createOutputStream();
        output.setByteStream(stream);
        serializer.write(document, output);
        stream.write(10);
        stream.close();
    }

    private static void scm(Element element, String svnurl, String tag) throws MojoExecutionException {
        if (element == null) {
            return;
        }
        String old = element.getTextContent();
        element.setTextContent(Transform.adjustScm(old, svnurl, tag));
    }

    public static String adjustScm(String origStr, String svnurl, String tag) throws MojoExecutionException {
        if ("scm:svn:${project.scm.url}".equals(origStr)) {
            return origStr;
        }
        String str = origStr;
        if (str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        if (!(str = str.trim()).endsWith(svnurl)) {
            throw new MojoExecutionException("unexpected scm entry: " + origStr);
        }
        return str.substring(0, str.length() - svnurl.length()) + tag;
    }

    private Transform() {
    }
}

