/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.util;

import java.io.IOException;
import net.oneandone.maven.plugins.prerelease.core.BaseExecutionListener;
import net.oneandone.maven.plugins.prerelease.core.Prerelease;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class PromoteExecutionListener
extends BaseExecutionListener {
    private final Prerelease prerelease;
    private final MavenProjectHelper projectHelper;
    private int mojosStarted;
    private boolean firstSuccess;

    public PromoteExecutionListener(Prerelease prerelease, MavenProjectHelper projectHelper, ExecutionListener base) {
        super(base);
        this.prerelease = prerelease;
        this.projectHelper = projectHelper;
        this.mojosStarted = 0;
        this.firstSuccess = false;
    }

    @Override
    public void projectStarted(ExecutionEvent event) {
        MavenProject project = event.getSession().getCurrentProject();
        try {
            this.prerelease.artifactFiles(project, this.projectHelper);
            project.getProperties().putAll(this.prerelease.descriptor.deployProperties);
            if (this.prerelease.descriptor.deployPluginMetadata) {
                Artifact projectArtifact = project.getArtifact();
                Versioning versioning = new Versioning();
                versioning.setLatest(projectArtifact.getVersion());
                versioning.updateTimestamp();
                ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(projectArtifact, versioning);
                projectArtifact.addMetadata((ArtifactMetadata)metadata);
                GroupRepositoryMetadata groupMetadata = new GroupRepositoryMetadata(project.getGroupId());
                groupMetadata.addPluginMapping(PluginDescriptor.getGoalPrefixFromArtifactId((String)project.getArtifactId()), project.getArtifactId(), project.getName());
                projectArtifact.addMetadata((ArtifactMetadata)groupMetadata);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("TODO", e);
        }
        super.projectStarted(event);
    }

    @Override
    public void mojoStarted(ExecutionEvent event) {
        ++this.mojosStarted;
        super.mojoStarted(event);
    }

    @Override
    public void mojoSucceeded(ExecutionEvent event) {
        if (this.mojosStarted == 1) {
            this.firstSuccess = true;
        }
        super.mojoSucceeded(event);
    }

    @Override
    public void mojoFailed(ExecutionEvent event) {
        super.mojoFailed(event);
    }

    public boolean isFirstSuccess() {
        return this.firstSuccess;
    }
}

