/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oneandone.maven.plugins.prerelease.util.Maven;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.util.Separator;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;

public abstract class Base
extends AbstractMojo {
    @Parameter(property="prerelease.storages", defaultValue="${settings.localRepository}/../prereleases", required=true)
    private List<String> storages;
    @Parameter(property="prerelease.lockTimeout", defaultValue="3600", required=true)
    protected int lockTimeout;
    @Parameter(property="prerelease.keep", defaultValue="1", required=true)
    protected int keep;
    @Parameter(property="prerelease.args", defaultValue="")
    private String propertyArgs;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="project.remoteArtifactRepositories", readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Component
    protected MavenSession session;
    protected final World world = new World();

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("user-properties: " + this.session.getUserProperties()));
        try {
            this.doExecute();
        }
        catch (RuntimeException | MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("plugin failed: " + e.getMessage(), e);
        }
    }

    public abstract void doExecute() throws Exception;

    protected Map<String, String> propertyArgs() throws MojoExecutionException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.propertyArgs != null) {
            for (String entry : Separator.SPACE.split((CharSequence)this.propertyArgs)) {
                String value;
                String key;
                if (!entry.startsWith("-D")) {
                    throw new MojoExecutionException("-Dkey=value expected, got " + entry);
                }
                int idx = (entry = entry.substring(2)).indexOf(61);
                if (idx == -1) {
                    key = entry;
                    value = "true";
                } else {
                    key = entry.substring(0, idx).trim();
                    value = entry.substring(idx + 1).trim();
                }
                result.put(key, value);
            }
        }
        return result;
    }

    protected Maven maven() {
        return new Maven(this.world, this.session, this.localRepository, this.session.getRequest().getExecutionListener(), this.projectHelper, this.projectBuilder, this.remoteRepositories);
    }

    protected List<FileNode> storages() throws IOException {
        if (this.storages.size() == 0) {
            throw new IOException("expected at least 1 storage");
        }
        ArrayList<FileNode> result = new ArrayList<FileNode>(this.storages.size());
        for (String s : this.storages) {
            result.add(this.world.file(new File(s).getCanonicalFile()));
        }
        return result;
    }

    protected String version() {
        String result = ((Object)((Object)this)).getClass().getPackage().getSpecificationVersion();
        return result == null ? "unknown" : result;
    }
}

