/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.BuilderCommon;
import org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;

public class PatchedBuilderCommon
extends BuilderCommon {
    private final LifecycleModuleBuilder builder;
    private final Field field;
    private final BuilderCommon bc;
    private final boolean filter;
    private final DefaultLifecycles defaultLifecycles;

    public static PatchedBuilderCommon install(PlexusContainer container, boolean filter) {
        PatchedBuilderCommon result;
        try {
            LifecycleModuleBuilder builder = (LifecycleModuleBuilder)container.lookup(LifecycleModuleBuilder.class);
            Field field = builder.getClass().getDeclaredField("builderCommon");
            field.setAccessible(true);
            result = new PatchedBuilderCommon(builder, field, (BuilderCommon)field.get(builder), filter, (DefaultLifecycles)container.lookup(DefaultLifecycles.class));
            field.set(builder, (Object)result);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public PatchedBuilderCommon(LifecycleModuleBuilder builder, Field field, BuilderCommon bc, boolean filter, DefaultLifecycles defaultLifecyles) {
        this.builder = builder;
        this.field = field;
        this.bc = bc;
        this.filter = filter;
        this.defaultLifecycles = defaultLifecyles;
    }

    public void uninstall() {
        try {
            this.field.set(this.builder, this.bc);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public MavenExecutionPlan resolveBuildPlan(MavenSession session, MavenProject project, TaskSegment taskSegment, Set<Artifact> projectArtifacts) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException, LifecycleExecutionException {
        MavenExecutionPlan result = this.bc.resolveBuildPlan(session, project, taskSegment, projectArtifacts);
        return this.filter ? this.filtered(result) : result;
    }

    public void handleBuildError(ReactorContext buildContext, MavenSession rootSession, MavenProject mavenProject, Exception e, long buildStartTime) {
        this.bc.handleBuildError(buildContext, rootSession, mavenProject, e, buildStartTime);
    }

    private MavenExecutionPlan filtered(MavenExecutionPlan base) {
        ArrayList<ExecutionPlanItem> lst = new ArrayList<ExecutionPlanItem>();
        for (ExecutionPlanItem item : base) {
            if (!"deploy".equals(item.getLifecyclePhase())) continue;
            lst.add(item);
        }
        return new MavenExecutionPlan(lst, this.defaultLifecycles);
    }
}

