/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.core;

import java.io.IOException;
import net.oneandone.maven.plugins.prerelease.core.Prerelease;
import net.oneandone.maven.plugins.prerelease.util.Subversion;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.launcher.Launcher;
import org.apache.maven.plugin.logging.Log;

public class Target {
    public static final String REMOVE = "REMOVE";
    private FileNode directory;
    private final long revision;

    public Target(FileNode directory, long revision) {
        this.directory = directory;
        this.revision = revision;
    }

    public boolean exists() {
        return this.directory.exists();
    }

    public Prerelease loadOpt() throws IOException {
        return this.exists() ? Prerelease.load(this) : null;
    }

    public FileNode join(String ... paths) {
        return this.directory.join(paths);
    }

    public void scheduleRemove(Log log, String message) throws IOException {
        FileNode remove = this.removeDirectory();
        log.info((CharSequence)(message + " - moving prerelease to " + remove));
        this.directory.move((Node)remove);
        remove.join(new String[]{"CAUSE"}).writeString(message);
        this.directory = remove;
    }

    public long getRevision() {
        return this.revision;
    }

    public void create() throws IOException {
        this.removeDirectory().deleteTreeOpt();
        this.directory.mkdirs();
    }

    public Launcher svnLauncher(String ... args) {
        return Subversion.launcher(this.directory, args);
    }

    private FileNode removeDirectory() {
        return this.directory.getParent().join(new String[]{REMOVE});
    }

    public boolean checkoutLinkOpt(String path) throws IOException {
        if (path == null) {
            return false;
        }
        if ((path = path.trim()).isEmpty()) {
            return false;
        }
        return this.checkoutLink(this.directory.getWorld().file(path));
    }

    public boolean checkoutLink(FileNode checkoutLink) throws IOException {
        FileNode tags = this.directory.join(new String[]{"tags"});
        if (!tags.exists()) {
            return false;
        }
        FileNode workingCopy = null;
        for (FileNode file : tags.list()) {
            if (!file.isDirectory() || file.getName().startsWith(".")) continue;
            if (workingCopy != null) {
                throw new IllegalStateException();
            }
            workingCopy = file;
        }
        if (workingCopy == null) {
            return false;
        }
        checkoutLink.deleteTreeOpt();
        checkoutLink.getParent().mkdirsOpt();
        workingCopy.link((Node)checkoutLink);
        return true;
    }

    public String toString() {
        return this.directory.toString();
    }
}

