/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.core;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import net.oneandone.maven.plugins.prerelease.core.Target;
import net.oneandone.maven.plugins.prerelease.util.ChangesXml;
import net.oneandone.sushi.fs.DirectoryNotFoundException;
import net.oneandone.sushi.fs.FileNotFoundException;
import net.oneandone.sushi.fs.ListException;
import net.oneandone.sushi.fs.MkfileException;
import net.oneandone.sushi.fs.OnShutdown;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.xml.XmlException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.xml.sax.SAXException;

public class Archive
implements AutoCloseable {
    private final List<FileNode> directories;
    private boolean opened = false;
    private boolean closed = false;
    private static int pid = 0;

    public static List<FileNode> directories(List<FileNode> storages, MavenProject project) {
        ArrayList<FileNode> directories = new ArrayList<FileNode>(storages.size());
        for (FileNode storage : storages) {
            directories.add(storage.join(new String[]{project.getGroupId(), project.getArtifactId()}));
        }
        return directories;
    }

    public static Archive tryOpen(List<FileNode> directories) {
        try {
            return Archive.open(directories, -1, null);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Archive open(List<FileNode> directories, int timeout, Log log) throws IOException {
        Archive archive = new Archive(directories);
        archive.open(timeout, log);
        return archive;
    }

    private Archive(List<FileNode> directories) {
        if (directories.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.directories = directories;
    }

    public Target target(long revision) {
        String name = Long.toString(revision);
        for (int i = this.directories.size() - 1; i >= 0; --i) {
            FileNode prerelease = this.directories.get(i).join(new String[]{name});
            if (i != 0 && !prerelease.exists()) continue;
            return new Target(prerelease, revision);
        }
        throw new IllegalStateException();
    }

    public TreeMap<Long, FileNode> list() throws ListException, DirectoryNotFoundException {
        TreeMap<Long, FileNode> result = new TreeMap<Long, FileNode>();
        for (FileNode directory : this.directories) {
            if (!directory.exists()) continue;
            for (FileNode prerelease : directory.list()) {
                if (prerelease.getName().equals("REMOVE")) continue;
                long revision = Long.parseLong(prerelease.getName());
                result.put(revision, prerelease);
            }
        }
        return result;
    }

    public long latest() throws ListException, DirectoryNotFoundException {
        return this.list().lastKey();
    }

    private FileNode lockFile() {
        FileNode primary = this.directories.get(0);
        return primary.getParent().join(new String[]{primary.getName() + ".LOCK"});
    }

    private void open(int timeout, Log log) throws IOException {
        if (this.opened) {
            throw new IllegalStateException();
        }
        FileNode file = this.lockFile();
        try {
            int seconds = 0;
            while (true) {
                file.getParent().mkdirsOpt();
                try {
                    file.mkfile();
                    OnShutdown.get().deleteAtExit(file);
                    this.opened = true;
                    file.writeString(Integer.toString(Archive.pid()));
                    if (log != null) {
                        log.debug((CharSequence)("locked for pid " + Archive.pid()));
                    }
                    return;
                }
                catch (MkfileException e) {
                    if (seconds > timeout) {
                        if (log != null) {
                            log.warn((CharSequence)("Lock timed out after " + seconds + "s."));
                        }
                        throw e;
                    }
                    if (seconds % 10 == 0 && log != null) {
                        log.info((CharSequence)("Waiting for " + file + ": " + seconds + "s"));
                        log.debug((Throwable)e);
                    }
                    ++seconds;
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            if (log != null) {
                log.warn((CharSequence)"interrupted");
            }
            return;
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.opened) {
            throw new IllegalStateException("not opened");
        }
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        FileNode file = this.lockFile();
        file.deleteFile();
        OnShutdown.get().dontDeleteAtExit(file);
        this.closed = true;
    }

    public static int pid() {
        if (pid == 0) {
            String str = ManagementFactory.getRuntimeMXBean().getName();
            int idx = str.indexOf(64);
            if (idx == -1) {
                throw new IllegalStateException("cannot guess pid from " + str);
            }
            pid = Integer.parseInt(str.substring(0, idx));
        }
        return pid;
    }

    public static boolean adjustChangesOpt(FileNode workingCopy, String version) throws XmlException, IOException, SAXException {
        ChangesXml changes;
        try {
            changes = ChangesXml.load(workingCopy);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        changes.releaseDate(version, new Date());
        changes.save();
        return true;
    }

    public void wipe(int keep) throws IOException {
        if (keep < 1) {
            throw new IllegalArgumentException("keep " + keep);
        }
        for (FileNode directory : this.directories) {
            FileNode d = directory.join(new String[]{"REMOVE"});
            if (!d.isDirectory()) continue;
            d.deleteTree();
        }
        TreeMap<Long, FileNode> prereleases = this.list();
        while (prereleases.size() > keep) {
            prereleases.remove(prereleases.firstKey()).deleteTree();
        }
    }
}

