/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.maven.plugins.prerelease.Base;
import net.oneandone.maven.plugins.prerelease.core.Archive;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="swap", requiresProject=false)
public class Swap
extends Base {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() throws Exception {
        int count = 0;
        List<FileNode> storages = this.storages();
        for (int level = storages.size() - 1; level >= 0; --level) {
            FileNode storage = storages.get(level);
            this.getLog().info((CharSequence)("checking storage: " + storage.getAbsolute()));
            List archives = storage.find(new String[]{"*/*"});
            for (Node candidate : archives) {
                if (!candidate.isDirectory()) continue;
                String relative = candidate.getRelative((Node)storage);
                Archive archive = Archive.tryOpen(Swap.directories(storages, relative));
                if (archive == null) {
                    this.getLog().info((CharSequence)("skipped because it is locked: " + relative));
                    continue;
                }
                try {
                    archive.wipe(this.keep);
                    for (FileNode src : archive.list().values()) {
                        if (!src.join(new String[]{"prerelease.properties"}).readString().contains("prerelease=")) {
                            this.getLog().info((CharSequence)("skipped -- prerelease version too old: " + relative));
                            continue;
                        }
                        if (level == storages.size() - 1) {
                            this.getLog().info((CharSequence)("already in final storage: " + src));
                            continue;
                        }
                        FileNode dest = storages.get(level + 1).join(new String[]{relative, src.getName()});
                        dest.getParent().mkdirsOpt();
                        src.move((Node)dest);
                        this.getLog().info((CharSequence)("swapped " + src.getAbsolute() + " -> " + dest.getAbsolute()));
                        ++count;
                    }
                }
                finally {
                    archive.close();
                }
            }
        }
        this.getLog().info((CharSequence)(count + " archives swapped."));
    }

    private static List<FileNode> directories(List<FileNode> storages, String relative) {
        ArrayList<FileNode> result = new ArrayList<FileNode>();
        for (FileNode storage : storages) {
            result.add(storage.join(new String[]{relative}));
        }
        return result;
    }
}

