/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease;

import java.io.IOException;
import net.oneandone.maven.plugins.prerelease.ProjectBase;
import net.oneandone.maven.plugins.prerelease.core.Archive;
import net.oneandone.maven.plugins.prerelease.core.Prerelease;
import net.oneandone.maven.plugins.prerelease.core.WorkingCopy;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build")
public class Build
extends ProjectBase {
    @Parameter(property="prerelease.build", defaultValue="verify")
    protected String[] arguments;
    @Parameter(property="prerelease.buildRevision", required=false)
    private String buildRevision;

    @Override
    public void doExecute(Archive archive) throws Exception {
        if (this.buildRevision == null) {
            WorkingCopy workingCopy = this.checkedWorkingCopy();
            this.setTarget(archive.target(workingCopy.revision()));
        } else {
            this.setTarget(archive.target(this.revisionForDescriptor(archive)));
        }
        Prerelease prerelease = this.target.loadOpt();
        if (prerelease == null) {
            throw new MojoExecutionException("no prerelease for revision " + this.target.getRevision());
        }
        this.maven().build(prerelease.checkout, this.propertyArgs(), this.arguments);
    }

    private long revisionForDescriptor(Archive archive) throws MojoExecutionException, IOException {
        if ("LATEST_PRERELEASE".equals(this.buildRevision)) {
            long result = archive.latest();
            if (result == -1L) {
                throw new MojoExecutionException("no existing prerelease");
            }
            return result;
        }
        return Long.parseLong(this.buildRevision);
    }
}

