/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.oneandone.maven.plugins.prerelease.core.CannotBumpVersion;
import net.oneandone.maven.plugins.prerelease.core.CannotDeterminTagBase;
import net.oneandone.maven.plugins.prerelease.core.MissingDeveloperConnection;
import net.oneandone.maven.plugins.prerelease.core.MissingScmTag;
import net.oneandone.maven.plugins.prerelease.core.Project;
import net.oneandone.maven.plugins.prerelease.core.TagAlreadyExists;
import net.oneandone.maven.plugins.prerelease.core.Target;
import net.oneandone.maven.plugins.prerelease.core.VersioningProblem;
import net.oneandone.maven.plugins.prerelease.util.Subversion;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.util.Strings;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;

public class Descriptor {
    private static final String PRERELEASE = "prerelease";
    private static final String SVN_ORIG = "svn.orig";
    private static final String SVN_TAG = "svn.tag";
    private static final String PROJECT_GROUP_ID = "project.groupId";
    private static final String PROJECT_ARTIFACT_ID = "project.artifactId";
    private static final String PROJECT_VERSION = "project.version";
    private static final String DEPLOY_REPOSITORY = "deployRepository";
    private static final String DEPLOY_PLUGIN_METADATA = "deployPluginMetadata";
    private static final String PREVIOUS = "previous";
    private static final String NEXT = "next";
    private static final String DEPLOY_PROPERTIES = "deployProperties.";
    public final String prerelease;
    public final long revision;
    public final String svnOrig;
    public final String svnTag;
    public final Project project;
    public final String deployRepository;
    public final boolean deployPluginMetadata;
    public final String previous;
    public final String next;
    public final Map<String, String> deployProperties;

    public static Descriptor load(Target target) throws IOException {
        Properties properties = new Properties();
        InputStream src = Descriptor.file(target).createInputStream();
        properties.load(src);
        return new Descriptor(Descriptor.get(properties, PRERELEASE), target.getRevision(), Descriptor.get(properties, SVN_ORIG), Descriptor.get(properties, SVN_TAG), new Project(Descriptor.get(properties, PROJECT_GROUP_ID), Descriptor.get(properties, PROJECT_ARTIFACT_ID), Descriptor.get(properties, PROJECT_VERSION)), Descriptor.get(properties, DEPLOY_REPOSITORY), "true".equals(Descriptor.get(properties, DEPLOY_PLUGIN_METADATA)), Descriptor.get(properties, PREVIOUS), Descriptor.get(properties, NEXT), Descriptor.getProperties(properties, DEPLOY_PROPERTIES));
    }

    public static Descriptor create(String prerelease, MavenProject mavenProject, long revision) throws MissingScmTag, MissingDeveloperConnection, CannotBumpVersion, CannotDeterminTagBase {
        String svnOrig = Descriptor.getSvnUrl(mavenProject);
        String svnTag = Descriptor.tagurl(svnOrig, mavenProject);
        Project project = Project.forMavenProject(mavenProject, Descriptor.releaseVersion(mavenProject));
        DeploymentRepository repo = mavenProject.getDistributionManagement().getRepository();
        return new Descriptor(prerelease, revision, svnOrig, svnTag, project, repo.getId() + "::" + repo.getUrl(), "maven-plugin".equals(mavenProject.getPackaging()), mavenProject.getVersion(), Descriptor.next(project.version), new HashMap<String, String>());
    }

    public static Descriptor checkedCreate(World world, String prerelease, MavenProject mavenProject, long revision) throws CannotDeterminTagBase, MissingScmTag, CannotBumpVersion, MissingDeveloperConnection, TagAlreadyExists, VersioningProblem {
        return Descriptor.create(prerelease, mavenProject, revision).check(world, mavenProject);
    }

    public Descriptor(String prerelease, long revision, String svnOrig, String svnTag, Project project, String deployRepository, boolean deployPluginMetadata, String previous, String next, Map<String, String> deployProperties) {
        if (svnOrig.endsWith("/")) {
            throw new IllegalArgumentException(svnOrig);
        }
        if (svnTag.endsWith("/")) {
            throw new IllegalArgumentException(svnTag);
        }
        this.prerelease = prerelease;
        this.revision = revision;
        this.svnOrig = svnOrig;
        this.svnTag = svnTag;
        this.project = project;
        this.deployRepository = deployRepository;
        this.deployPluginMetadata = deployPluginMetadata;
        this.previous = previous;
        this.next = next;
        this.deployProperties = deployProperties;
    }

    public Descriptor check(World world, MavenProject mavenProject) throws TagAlreadyExists, VersioningProblem, CannotDeterminTagBase, MissingScmTag, CannotBumpVersion, MissingDeveloperConnection {
        ArrayList<String> problems = new ArrayList<String>();
        Descriptor.checkSnapshot("project", mavenProject.getVersion(), problems);
        MavenProject parent = mavenProject.getParent();
        if (parent != null) {
            Descriptor.checkRelease("project parent", parent.getVersion(), problems);
        }
        for (Dependency dependency : mavenProject.getDependencies()) {
            Descriptor.checkRelease(dependency.getGroupId() + ":" + dependency.getArtifactId(), dependency.getVersion(), problems);
        }
        for (Artifact artifact : mavenProject.getPluginArtifacts()) {
            if ("net.oneandone.maven.plugins".equals(artifact.getGroupId()) && PRERELEASE.equals(artifact.getArtifactId())) continue;
            Descriptor.checkRelease(artifact.getGroupId() + ":" + artifact.getArtifactId(), artifact.getVersion(), problems);
        }
        if (problems.size() > 0) {
            throw new VersioningProblem(problems);
        }
        if (Subversion.exists(world.getTemp(), this.svnTag)) {
            throw new TagAlreadyExists(this.svnTag);
        }
        return this;
    }

    public String getName() {
        return Long.toString(this.revision);
    }

    public String getTagName() {
        int idx = this.svnTag.lastIndexOf(47);
        return this.svnTag.substring(idx + 1);
    }

    public void save(Target target) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(PRERELEASE, this.prerelease);
        properties.setProperty(SVN_ORIG, this.svnOrig);
        properties.setProperty(SVN_TAG, this.svnTag);
        properties.setProperty(DEPLOY_REPOSITORY, this.deployRepository);
        properties.setProperty(DEPLOY_PLUGIN_METADATA, Boolean.toString(this.deployPluginMetadata));
        properties.setProperty(PREVIOUS, this.previous);
        properties.setProperty(PROJECT_GROUP_ID, this.project.groupId);
        properties.setProperty(PROJECT_ARTIFACT_ID, this.project.artifactId);
        properties.setProperty(PROJECT_VERSION, this.project.version);
        properties.setProperty(NEXT, this.next);
        for (Map.Entry<String, String> entry : this.deployProperties.entrySet()) {
            properties.setProperty(DEPLOY_PROPERTIES + entry.getKey(), entry.getValue());
        }
        OutputStream dest = Descriptor.file(target).createOutputStream(false);
        properties.store(dest, "");
        dest.close();
    }

    private static void checkRelease(String where, String version, List<String> problems) {
        if (version.endsWith("-SNAPSHOT")) {
            problems.add(where + ": expected release version, got " + version);
        }
    }

    private static void checkSnapshot(String where, String version, List<String> problems) {
        if (!version.endsWith("-SNAPSHOT")) {
            problems.add(where + ": expected snapshot version, got " + version);
        }
    }

    public static String getSvnUrl(MavenProject project) throws MissingScmTag, MissingDeveloperConnection {
        Scm scm = project.getScm();
        if (scm == null) {
            throw new MissingScmTag();
        }
        String result = scm.getDeveloperConnection();
        if (result == null) {
            throw new MissingDeveloperConnection();
        }
        return Strings.removeRightOpt((String)Strings.removeLeft((String)result, (String)"scm:svn:"), (String)"/");
    }

    public static String releaseVersion(MavenProject project) {
        return Strings.removeRight((String)project.getVersion(), (String)"-SNAPSHOT");
    }

    public static String tagurl(String svnurl, MavenProject project) throws CannotDeterminTagBase {
        int idx = (svnurl = svnurl + "/").indexOf("/trunk/");
        if (idx == -1 && (idx = svnurl.indexOf("/branches/")) == -1) {
            throw new CannotDeterminTagBase(svnurl);
        }
        return svnurl.substring(0, idx) + "/tags" + "/" + project.getArtifactId() + "-" + Descriptor.releaseVersion(project);
    }

    public static String next(String version) throws CannotBumpVersion {
        int num;
        int idx = version.lastIndexOf(46);
        if (idx == -1) {
            throw new CannotBumpVersion(version);
        }
        try {
            num = Integer.parseInt(version.substring(idx + 1));
        }
        catch (NumberFormatException e) {
            throw new CannotBumpVersion(version, e);
        }
        return version.substring(0, idx + 1) + ++num + "-SNAPSHOT";
    }

    private static String get(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new IllegalStateException("missing key: " + key);
        }
        return value;
    }

    private static Map<String, String> getProperties(Properties properties, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            result.put(key.substring(prefix.length()), (String)entry.getValue());
        }
        return result;
    }

    public static FileNode file(Target target) {
        return target.join("prerelease.properties");
    }
}

