/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.oneandone.maven.plugins.prerelease.Base;
import net.oneandone.maven.plugins.prerelease.core.Archive;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="swap", requiresProject=false)
public class Swap
extends Base {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() throws Exception {
        HashSet<String> done = new HashSet<String>();
        List<FileNode> storages = this.storages();
        for (Node node : this.storages()) {
            List archives = node.find(new String[]{"*/*"});
            for (Node candidate : archives) {
                String relative;
                if (!candidate.isDirectory() || !done.add(relative = candidate.getRelative(node))) continue;
                Archive archive = Archive.tryOpen(Swap.directories(storages, relative));
                if (archive == null) {
                    this.getLog().info((CharSequence)("skipped because it is locked: " + relative));
                    continue;
                }
                try {
                    archive.wipe(this.keep);
                    for (FileNode src : archive.list().values()) {
                        if (!src.join(new String[]{"prerelease.properties"}).readString().contains("prerelease=")) {
                            this.getLog().info((CharSequence)"skipped -- prerelease version too old");
                            continue;
                        }
                        FileNode dest = Swap.nextStorage(storages, src);
                        if (dest == null) {
                            this.getLog().info((CharSequence)("already in final storage: " + src));
                            continue;
                        }
                        dest = dest.join(new String[]{relative, src.getName()});
                        dest.getParent().mkdirsOpt();
                        src.move((Node)dest);
                        this.getLog().info((CharSequence)("swapped " + src.getAbsolute() + " -> " + dest.getAbsolute()));
                    }
                }
                finally {
                    archive.close();
                }
            }
        }
        this.getLog().info((CharSequence)(done.size() + " archives processed."));
    }

    private static FileNode nextStorage(List<FileNode> storages, FileNode prerelease) {
        int max = storages.size();
        for (int i = 0; i < max; ++i) {
            FileNode storage = storages.get(i);
            if (!prerelease.hasAnchestor((Node)storage)) continue;
            if (i + 1 < max) {
                return storages.get(i + 1);
            }
            return null;
        }
        throw new IllegalStateException(prerelease.getAbsolute());
    }

    private static List<FileNode> directories(List<FileNode> storages, String relative) {
        ArrayList<FileNode> result = new ArrayList<FileNode>();
        for (FileNode storage : storages) {
            result.add(storage.join(new String[]{relative}));
        }
        return result;
    }
}

