/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.oneandone.maven.plugins.prerelease.Base;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.io.OS;
import net.oneandone.sushi.util.Separator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="locksmith", requiresProject=false)
public class Locksmith
extends Base {
    @Parameter(property="prerelease.locksmith.fail")
    private boolean fail = false;
    @Parameter(property="prerelease.locksmith.delete")
    private boolean delete = false;
    private static final long COUNT = 3L;
    private static final long HOUR = 3600000L;
    private static final SimpleDateFormat TODAY = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat OTHER = new SimpleDateFormat("MMM dd", Locale.US);
    private static final SimpleDateFormat MAC = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");

    @Override
    public void doExecute() throws Exception {
        Map<String, Long> started = this.startedMap();
        int errors = 0;
        FileNode primary = this.storages().get(0);
        if (!primary.exists()) {
            return;
        }
        List locks = primary.find(new String[]{"*/*.LOCK"});
        for (Node file : locks) {
            String pid = file.readString();
            if (pid.trim().isEmpty()) {
                this.getLog().info((CharSequence)(file + ": old lock file format"));
                if (System.currentTimeMillis() - file.getLastModified() < 10800000L) {
                    this.getLog().info((CharSequence)"> younger than 3 hours - considered ok");
                    continue;
                }
            } else {
                Long time = started.get(pid);
                if (time == null) {
                    this.getLog().info((CharSequence)(file + ": stale lock - no process with id " + pid));
                } else if (file.getLastModified() < time) {
                    this.getLog().info((CharSequence)(file + ": stale lock - process with id " + pid + " younger than lock file"));
                } else {
                    this.getLog().debug((CharSequence)(file + " ok"));
                    continue;
                }
            }
            ++errors;
            if (!this.delete) continue;
            this.getLog().info((CharSequence)("deleting " + file));
            file.deleteFile();
        }
        this.getLog().info((CharSequence)("locks checked: " + locks.size() + ", locks stale: " + errors));
        if (errors > 0 && this.fail) {
            throw new MojoExecutionException("stale locks: " + errors);
        }
    }

    private Map<String, Long> startedMap() throws IOException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        boolean first = true;
        String[] cmd = OS.CURRENT == OS.MAC ? new String[]{"ps", "ax", "-o", "pid", "-o", "lstart"} : new String[]{"ps", "ax", "--format", "pid,start"};
        for (String line : Separator.RAW_LINE.split((CharSequence)((FileNode)this.world.getWorking()).exec(cmd))) {
            Date startedDate;
            if (first) {
                if (!line.contains("PID")) {
                    throw new IllegalStateException(line);
                }
                first = false;
                continue;
            }
            int idx = (line = line.trim()).indexOf(32);
            if (idx == -1) {
                throw new IllegalStateException(line);
            }
            String pid = line.substring(0, idx);
            String startedStr = line.substring(idx + 1).trim();
            try {
                startedDate = OS.CURRENT == OS.MAC ? MAC.parse(startedStr) : (startedStr.indexOf(58) == -1 ? OTHER : TODAY).parse(startedStr);
            }
            catch (ParseException e) {
                throw new IllegalStateException("invalid date in line " + line, e);
            }
            result.put(pid, startedDate.getTime());
        }
        return result;
    }
}

