/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease;

import java.util.HashMap;
import java.util.Map;
import net.oneandone.maven.plugins.prerelease.Base;
import net.oneandone.maven.plugins.prerelease.util.Maven;
import net.oneandone.maven.plugins.prerelease.util.Subversion;
import net.oneandone.sushi.fs.file.FileNode;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class BareBase
extends Base {
    public static final String LASTEST_PRERELEASE = "LATEST_PRERELEASE";
    public static final String HEAD = "HEAD";
    private final String goal;
    @Parameter(property="prerelease.svnurl", required=true)
    private String svnurl;
    @Parameter(property="prerelease.revision", defaultValue="HEAD", required=true)
    protected String revision;
    @Parameter(property="prerelease.checkoutLink")
    private String checkoutLink;

    protected BareBase(String goal) {
        this.goal = goal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() throws Exception {
        Maven maven = this.maven();
        FileNode tempCheckout = this.tempCheckout();
        try {
            maven.build(tempCheckout, this.userProperties(), "net.oneandone.maven.plugins:prerelease:" + this.goal);
        }
        finally {
            tempCheckout.deleteTree();
        }
    }

    public Map<String, String> userProperties() {
        return new HashMap<String, String>();
    }

    private FileNode tempCheckout() throws Exception {
        FileNode result = ((FileNode)this.world.getWorking()).createTempDirectory();
        Subversion.sparseCheckout(this.getLog(), result, this.svnurl, this.revisionForPomLoading(), false);
        return result;
    }

    private String revisionForPomLoading() {
        if (LASTEST_PRERELEASE.equals(this.revision)) {
            return HEAD;
        }
        if (HEAD.equals(this.revision)) {
            return HEAD;
        }
        return this.revision;
    }
}

