/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.core;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import net.oneandone.maven.plugins.prerelease.core.Archive;
import net.oneandone.maven.plugins.prerelease.core.Descriptor;
import net.oneandone.maven.plugins.prerelease.core.Target;
import net.oneandone.maven.plugins.prerelease.util.ChangesXml;
import net.oneandone.maven.plugins.prerelease.util.Maven;
import net.oneandone.maven.plugins.prerelease.util.PrepareExecutionListener;
import net.oneandone.maven.plugins.prerelease.util.Subversion;
import net.oneandone.maven.plugins.prerelease.util.Transform;
import net.oneandone.sushi.fs.FileNotFoundException;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.launcher.Failure;
import net.oneandone.sushi.launcher.Launcher;
import net.oneandone.sushi.util.Strings;
import net.oneandone.sushi.util.Substitution;
import net.oneandone.sushi.util.SubstitutionException;
import net.oneandone.sushi.xml.XmlException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.xml.sax.SAXException;

public class Prerelease {
    public final Target target;
    public final FileNode checkout;
    public final Descriptor descriptor;

    public static Prerelease load(Target target) throws IOException {
        Descriptor descriptor = Descriptor.load(target);
        FileNode workingCopy = target.join("tags", descriptor.getTagName());
        workingCopy.checkDirectory();
        return new Prerelease(target, workingCopy, descriptor);
    }

    public static Prerelease create(Maven maven, Log log, Descriptor descriptor, Target target) throws Exception {
        Prerelease prerelease;
        log.info((CharSequence)"creating un-committed tag ...");
        if (descriptor.svnTag.endsWith("/")) {
            throw new IllegalArgumentException(descriptor.svnTag);
        }
        int idx = descriptor.svnTag.lastIndexOf(47);
        if (idx == -1) {
            throw new IllegalArgumentException(descriptor.svnTag);
        }
        String tagbase = descriptor.svnTag.substring(0, idx);
        String tagname = descriptor.svnTag.substring(idx + 1);
        target.create();
        try {
            FileNode tags = target.join("tags");
            FileNode checkout = tags.join(new String[]{tagname});
            log.debug((CharSequence)target.svnLauncher("checkout", "--depth=empty", tagbase, tags.getAbsolute()).exec());
            log.debug((CharSequence)target.svnLauncher("copy", "-r" + descriptor.revision, descriptor.svnOrig, checkout.getAbsolute()).exec());
            prerelease = new Prerelease(target, checkout, descriptor);
            prerelease.descriptor.save(target);
            Transform.adjustPom(prerelease.checkout.join(new String[]{"pom.xml"}), descriptor.previous, descriptor.project.version, descriptor.svnOrig, descriptor.svnTag);
            Archive.adjustChangesOpt(prerelease.checkout, prerelease.descriptor.project.version);
            prerelease.create(maven);
            log.info((CharSequence)("created prerelease in " + prerelease.target));
        }
        catch (Exception e) {
            target.scheduleRemove(log, "create failed: " + e.getMessage());
            throw e;
        }
        target.removeOthers();
        return prerelease;
    }

    public Prerelease(Target target, FileNode checkout, Descriptor descriptor) throws IOException {
        this.target = target;
        this.checkout = checkout;
        this.descriptor = descriptor;
    }

    public FileNode artifacts() {
        return this.target.join("artifacts");
    }

    public FileNode frischfleisch() {
        return this.target.join("frischfleisch.properties");
    }

    public void commit(Log log, String commitMessage) throws Failure {
        log.info((CharSequence)"committing tag:");
        Launcher launcher = Subversion.launcher(this.checkout, "commit", "-m", commitMessage);
        log.info((CharSequence)launcher.toString());
        log.info((CharSequence)launcher.exec());
    }

    public void revertCommit(Log log, String by) throws Failure {
        Launcher launcher = Subversion.launcher(this.checkout, "delete", "-m reverted promotion of prerelease " + this.descriptor.revision + " promoted by " + by, this.descriptor.svnTag);
        log.info((CharSequence)launcher.toString());
        log.info((CharSequence)launcher.exec());
    }

    public static Artifact artifact(String origPath) {
        String classifier;
        int idx = origPath.lastIndexOf(47);
        if (idx == -1) {
            throw new IllegalArgumentException(origPath);
        }
        String path = origPath.substring(0, idx);
        String name = origPath.substring(idx + 1);
        idx = path.lastIndexOf(47);
        if (idx == -1) {
            throw new IllegalArgumentException(origPath);
        }
        String version = path.substring(idx + 1);
        if ((idx = (path = path.substring(0, idx)).lastIndexOf(47)) == -1) {
            throw new IllegalArgumentException(origPath);
        }
        String artifactId = path.substring(idx + 1);
        String groupId = path.substring(0, idx).replace('/', '.');
        idx = name.lastIndexOf(46);
        if (idx == -1) {
            throw new IllegalArgumentException(origPath);
        }
        String extension = name.substring(idx + 1);
        if ((name = Strings.removeLeft((String)name.substring(0, idx), (String)(artifactId + "-" + version))).isEmpty()) {
            classifier = null;
        } else {
            if (!name.startsWith("-")) {
                throw new IllegalArgumentException(origPath);
            }
            classifier = name.substring(1);
        }
        return new DefaultArtifact(groupId, artifactId, classifier, extension, version);
    }

    public FileNode prepareOrigCommit(Log log) throws IOException, XmlException, SAXException, MojoExecutionException {
        ChangesXml changes;
        FileNode result = this.checkout.getWorld().getTemp().createTempDirectory();
        Subversion.sparseCheckout(log, result, this.descriptor.svnOrig, "HEAD", true);
        try {
            changes = ChangesXml.load(result);
        }
        catch (FileNotFoundException e) {
            log.info((CharSequence)"no changes.xml to adjust.");
            changes = null;
        }
        Subversion.launcher(result, "lock", "pom.xml");
        if (changes != null) {
            Subversion.launcher(result, "lock", "src/changes/changes.xml");
        }
        Subversion.launcher(result, "up");
        Transform.adjustPom(result.join(new String[]{"pom.xml"}), this.descriptor.previous, this.descriptor.next, null, null);
        if (changes != null) {
            changes.releaseDate(this.descriptor.project.version, new Date());
            changes.save();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Maven maven) throws Exception {
        try {
            maven.build(this.checkout, maven.releaseProps(), new PrepareExecutionListener(this, maven.getExecutionListener()), false, "install");
        }
        finally {
            FileNode installed = this.descriptor.project.localRepo(maven);
            if (installed.exists()) {
                installed.move((Node)this.artifacts());
            }
        }
    }

    public void verify(Maven maven, String profile) throws Exception {
        maven.build(this.checkout, "verify", "clean", "-P" + profile);
    }

    public void promote(Log log, String createTagMessage, String revertTagMessage, String nextIterationMessage, Maven maven) throws Exception {
        log.info((CharSequence)("promoting revision " + this.descriptor.revision + " to " + this.descriptor.project));
        FileNode origCommit = this.prepareOrigCommit(log);
        try {
            this.promoteLocked(log, createTagMessage, revertTagMessage, nextIterationMessage, origCommit, maven);
        }
        finally {
            this.origUnlock(origCommit);
        }
        log.info((CharSequence)("SUCCESS: released " + this.descriptor.project));
    }

    private void origUnlock(FileNode origCommit) {
        Subversion.launcher(origCommit, "unlock", "pom.xml");
        if (origCommit.join(new String[]{"src/changes/changes.xml"}).exists()) {
            Subversion.launcher(origCommit, "unlock", "src/changes/changes.xml");
        }
    }

    private void promoteLocked(Log log, String commitTagMessage, String revertTagMessage, String commitNextMessage, FileNode origCommit, Maven maven) throws Exception {
        this.commit(log, this.renderMessage(commitTagMessage));
        try {
            maven.deployOnly(log, this);
        }
        catch (Exception e) {
            log.info((CharSequence)"deployment failed - reverting tag");
            this.revertCommit(log, this.renderMessage(revertTagMessage));
            this.target.scheduleRemove(log, "deployment failed (tag has been reverted): " + e.getMessage());
            throw e;
        }
        try {
            log.info((CharSequence)"Update pom and changes ...");
            log.debug((CharSequence)Subversion.launcher(origCommit, "commit", "-m", this.renderMessage(commitNextMessage)).exec());
            origCommit.deleteTree();
            this.target.scheduleRemove(log, "prerelease has been promoted");
        }
        catch (Exception e) {
            log.warn((CharSequence)"Promote succeeded: your artifacts have been deployed, and your svn tag was created. ");
            log.warn((CharSequence)"However, some post-release step failed with this exception:");
            log.warn((Throwable)e);
            log.warn((CharSequence)"Thus, you can use your release, but someone should have a look at this exception.");
        }
    }

    public String renderMessage(String message) throws SubstitutionException {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("revision", Long.toString(this.descriptor.revision));
        variables.put("release", this.descriptor.project.toString());
        return Substitution.ant().apply(message, variables);
    }

    public void artifactFiles(MavenProject project, MavenProjectHelper projectHelper) throws IOException {
        FileNode artifacts = this.artifacts();
        for (FileNode file : artifacts.list()) {
            String type;
            String name = file.getName();
            if (name.endsWith(".md5") || name.endsWith(".sha1") || name.endsWith(".asc") || name.equals("_maven.repositories") || "pom".equals(type = file.getExtension()) && !project.getPackaging().equals("pom")) continue;
            String str = name.substring(0, name.length() - type.length() - 1);
            str = Strings.removeLeft((String)str, (String)(project.getArtifactId() + "-"));
            if ((str = Strings.removeLeft((String)str, (String)project.getVersion())).isEmpty()) {
                project.getArtifact().setFile(file.toPath().toFile());
                continue;
            }
            String classifier = Strings.removeLeft((String)str, (String)"-");
            projectHelper.attachArtifact(project, type, classifier, file.toPath().toFile());
        }
    }
}

