/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.core;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Date;
import net.oneandone.maven.plugins.prerelease.core.Target;
import net.oneandone.maven.plugins.prerelease.util.ChangesXml;
import net.oneandone.sushi.fs.DirectoryNotFoundException;
import net.oneandone.sushi.fs.FileNotFoundException;
import net.oneandone.sushi.fs.ListException;
import net.oneandone.sushi.fs.MkfileException;
import net.oneandone.sushi.fs.OnShutdown;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.xml.XmlException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.xml.sax.SAXException;

public class Archive
implements AutoCloseable {
    public final FileNode directory;
    private boolean opened = false;
    private boolean closed = false;
    private static int pid = 0;

    public static FileNode directory(FileNode archiveRoot, MavenProject project) {
        return archiveRoot.join(new String[]{project.getGroupId(), project.getArtifactId()});
    }

    public static Archive open(FileNode directory, int timeout, Log log) throws IOException {
        Archive archive = new Archive(directory);
        archive.open(timeout, log);
        return archive;
    }

    public static long latest(FileNode directory) throws ListException, DirectoryNotFoundException {
        long result = -1L;
        if (directory.exists()) {
            for (FileNode prerelease : directory.list()) {
                long revision;
                try {
                    revision = Long.parseLong(prerelease.getName());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (revision <= result) continue;
                result = revision;
            }
        }
        return result;
    }

    private Archive(FileNode directory) {
        this.directory = directory;
    }

    public Target target(long revision) {
        return new Target(this.directory.join(new String[]{Long.toString(revision)}), revision);
    }

    private FileNode lockFile() {
        return this.directory.getParent().join(new String[]{this.directory.getName() + ".LOCK"});
    }

    private void open(int timeout, Log log) throws IOException {
        if (this.opened) {
            throw new IllegalStateException();
        }
        FileNode file = this.lockFile();
        try {
            int seconds = 0;
            while (true) {
                file.getParent().mkdirsOpt();
                try {
                    file.mkfile();
                    OnShutdown.get().deleteAtExit(file);
                    this.opened = true;
                    file.writeString(Integer.toString(Archive.pid()));
                    log.debug((CharSequence)("locked for pid " + Archive.pid()));
                    return;
                }
                catch (MkfileException e) {
                    if (seconds > timeout) {
                        log.warn((CharSequence)("Lock timed out after " + seconds + "s."));
                        throw e;
                    }
                    if (seconds % 10 == 0) {
                        log.info((CharSequence)("Waiting for " + file + ": " + seconds + "s"));
                        log.debug((Throwable)e);
                    }
                    ++seconds;
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            log.warn((CharSequence)"interrupted");
            return;
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.opened) {
            throw new IllegalStateException("not opened");
        }
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        FileNode file = this.lockFile();
        file.deleteFile();
        OnShutdown.get().dontDeleteAtExit(file);
        this.closed = true;
    }

    public static int pid() {
        if (pid == 0) {
            String str = ManagementFactory.getRuntimeMXBean().getName();
            int idx = str.indexOf(64);
            if (idx == -1) {
                throw new IllegalStateException("cannot guess pid from " + str);
            }
            pid = Integer.parseInt(str.substring(0, idx));
        }
        return pid;
    }

    public static boolean adjustChangesOpt(FileNode workingCopy, String version) throws XmlException, IOException, SAXException {
        ChangesXml changes;
        try {
            changes = ChangesXml.load(workingCopy);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        changes.releaseDate(version, new Date());
        changes.save();
        return true;
    }
}

