/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease;

import net.oneandone.maven.plugins.prerelease.ProjectBase;
import net.oneandone.maven.plugins.prerelease.core.Archive;
import net.oneandone.maven.plugins.prerelease.core.Prerelease;
import net.oneandone.maven.plugins.prerelease.core.WorkingCopy;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="promote")
public class Promote
extends ProjectBase {
    @Parameter(property="prerelease.createTagMessage", defaultValue="Prerelease ${revision} promoted to release ${release}.")
    protected String createTagMessage;
    @Parameter(property="prerelease.revertTagMessage", defaultValue="Reverting tag for release ${release} because the deployment failed.")
    protected String revertTagMessage;
    @Parameter(property="prerelease.nextIterationMessage", defaultValue="Prerelease ${revision} promoted to release ${release}, starting next development iteration.")
    protected String nextIterationMessage;

    @Override
    public void doExecute(Archive archive) throws Exception {
        WorkingCopy workingCopy = this.checkedWorkingCopy();
        long revision = workingCopy.revision();
        this.setTarget(archive.target(revision));
        Prerelease prerelease = this.target.loadOpt();
        if (prerelease == null) {
            throw new MojoExecutionException("no prerelease for revision " + revision);
        }
        prerelease.promote(this.getLog(), this.createTagMessage, this.revertTagMessage, this.nextIterationMessage, this.maven());
        workingCopy.update(this.getLog());
    }
}

