/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.xml.Selector;
import net.oneandone.sushi.xml.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ChangesXml {
    private static final String NAMESPACE_URI = "http://maven.apache.org/changes/1.0.0";
    public static final String PATH = "src/changes/changes.xml";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final FileNode dest;
    private final Document doc;
    private final Selector selector;

    public static ChangesXml load(FileNode basedir) throws IOException, SAXException {
        FileNode dest = basedir.join(new String[]{PATH});
        return new ChangesXml(dest, dest.readXml());
    }

    public ChangesXml(FileNode dest, Document doc) {
        this.dest = dest;
        this.doc = doc;
        this.selector = dest.getWorld().getXml().getSelector();
        this.selector.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if ("a".equals(prefix)) {
                    return ChangesXml.NAMESPACE_URI;
                }
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public void releaseDate(String version, Date date) throws XmlException {
        Element release = this.selector.elementOpt((Node)this.doc, "/a:document/a:body/a:release[@version='" + version + "']");
        if (release == null) {
            release = this.doc.createElementNS(NAMESPACE_URI, "release");
            release.setAttribute("version", version);
            Element body = this.selector.element((Node)this.doc, "/a:document/a:body");
            body.insertBefore(release, body.getFirstChild());
        }
        release.setAttribute("date", FORMAT.format(date));
    }

    public void save() throws IOException {
        this.dest.writeXml((Node)this.doc);
    }
}

